#include <misc.h>
#include "xconf.h"
#include "components.h"

int xconf_screen (XCONFIG &xcfg)
{
	COMPONENTS comp;
	xconf_readconfall (comp,"screens.xconf","screens.*.xconf");
	char *tbopt2[4001];
	int nbopt = comp.setmenu (tbopt2);
	int ret = 0;
	if (nbopt > 0){
		int choice = 0;
		xconf_menu ("Screens list"
			,"You must select an screen from this list\n"
			 "The list is sorted by manufacturer\n"
			 "and product"
			,tbopt2,choice);
		if (choice != -1){
			COMPONENT *compo = comp.item(choice);
			xcfg.addcomment ("Screen",compo->keyw,compo->arg);
			xcfg.merge (compo->xconfig);
			xconf_notice (compo->notice);
		}
	}else{
		xconf_error (
			"No screens.xconf file could be found\n"
			"either in the current directory or in\n"
			"the directory %s\n"
			,USR_LIB_XCONF);
		ret = -1;
	}
	return ret;
}

