#pragma interface
#ifndef USERCONF_H
#define USERCONF_H

struct passwd;
struct group;

class USER;
class USERS;
class GROUPS;
class SHADOW;
class DIALOG;

#include <misc.h>

class PRIVILEGE_DECLARATOR{
public:
	PRIVILEGE_DECLARATOR *next;
	void (*fct)();
	/*~PROTOBEG~ PRIVILEGE_DECLARATOR */
public:
	PRIVILEGE_DECLARATOR (void (*_fct)());
	/*~PROTOEND~ PRIVILEGE_DECLARATOR */
};

class PRIVILEGE_DATA: public ARRAY_OBJ{
protected:
	int first_field;	// Number of the first field in the dialog
	char active;
public:
	virtual void setdialog(const char *title,DIALOG &dia)=0;
	virtual int validate()=0;
	virtual int format_ascii(char *line)=0;
	/*~PROTOBEG~ PRIVILEGE_DATA */
public:
	int has_priv (void);
	int mustident (void);
	/*~PROTOEND~ PRIVILEGE_DATA */
};

class TRANS_NOTLOAD;

class PRIVILEGE_DATAS: public ARRAY{
	/*~PROTOBEG~ PRIVILEGE_DATAS */
public:
	PRIVILEGE_DATA *getitem (int no);
	/*~PROTOEND~ PRIVILEGE_DATAS */
};

class PRIVILEGE: public ARRAY_OBJ{
	struct {
		TRANS_NOTLOAD *title;
		TRANS_NOTLOAD *section;
	}msg;
	struct {
		SSTRING title;
		SSTRING section;
	}str;
public:
	SSTRING id;		// Name of the priviledge
	PRIVILEGE *next;
	/*~PROTOBEG~ PRIVILEGE */
public:
	PRIVILEGE (const char *_id,
		 TRANS_NOTLOAD *_title,
		 TRANS_NOTLOAD *_section);
	PRIVILEGE (const char *_id,
		 const char *_title,
		 const char *_section);
	virtual PRIVILEGE_DATA *getdata (const char *user);
	const char *getsection (void);
	const char *gettitle (void);
	virtual int savedata (const char *user,
		 PRIVILEGE_DATA *data);
	~PRIVILEGE (void);
	/*~PROTOEND~ PRIVILEGE */
};

class PRIVI_FEATURE: public PRIVILEGE{
	/*~PROTOBEG~ PRIVI_FEATURE */
public:
	PRIVI_FEATURE (const char *_id,
		 TRANS_NOTLOAD *_title,
		 TRANS_NOTLOAD *_section);
	PRIVILEGE_DATA *getdata (const char *user);
	/*~PROTOEND~ PRIVI_FEATURE */
};

class PRIVILEGES: public ARRAY{
	/*~PROTOBEG~ PRIVILEGES */
public:
	PRIVILEGES (void);
	PRIVILEGE *getitem (int no);
	/*~PROTOEND~ PRIVILEGES */
};


class USER: public ARRAY_OBJ{
	SSTRING name;
	SSTRING passwd;
	int uid;
	int gid;
	SSTRING comment;
	SSTRING wrkdir;
	SSTRING shell;
	int special;	// Special user accounts like uucp and slip
			// Whatever is using a shell for non human.
	/*~PROTOBEG~ USER */
public:
	USER (const char *_name,
		 const char *_passwd,
		 int _uid,
		 int _gid,
		 const char *_gecos,
		 const char *_dir,
		 const char *_shell);
	USER (const char *line);
	USER (struct passwd *p);
	USER (void);
private:
	int check (USERS&users, GROUPS&groups, int full);
public:
	int checkhome (char *status);
	int edit (USERS&users,
		 GROUPS&groups,
		 int is_new,
		 PRIVILEGE *priv,
		 int editprivi);
	int edithispass (SHADOW *shadow);
	int edithispass_notty (SHADOW *shadow);
	int editpass (int lock_available,
		 SHADOW *shadow,
		 int confirm);
	int getcateg (void);
	const char *getgecos (void);
	int getgid (void);
	const char *getname (void);
	const char *getpwd (void);
	const char *getshell (void);
	int getuid (void);
private:
	void init (const char *_name,
		 const char *_passwd,
		 int _uid,
		 int _gid,
		 const char *_gecos,
		 const char *_dir,
		 const char *_shell);
public:
	int is_admin (void);
	int is_like (USER *other);
	int is_special (void);
	void setgecos (const char *_gecos);
	int sethome (PRIVILEGE *priv);
	void setlike (USER *other);
	void setname (const char *_name);
private:
	void update_passwd (const char *newp,
		 SHADOW *shadow,
		 int is_lock);
public:
	void write (FILE *fout);
	~USER (void);
	/*~PROTOEND~ USER */
};

class USERS: public ARRAY{
	USER *nisentry;
	int nis_at_end;		// NIS entry at the end or beginning
	class SHADOWS *shadows;
	CONFIG_FILE *configf;
	SSTRING home;		// base directory for users home directory
	int baseuid;		// Starting point for UID allocation
	/*~PROTOBEG~ USERS */
public:
	USERS (CONFIG_FILE&_file,
		 const char *_home,
		 int _baseuid);
private:
	USERS (USERS *users);
public:
	USERS (void);
	int addone (USER *special,
		 const char *name,
		 GROUPS&groups,
		 const char *fullname,
		 PRIVILEGE *priv,
		 int editprivi);
	void addshadow (SHADOW *shadow);
	int edit (USER *special,
		 PRIVILEGE *priv,
		 int editprivi);
	USER *getfromuid (int uid);
	USER *getfromuid (int uid, USER *exclude);
	USER *getitem (const char *name);
	USER *getitem (const char *name, USER *exclude);
	USER *getitem (int no);
	int getnewuid (int);
	SHADOW *getshadow (USER *usr);
	const char *getstdhome (void);
private:
	void readusers (void);
public:
	void remove_del (USER *usr);
	USER *select (USER *like,
		 int may_add,
		 MENU_STATUS&code,
		 int &choice);
private:
	USER *select_sorted (USER *like,
		 int may_add,
		 MENU_STATUS&code,
		 int &choice);
public:
	void sortbygid (void);
	void sortbyname (void);
	int write (PRIVILEGE *priv);
	~USERS (void);
	/*~PROTOEND~ USERS */
};

class GROUP: public ARRAY_OBJ{
	SSTRING name;
	SSTRING passwd;
	int gid;
	SSTRINGS tbmem;	// User member of this group (not their primary group)
	/*~PROTOBEG~ GROUP */
public:
	GROUP (const char *_name,
		 const char *_passwd,
		 int _gid,
		 char **members);
	GROUP (struct group *p);
	GROUP (void);
private:
	int check (USERS&users,
		 GROUPS&groups,
		 GROUP *realone);
public:
	int edit (USERS&users, GROUPS&groups);
	int getgid (void);
	const char *getname (void);
private:
	void init (const char *_name,
		 const char *_passwd,
		 int _gid,
		 char **members);
	void settbmem (char **members);
public:
	void write (FILE *fout);
	~GROUP (void);
	/*~PROTOEND~ GROUP */
};

class GROUPS: public ARRAY{
	/*~PROTOBEG~ GROUPS */
public:
	GROUPS (void);
	int edit (void);
	const char *getdefault (void);
	GROUP *getfromgid (int gid);
	int getgid (const char *name);
	GROUP *getitem (const char *name);
	GROUP *getitem (int no);
	int getnew (void);
	void load_special (void);
	void sortbyname (void);
	int write (void);
	~GROUPS (void);
	/*~PROTOEND~ GROUPS */
};

#include "userconf.p"

#endif

