#pragma implementation
#include <unistd.h>
#include <translat.h>
#include "internal.h"
#include "userconf.h"
#include <mailconf.h>
#include <netconf.h>
#include "../paths.h"
#include "userconf.m"

static USERCONF_HELP_FILE help_intro ("intro");
PRIVILEGE p_managepop("managepop"
		,P_MSG_U(F_MANAGEPOP,"POP accounts manager")
		,P_MSG_U(T_MANAGEACCT,"User account management"));
PRIVILEGE p_manageppp("manageppp"
		,P_MSG_U(F_MANAGEPPP,"PPP accounts manager")
		,P_MSG_R(T_MANAGEACCT));
PRIVILEGE p_manageuucp("manageuucp"
		,P_MSG_U(F_MANAGEUUCP,"UUCP manager")
		,P_MSG_R(T_MANAGEACCT));


void userconf_edit()
{
	/* #Specification: userconf / principal
		The userconf program allows you to edit/create/delete user
		accounts and groups.
	*/
	int choice=0;
	while (1){
		static const char *user_accounts = MSG_U(M_USER,"user accounts");
		static const char *groupe_def = MSG_U(M_GROUPDEF,"group definitions");
		//static const char *users_pass = MSG_U(M_UPASS,"users password");
		static const char *root_pass = MSG_U(M_ROOTPASS,"root password");
		static const char *std_ppp = MSG_U(M_PPP,"PPP account via normal login");
		static const char *pap_ppp = MSG_U(M_PPPPAP,"PPP account via PAP authentication");
		static const char *chap_ppp = MSG_U(M_PPPCHAP,"PPP account via CHAP authentication");
		static const char *std_slip = MSG_U(M_SLIP,"SLIP account via normal login");
		static const char *uucp_account = MSG_U(M_UUCP,"UUCP account");
		static const char *pop_accounts = MSG_U(M_POP,"POP accounts (mail only)");
		static const char *vpop_accounts = MSG_U(M_VPOP,"Virtual POP accounts (mail only)");
		static const char *passwd_policies = MSG_U(M_POLICIES,"Password setting policies");
		static const char *usr_shells = MSG_U(M_USRSHELLS,"available user shells");
		static const char *ppp_shells = MSG_U(M_PPPSHELLS,"available PPP shells");
		static const char *slp_shells = MSG_U(M_SLPSHELLS,"available SLIP shells");
		static const char *menuopt[]={
			MSG_U(M_ECREATE,"Edit/Create"),	user_accounts,
			" ",		groupe_def,
			MSG_U(M_CHANGE,"Change"),	root_pass,
			"-",		"Special accounts",
			MSG_R(M_ECREATE),	std_ppp,
			" ",		pap_ppp,
			" ",		chap_ppp,
			" ",		std_slip,
			" ",		uucp_account,
			" ",		pop_accounts,
			" ",		vpop_accounts,
			"-",		"",
			MSG_U(M_EDIT,"Edit"),		passwd_policies,
			" ",		usr_shells,
			" ",		ppp_shells,
			" ",		slp_shells,
			NULL
		};
		MENU_STATUS code = xconf_menu (
			MSG_U(T_UCONF,"User account configurator")
			,MSG_U(I_UCONFINTRO
			 ,"This package allows you to add/delete\n"
			 "and manage user accounts\n")
			,help_intro
			,menuopt,choice);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else{
			const char *key = menuopt[choice*2+1];
			if (key == user_accounts){
				users_edit(NULL,NULL,1);
			}else if (key == pop_accounts){
				USER *like;
				if (special_init (POP_GROUP,like) != -1){
					users_edit(like,&p_managepop,0);
				}
				delete like;
			}else if (key == vpop_accounts){
				USER *like;
				if (special_init (POP_GROUP,like) != -1){
					vdomain_editusers(like);
				}
				delete like;
			}else if (key == std_ppp){
				USER *like;
				if (special_init (PPP_GROUP,like) != -1){
					users_edit(like,&p_manageppp,0);
				}
				delete like;
			}else if (key == std_slip){
				USER *like;
				if (special_init (SLIP_GROUP,like) != -1){
					users_edit(like,&p_manageppp,0);
				}
				delete like;
			}else if (key == uucp_account){
				USER *like;
				if (special_init (UUCP_GROUP,like) != -1){
					users_edit(like,&p_manageuucp,0);
				}
				delete like;
			}else if (key == pap_ppp){
			}else if (key == chap_ppp){
			}else if (key == groupe_def){
				groups_edit();
			}else if (key == passwd_policies){
				PASSWD_VALID vl;
				vl.edit();
			}else if (key == usr_shells){
				shells_edituser();
			}else if (key == ppp_shells){
				shells_editppp();
			}else if (key == slp_shells){
				shells_editslip();
			}else if (key == root_pass){
				if (simul_isdemo()){
					xconf_error (MSG_U(E_ROOTPASS
						,"You are not allowed to change root's password\n"
						 "in demo mode."));
				}else if (perm_rootaccess(
					MSG_U(P_CHGPASS,"change users password"))){
					USERS users;
					USER *root = users.getitem("root");
					SHADOW *shadow = users.getshadow(root);
					if (root->editpass(0,shadow,1) != -1){
						users.write(NULL);
					}
				}
			}
		}
	}
}
/*
	Edit the password of the current user or one specific user
*/
int userconf_passwd (int argc, char *argv[])
{
	USERS users;
	int save_ok = -1;
	if (argc == 1){
		USER *usr = users.getfromuid(getuid());
		SHADOW *shadow = users.getshadow (usr);
		if (usr == NULL){
			xconf_error (
				MSG_U(E_NOUID,"Can't locate entry for uid %d\n"
				"in %s"),getuid(),ETC_PASSWD);
		}else{
			if (isatty(0) && isatty(1)){
				save_ok = usr->edithispass(shadow);
			}else{
				save_ok = usr->edithispass_notty(shadow);
			}
			if (save_ok != -1) perm_forceok();	// This let the write
												// succeed
		}
	}else if (argc == 2){
		USER *usr = users.getitem(argv[1]);
		if (usr == NULL){
			xconf_error (MSG_U(E_UNKNOWNUSER,"Unknown user %s\n"),argv[1]);
		}else if (perm_rootaccess(MSG_R(P_CHGPASS))){
			SHADOW *shadow = users.getshadow (usr);
			dialog_clear();
			save_ok = usr->editpass(1,shadow,1);
		}
	}
	if (save_ok != -1) users.write(NULL);
	return 0;
}

int userconf_main (int , char *[])
{
	if (netconf_mainaccess ()){
		userconf_edit();
	}
	return 0;
}

