#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <grp.h>
#include "internal.h"
#include "userconf.h"
#include "../paths.h"
#include <misc.h>
#include "userconf.m"

static USERCONF_HELP_FILE help_group ("group");

PRIVATE void GROUP::settbmem (char **members)
{
	tbmem.delall();
	if (members != NULL){
		int i=0;
		while (members[i] != NULL){
			tbmem.add (new SSTRING(members[i]));
			i++;
		}
	}
}

PRIVATE void GROUP::init(
	const char *_name,
	const char *_passwd,
	int _gid,
	char **members)
{
	name.setfrom (_name);
	passwd.setfrom(_passwd);
	gid = _gid;
	settbmem (members);
}

PUBLIC GROUP::GROUP(
	const char *_name,
	const char *_passwd,
	int _gid,
	char **members)
{
	init (_name,_passwd,_gid,members);
}

PUBLIC GROUP::GROUP()
{
	init ("","",-1,NULL);
}
PUBLIC GROUP::GROUP(struct group *p)
{
	init (p->gr_name,p->gr_passwd,p->gr_gid,p->gr_mem);
}
PUBLIC GROUP::~GROUP()
{
}

/*
	Write one record of /etc/passwd
*/
PUBLIC void GROUP::write(FILE *fout)
{
	fprintf (fout,"%s:%s:%d:",name.get(),passwd.get(),gid);
	char *sep = "";
	int nb = tbmem.getnb();
	for (int i=0; i<nb; i++){
		fputs (sep,fout);
		fputs (tbmem.getitem(i)->get(),fout);
		sep = ",";
	}
	fputc ('\n',fout);
}

PUBLIC const char *GROUP::getname()
{
	return name.get();
}
PUBLIC int GROUP::getgid()
{
	return gid;
}

/*
	Check if a group is correctly configured.
	Return -1 if not.
*/
PRIVATE int GROUP::check(
	USERS &users,
	GROUPS &groups,
	GROUP *realone)
{
	char status[1000];
	status[0] = '\0';
	GROUP *other = groups.getitem(name.get());
	if (other != NULL && other != realone){
		strcat (status,MSG_U(E_GROUPEXIST,"Group already exist\n"));
	}
	other = groups.getfromgid(gid);
	if (other != NULL && other != realone){
		strcat (status,MSG_U(E_GROUPEXISTID
			,"Group already exist (Group ID)\n"));
	}
	int nb = tbmem.getnb();
	for (int i=0; i<nb; i++){
		const char *user = tbmem.getitem(i)->get();
		if (users.getitem(user)==NULL){
			strcat (status,MSG_U(E_UNKNOWNMEMBER,"Unknown member user "));
			strcat (status,user);
			strcat (status,"\n");
		}
	}
	int ret = 0;
	if (status[0] != '\0'){
		xconf_error ("%s",status);
		ret = -1;
	}
	return ret;
}

static char **group_parsemem (const char *str, int &nb)
{
	nb = 0;
	char **ret = (char**)malloc_err (100*sizeof(char*));
	while (str[0] != '\0'){
		str = str_skip(str);
		char member[200];
		char *ptmem = member;
		while (*str > ' ') *ptmem++ = *str++;
		if (ptmem > member){
			*ptmem = '\0';
			ret[nb++] = strdup(member);
		}
	}
	ret[nb] = NULL;
	return ret;
}

/*
	Edit the specification of a user.
	Return -1 if the user escape without accepting the changes.
	Return 0 if the record was changed
	Return 1 if the record must be deleted
*/
PUBLIC int GROUP::edit(USERS &users, GROUPS &groups)
{
	DIALOG dia;
	dia.newf_str (MSG_U(F_GROUPNAME,"Group name"),name);
	if (gid == -1) gid = groups.getnew();
	dia.newf_num (MSG_U(F_GROUPID,"Group ID"),gid);
	SSTRING altmem;
	for (int i=0; i<tbmem.getnb(); i++){
		altmem.append (tbmem.getitem(i)->get());
		altmem.append (" ");
	}
	dia.newf_str (MSG_U(F_ALTMEM,"Alternate members(opt)"),altmem);

	int field = 0;
	int ret = -1;
	while (1){
		MENU_STATUS code = dia.edit(MSG_U(T_GROUPSPEC,"Group specification")
			,MSG_U(INTRO_GROUPSPEC,"You must specify at least the name\n")
			,help_group
			,field
			,MENUBUT_ACCEPT|MENUBUT_CANCEL|MENUBUT_DEL);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			dia.restore();
			break;
		}else if (perm_rootaccess(
			MSG_U(P_GROUPDB,"to maintain the group database"))){
			if (code == MENU_DEL){
				if (xconf_areyousure(MSG_U(Q_DELGROUP
					,"Confirm deletion of group definition"))){
					ret = 1;
					break;
				}
			}else{
				if (name.strchr(':')!=NULL
					|| altmem.strchr(':')!=NULL){
					xconf_error (MSG_R(E_NO2PT));
				}else{
					int newgid = gid;
					int nb;
					char **members = group_parsemem (altmem.get(),nb);
					GROUP tmp(name.get(),passwd.get(),newgid,members);
					if (tmp.check(users,groups,this)==0){
						settbmem (members);
						ret = 0;
						break;
					}
					tbstr_free (members,nb);
					free (members);
				}
			}
		}
	}
	return ret;
}


