#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <errno.h>
#include <string.h>
#include <stdarg.h>
#include <ctype.h>
#include "netconf.h"
#include "netconf.m"
#include "../askrunlevel/askrunlevel.h"

static HELP_FILE help_netconf_log (HELP_NETCONF,"netconflog");

static CONFIG_FILE f_netconf_log (VAR_LOG_NETCONF_LOG
	,help_netconf_log
	,CONFIGF_OPTIONNAL|CONFIGF_MANAGED);

static int netlog_mask=-1;		// The default is to show everything

/*
	Return != 0 if str is a valid ip number (lexically)
*/
int net_isipnum(const char *str)
{
	int ret = 0;
	int nbpt = 0;	// Number of period met
	while (1){
		if (!isdigit(*str)){
			break;
		}else{
			int num = atoi(str);
			while (isdigit(*str)) str++;
			if (num > 255){
				break;
			}else if (*str == '\0'){
				ret = 1;
				break;
			}else if (*str != '.'){
				break;
			}else{
				nbpt++;
				str++;
			}
		}
	}
	if (ret && nbpt != 3) ret = 0;
	return ret;
}

static const char BOOT[]="BOOT";
static const char VERBOSE[]="verbose";

static char net_show = 1;
void net_setshowmode (int mode)
{
	net_show = (char)mode;
}


static int nberr=0;
/*
	Reset the error counter
*/
void net_resetnberr()
{
	nberr = 0;
}
/*
	Return the current value of the error counter
*/
int net_getnberr()
{
	return nberr;
}
/*
	Get the configuration of the log print setting
*/
int net_getlogmask()
{
	static char netmask_loaded = 0;
	if (!netmask_loaded){
		netmask_loaded = 1;
		netlog_mask = linuxconf_getvalnum (BOOT,VERBOSE,netlog_mask);
	}
	return netlog_mask;
}

/*
	Set the configuration of the log print setting
*/
int net_setlogmask(int mask)
{
	netlog_mask = mask;
	linuxconf_replace (BOOT,VERBOSE,netlog_mask);
	return linuxconf_save();
}


static void net_putlog (int level, const char *buf)
{
	if (simul_ison()){
		if (level == NETLOG_REQ || level == NETLOG_CMD) simul_addmsg (buf);
	}else{
		net_getlogmask();
		if (level == NETLOG_ERR) nberr++;
		if ((level & netlog_mask) != 0 && net_show){
			printf ("%s",buf);
		}
		FILE *fout = f_netconf_log.fopen ("a");
		static char shown_err = 0;
		/* #Specification: /usr/adm/netconf.log / can't open
			Action taken by netconf are log in /var/log/netconf.log.
			They can't be log with syslogd because syslogd is started
			by netconf and may not be available.
			
			If the file can't be open, one and only one error message will
			be shown (per netconf session).
		*/
		if (fout != NULL){
			fputs (buf,fout);
			fclose (fout);
		}else if (!shown_err){
			shown_err = 1;
			xconf_error (MSG_U(E_CANTOPEN,"Can't open file %s\n(%s)\n")
				,f_netconf_log.getpath(),strerror(errno));
		}
	}
}

/*
	Add a message in /usr/adm/netconf.log
*/
void net_prtlog (const char *ctl, ...)
{
	char buf[10000];
	va_list list;
	va_start (list,ctl);
	vsprintf (buf,ctl,list);
	va_end (list);
	net_putlog (NETLOG_REQ,buf);
}

void net_prtlog (int level, const char *ctl, ...)
{
	char buf[10000];
	char *ptbuf = buf;
	memset (buf,' ',20);
	if (level == NETLOG_TITLE){
		ptbuf += 2;
	}else if (level == NETLOG_ERR){
		ptbuf+=8;
		*ptbuf++ = '*';
		ptbuf++;
	}else if (level == NETLOG_OUT){
		ptbuf+=8;
		*ptbuf++ = '>';
		ptbuf++;
	}else if (level == NETLOG_VERB){
		ptbuf+=8;
		*ptbuf++ = '!';
		ptbuf++;
	}else if (level == NETLOG_CMD){
		ptbuf += 4;
	}
	va_list list;
	va_start (list,ctl);
	vsprintf (ptbuf,ctl,list);
	va_end (list);
	net_putlog (level,buf);
}
static const char *tbhead[]={
	"### Pre-booting",
	"### booting",
	"### fixperm",
	"netconf --update",
	"### switch runlevel",
	"### ppp postcon",
	NULL
};

/*
	Send a title string with a date in /var/adm/netconf.log
*/
void net_introlog (int msg)
{
	FILE *fout = f_netconf_log.fopen ("a");
	if (fout != NULL){
		static const char *tbinfo[]={
			MSG_U(I_PREBOOT,"Tasks before booting"),
			MSG_U(I_BOOTING,"Booting"),
			MSG_U(I_FIXPERM,"Fixperm session"),
			MSG_U(I_UPDATE,"Activating changes"),
			MSG_U(I_RUNLEVEL,"Switching runlevel"),
			MSG_U(I_PPPPOSTCON,"PPP postconnect commands"),
			NULL
		};
		time_t ti = time(NULL);
		char bufdate[100];
		strcpy (bufdate,asctime(localtime(&ti)));
		strip_end (bufdate);
		fprintf (fout, "%s: %s %s\n"
			,tbhead[msg]
			,bufdate
			,tbinfo[msg]);
		fclose (fout);
	}
}

/*
	Log the title of a set of configuration commands
*/
void net_title (const char *msg)
{
	net_prtlog (NETLOG_TITLE,"%s\n",msg);
}
/*
	Log the title of a major configuration section.
*/
void net_section (const char *msg)
{
	net_prtlog (NETLOG_SECTION,"%s\n",msg);
}

void net_showlog ()
{
	boot_showlog (f_netconf_log,tbhead
		,MSG_U(T_CONFIGLOG,"Configuration log")
		,MSG_U(I_CONFIGLOG
			,"These logs shows all configuration commands\n"
			 "issued by linuxconf")
		,help_netconf_log);
}
#ifdef TEST

static void test (const char *str)
{
	printf ("testing %s -> %s\n",str
		,net_isipnum(str) ? "OK" : "Not valid");
}

int main(int argc, char *argv[])
{
	test ("hello");
	test ("1.2.3");
	test ("1.a.2.3");
	test ("1a.2.3.4");
	test ("11.22.33.444");
	printf ("All other are valid\n");
	test ("1.2.3.4");
	test ("11.22.33.44");
	return 0;
}

#endif
