#pragma interface
#ifndef DATETIME_H
#define DATETIME_H

#ifndef MISC_H
	#include <misc.h>
#endif

/* #Specification: netconf / number of eth devices
	Linuxconf can configure up to 4 ethernet devices
*/
#define NB_ETH	4
struct DEVICE_NAME_INFO{
	char *host;		// Pseudo host name to access the configuration
	char *net;		// of the 4 ethernet adaptors.
	char *mask;		// NAM_ETH?_XXXX
	char *bcast;
};

#if 0
enum IPX_FRAME_TYPE {
	IPX_FRAME_NONE=0,
	IPX_FRAME_802_2=1,
	IPX_FRAME_802_3=2,
	IPX_FRAME_ETHERII=3,
	IPX_FRAME_AUTO=4		// Not really a frame type
};
#endif

enum IPX_PRIMARY_TYPE {
	IPX_PRIMARY_NO=0,
	IPX_PRIMARY_YES=1,
	IPX_PRIMARY_AUTO=2
};

struct IPX_FRAME_INFO{
	char *name;		// Frame type name
	int netnum;
	char active;
	char primary;
};

#define NB_IPX_FRAME_TYPE	4

struct IPX_INTER_INFO{
	IPX_FRAME_INFO frames[NB_IPX_FRAME_TYPE];
};
	
class IPX_INFO{
	char ipx_active;	// Activate/desactivate the IPX config
	char primary_auto;
	char frame_auto;
	int  internal_netnum;
	int  internal_nodenum;
	IPX_INTER_INFO a[NB_ETH];
	/*~PROTOBEG~ IPX_INFO */
public:
	IPX_INFO (CONFIG_FILE&f);
	IPX_INFO (void);
	int edit (void);
private:
	void probe_auto (void);
public:
	int save (void);
	int set (void);
	/*~PROTOEND~ IPX_INFO */
};

struct INTER_INFO{
	SSTRING name;
	SSTRING ipaddr;
	SSTRING network;
	SSTRING netmask;
	SSTRING bcast;
	SSTRING others;
};
struct HOSTINFO{
	INTER_INFO a[NB_ETH];	// Info on 4 adaptor
};


class DATETIME{
	char universal;
	SSTRING netdate;
	/*~PROTOBEG~ DATETIME */
public:
	DATETIME (void);
	int edit (void);
	int getfromcmos (void);
	int getfromnet (void);
	void save (void);
	void updatecmos (void);
	/*~PROTOEND~ DATETIME */
};

class ROUTED{
	char required;
	char silent;
	char gateway;
	/*~PROTOBEG~ ROUTED */
public:
	ROUTED (void);
	int edit (void);
	int is_required (void);
	void save (void);
	void setoptions (char *buf);
	/*~PROTOEND~ ROUTED */
};

class IP_ALIAS: public ARRAY_OBJ{
public:
	int num;		// no of the alias
	SSTRING ip;		// Ip number
	/*~PROTOBEG~ IP_ALIAS */
public:
	IP_ALIAS (const char *_ip);
	IP_ALIAS (int _num, const char *_ip);
	int set (int _num, const char *devname);
	int unset (const char *devname);
	/*~PROTOEND~ IP_ALIAS */
};

class IP_ALIASES: public ARRAY{
	/*~PROTOBEG~ IP_ALIASES */
public:
	IP_ALIAS *getitem (const char *ip);
	IP_ALIAS *getitem (int no);
	int getmaxnum (void);
	void readproc (const char *devname);
	int setnew (const char *devip,
		 const char *ips,
		 char *err);
	int setup (const char *devname);
	/*~PROTOEND~ IP_ALIASES */
};


#endif
