#include "misc.h"

PUBLIC SSTRING *SSTRINGS::getitem (int no) const
{
	return (SSTRING *)ARRAY::getitem(no);
}

static int cmp (ARRAY_OBJ *o1, ARRAY_OBJ *o2)
{
	SSTRING *s1 = (SSTRING *)o1;
	SSTRING *s2 = (SSTRING *)o2;
	return s1->cmp(*s2);
}

/*
	Sort the array of SSTRING
*/
PUBLIC void SSTRINGS::sort ()
{
	ARRAY::sort (cmp);
}


/*
	Find the occurence of a string in the array.
	Return -1 if not found or the index if found
*/
PUBLIC int SSTRINGS::lookup(const char *str) const
{
	int ret = -1;
	int nb = getnb();
	for (int i=0; i<nb; i++){
		SSTRING *s = getitem(i);
		if (s->cmp(str)==0){
			ret = i;
			break;
		}
	}
	return ret;
}

PUBLIC int SSTRINGS::lookup(const SSTRING *str) const
{
	return lookup (str->get());
}


