#pragma interface
#ifndef SSTRING_H
#define SSTRING_H

// Simple string class
class SSTRING: public ARRAY_OBJ {
	char *str;
	int maxsiz;		// 0 if not specified
	/*~PROTOBEG~ SSTRING */
public:
	SSTRING (const SSTRING&_str);
	SSTRING (const char *_str);
	SSTRING (const char *_str, int _maxsiz);
	SSTRING (void);
	void append (const char *app);
	int cmp (const SSTRING&other)const;
	int cmp (const char *other)const;
	void copy (SSTRING&dst)const;
	void copy (char *dst)const;
	char *copyword (const char *line);
	const char *get (void)const;
	int getlen (void)const;
	int getmaxsiz (void)const;
	int getval (void)const;
	double getvalf (void)const;
	int icmp (const SSTRING&other)const;
	int icmp (const char *other)const;
	int is_empty (void)const;
	int ncmp (const char *other, int len)const;
	SSTRING&operator = (const SSTRING&_str);
	void setfrom (const SSTRING&src);
	virtual void setfrom (const char *src);
	void setfrom (int val);
	void setmaxsiz (int size);
	const char *strchr (char carac);
	void strip_end (void);
	const char *strstr (const char *sub);
	~SSTRING (void);
	/*~PROTOEND~ SSTRING */
};

// table of SSTRING
class SSTRINGS: public ARRAY {
	/*~PROTOBEG~ SSTRINGS */
public:
	SSTRING *getitem (int no)const;
	int lookup (const SSTRING *str)const;
	int lookup (const char *str)const;
	void sort (void);
	/*~PROTOEND~ SSTRINGS */
};

/*
	A string with a comment
*/
class CSSTRING: public SSTRING{
public:
	SSTRING comment;
	/*~PROTOBEG~ CSSTRING */
public:
	void setcomment (const SSTRING&com);
	/*~PROTOEND~ CSSTRING */
};

#endif
