#pragma implementation
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/wait.h>
#include <signal.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include "misc.h"
#include "popen.h"
#include <netconf.h>

static int child_counter = 0;

static void fchild(int )
{
	child_counter++;	
}

PUBLIC POPEN::POPEN(const char *command)
{
	cur_dead = child_counter;
	pid = -1;
	status = -1;
	int fdout[2];
	int fderr[2];
	int fdctl[2];
	if (pipe(fdout)!=-1 && pipe(fderr)!=-1 && pipe(fdctl)!=-1){
		signal (SIGCHLD,fchild);
		pid = fork();
		if (pid == 0){
			// Setting up a clean environnement: Linuxconf is often setuid
			char *tb[10];
			tb[0] = "PATH=/bin:/usr/bin";
			char termstr[100];
			strcpy (termstr,"TERM=linux");
			const char *term = getenv ("TERM");
			if (term != NULL) sprintf (termstr,"TERM=%s",term);
			tb[1] = termstr;
			tb[2] = NULL;
			environ = tb;

			close (fdout[0]);
			close (fderr[0]);
			close (fdctl[0]);
			dup2 (fdout[1],1);
			dup2 (fderr[1],2);
			close (fdout[1]);
			close (fderr[1]);
			setuid (geteuid());
			int ret = system (command);
			write (fdctl[1],"done\n",5);
			#if 0
				FILE *fout = fopen ("/tmp/popen.log","a");
				fprintf (fout,"%s -> %d\n",command,ret);
				fclose (fout);
			#endif
			if ((ret & 0xff)==0) ret >>= 8;
			_exit (ret);
		}
		close (fdout[1]);
		close (fderr[1]);
		close (fdctl[1]);
		fds.out = fdout[0];
		fds.err = fderr[0];
		fds.ctl = fdctl[0];
	}
}

PUBLIC POPEN::~POPEN()
{
	kill();
	close (fds.out);
	close (fds.err);
	close (fds.ctl);
	signal (SIGCHLD,SIG_DFL);
}

PUBLIC void POPEN::kill()
{
	if (pid != -1){
		int child_pid = process_findchild(pid);
		if (child_pid != -1) ::kill (child_pid,SIGTERM);
		::kill (pid,SIGTERM);
		waitend();
	}
}

/*
	Forget about the child process.
	It won't be killed by the destructor of POPEN
*/
PUBLIC void POPEN::forget()
{
	pid = -1;
}
PRIVATE void POPEN::waitone()
{
	if (pid != -1){
		int code = ::wait(&status);
		if (code == pid){
			if ((status & 0xff)==0) status >>= 8;
			pid = -1;
		}
	}
}
/*
	Wait until the process is really dead and recover its end status
*/
PRIVATE void POPEN::waitend ()
{
	while (pid != -1) waitone();
}

/*
	Return != 0 if the pipe is corretly opened
*/
PUBLIC int POPEN::isok()
{
	return pid != -1;
}

PRIVATE void POPEN::readif (struct fd_set *in, int fd, SSTRING &buf)
{
	if (FD_ISSET(fd,in)){
		char bufread[10000];
		int len = read (fd,bufread,sizeof(bufread)-1);
		if (len > 0){
			bufread[len] = '\0';
			buf.append (bufread);
		}else{
			// end of process
			waitend();
		}
	}
}

/*
	Check if some signal was received about child death
*/
PRIVATE void POPEN::checksignal()
{
	if (child_counter > cur_dead){
		cur_dead = child_counter;
		waitone();
	}			
}


static int popen_fdset (int fd, struct fd_set &in, int maxfd)
{
	if (fd != -1){
		FD_SET (fd,&in);
		if (fd > maxfd) maxfd = fd;
	}
	return maxfd;
}
/*
	Wait for anything to be available from the child process
	Return -1 if any error.
	Return  0 if the timeout has elapsed.
	Return  1 if there is some data to read
	Return  2 if there is some data on otherfd
	Return  3 if there is some data on otherfd and on POPEN file handle
*/
PUBLIC int POPEN::wait(int timeout, int otherfd)
{
	int ret = -1;
	if (pid != -1){
		struct fd_set in;
		FD_ZERO(&in);
		int maxfd = popen_fdset (fds.out,in,0);
		maxfd = popen_fdset (fds.err,in,maxfd);
		maxfd = popen_fdset (fds.ctl,in,maxfd);
		maxfd = popen_fdset (otherfd,in,maxfd);
		struct timeval tim;
		tim.tv_usec = 0;
		tim.tv_sec = timeout;
		checksignal();
		ret = select (maxfd+1,&in,NULL,NULL,&tim);
		checksignal();
		if (ret > 0){
			ret = 0;
			if (FD_ISSET(fds.err,&in)
				|| FD_ISSET(fds.out,&in)){
				ret = 1;
				readif (&in,fds.out,outbuf);
				readif (&in,fds.err,errbuf);
			}
			if (FD_ISSET(otherfd,&in)) ret |= 3;
			if (FD_ISSET(fds.ctl,&in)){
				waitend();
			}
		}
	}
	return ret;
}

/*
	Wait for anything to be available from the child process
	Return -1 if any error.
	Return  0 if the timeout has elapsed.
	Return  1 if there is some data to read
*/
PUBLIC int POPEN::wait(int timeout)
{
	return wait (timeout,-1);
}

/*
	Return the status code of the ending process
*/
PUBLIC int POPEN::getstatus()
{
	return status;
}

/*
	Read one complete line or up to size byte in "line".
	If there is no complete line, nothing is read
*/
PRIVATE int POPEN::readline (char *line, int size, SSTRING &buf)
{
	char *begin = line;
	const char *pt = buf.get();
	while (1){
		if (*pt == '\0'){
			if (pid == -1){
				*line = '\0';
				buf.setfrom ("");
			}else{
				// No full line to read, keep the buffer untouched
				// until we get the \n
				line = begin;
				*begin = '\0';
			}
			break;
		}else{
			char carac = *pt++;
			*line++ = carac;
			size--;
			if (size == 0 || carac == '\n'){
				buf.setfrom (pt);
				*line = '\0';
				break;
			}
		}
	}
	return line > begin ? 0 : -1;
}

/*
	Read one line of stderr if available (won't block).
*/
PUBLIC int POPEN::readerr (char *line, int size)
{
	return readline (line,size,errbuf);
}
/*
	Read one line of stdout if available (won't block).
*/
PUBLIC int POPEN::readout (char *line, int size)
{
	return readline (line,size,outbuf);
}

#ifdef TEST

int simul_isdemo(){return 0;}
int revision;

int main (int argc, char *argv[])
{
	if (argc > 1){
		char buf[1000];
		char *pt = buf;
		for (int i=1; i<argc; i++){
			pt += sprintf (pt,"%s ",argv[i]);
		}
		printf ("execute la commande :%s:\n",buf);
		POPEN p(buf);
		while (p.isok()){
			if (p.wait(10)>0){
				while (p.readout(buf,sizeof(buf)-1)!=-1){
					fputs (buf,stdout);
				}
			}else{
				break;
			}
		}
	}
	return 0;
}

#endif

