#include <stdio.h>
#include <errno.h>
#include <string.h>
#include "misc.h"
#include "misc.m"

/*
	Open a file and print an error message if it can't be done
*/
FILE *xconf_fopen (const char *fname, const char *mode)
{
	int wr_mode = strchr(mode,'w')!=NULL || strchr(mode,'a')!=NULL;;
	FILE *ret = fopen (fname,mode);
	if (ret == NULL){
		xconf_error (MSG_U(E_CANTDO,"Can't %s file %s\n%s")
			,wr_mode ? MSG_U(E_WRITE,"write") : MSG_U(E_READ,"read")
			,fname,strerror(errno));
	}
	return ret;
}

