#include "misc.h"
#include "misc.m"

/*
	Print an error message in a popup
*/
static void xconf_msg (
	const char *title,
	const char *icon,
	const char *msg,
	va_list list)
{
	char buf[2000];
	vsprintf (buf,msg,list);
	dialog_clear();
	dialog_msgbox ((char*)title,buf,icon);
}
/*
	Print an error message in a popup
*/
void xconf_error (const char *msg, ...)
{
	va_list list;
	va_start (list,msg);
	html_setpopup();
	xconf_msg (MSG_U(T_ERROR,"Error"),MSG_U(I_ICONERROR,"Error"),msg,list);
	va_end (list);
}

/*
	Print a notice to the user.
*/
void xconf_notice (const char *msg, ...)
{
	va_list list;
	va_start (list,msg);
	xconf_msg (MSG_U(T_PLEASE,"Please note")
		,MSG_U(I_ICONNOTICE,"Notice"),msg,list);
	va_end (list);
}

