#include <unistd.h>
#include "../askrunlevel/askrunlevel.h"
#include <xconf.h>
#include <misc.h>
#include <netconf.h>
#include <userconf.h>
#include <fstab.h>
#include "main.h"
#include "../paths.h"
#include <translat.h>
#include "main.m"

static HELP_FILE help_intro (HELP_MAIN,"intro");
static HELP_FILE help_control (HELP_MAIN,"control");
static HELP_FILE help_shutdown (HELP_MAIN,"shutdown");
static HELP_FILE help_features (HELP_MAIN,"features");
static HELP_FILE help_logs (HELP_MAIN,"logs");

static PRIVILEGE p_shutdown ("shutdown"
	,P_MSG_U(T_PRIVSHUTDOWN,"May shutdown")
	,P_MSG_U(T_PSYSCONTROL,"0-General system control"));
static PRIVILEGE p_actchg ("actchg"
	,P_MSG_U(T_PACTCHG,"May activate config changes")
	,P_MSG_R(T_PSYSCONTROL));
static PRIVILEGE p_netlevel ("netlevel"
	,P_MSG_U(T_PNETLEVEL,"May switch network mode")
	,P_MSG_R(T_PSYSCONTROL));
static PRIVILEGE p_logs ("viewlogs"
	,P_MSG_U(T_PVIEWLOGS,"May view system logs")
	,P_MSG_R(T_PSYSCONTROL));

/*
	Interactive control of a shutdown or reboot
*/
static void linuxconf_boot()
{
	DIALOG dia;
	char oper=0;
	dia.newf_radio ("",oper,0,MSG_U(F_REBOOT,"Reboot"));
	dia.newf_radio ("",oper,1,MSG_U(F_HALT,"Shutdown & halt"));
	int grace = 1;
	dia.newf_num   (MSG_U(F_DELAI,"Delay before shutdown(minutes)"),grace);
	SSTRING message;
	dia.newf_str   (MSG_U(F_MESSAGE,"Message"),message);
	if (dia.edit (MSG_U(T_SHUTDOWN,"Shutdown control panel")
		,MSG_U(I_SHUTDOWN,"You can force a reboot or a final shutdown\n"
			"of this computer")
		,help_shutdown)==MENU_ACCEPT){
		setuid (0);
		chdir ("/");
		char timestr[10];
		sprintf (timestr,"+%d",grace);
		execl ("/sbin/shutdown","/sbin/shutdown"
			,oper == 0 ? "-r" : "-h"
			,timestr,message.get(),NULL);	
	}
}

/*
	control panel to activate different things, not to configure.
	Return != 0 if the last task done was an "update" of the system state
*/
static int linuxconf_control()
{
	int choice = 0;
	int was_checked = 0;
	while (1){
		static const char *runlevel = MSG_U(M_NETLEVEL,"Switch network runlevel");
		static const char *initrunlevel  = MSG_U(M_RUNLEVEL,"init Run Level");
		static const char *reboot = MSG_U(M_REBOOT,"Shutdown/Reboot");
		static const char *update = MSG_U(M_UPDATE,"Activate configuration");
		static const char *reload = MSG_U(M_RESTART,"Restart linuxconf");

		static const char *menuopt[]={
			" ",		runlevel,
			//" ",		initrunlevel,
			" ",		update,
			" ",		reboot,
			"-",		"",
			" "	,		reload,
			NULL
		};
		if (dialog_mode != DIALOG_HTML) menuopt[3*2] = NULL;
		MENU_STATUS code = xconf_menu (MSG_U(T_CONTROL,"Control panel")
			,MSG_U(I_CONTROL
				,"This menu let you do things, not configure.")
			,help_control
			,menuopt,choice);
		if (code != MENU_OK){
			break;
		}else{
			was_checked = 0;
			const char *key = menuopt[choice*2+1];
			if (key == update){
				if (perm_access (&p_actchg,MSG_U(P_ACTIVATECHG
					,"enable configuration changes"))){
					int status = netconf_checkupdate();
					was_checked = status != -1;
					if (status == 0){
						xconf_notice (MSG_U(N_NOJOB,"Nothing to do!"));
					}
				}
			}else if (!simul_isdemo()){
				if (key == reboot){
					if (perm_access (&p_shutdown,MSG_U(P_SHUTDOWN
						,"shutdown the computer"))){
						linuxconf_boot();
					}
				}else if (key == runlevel){
					if (perm_access (&p_netlevel,MSG_U(P_NETLEVEL
						,"switch network operation level"))){
						netconf_editrunlevel();
					}
				}else if (key == initrunlevel){
					//init_editrunlevel();
				}else if (key == reload){
					if (perm_rootaccess (MSG_U(Q_SYSTASK,"to perform system task"))){
						exit (0);
					}
				}
			}else{
				xconf_error (MSG_U(E_DEMO,"Not in demo mode"));
			}
		}
	}
	return was_checked;
}
static const char LINUXCONF[]="linuxconf";
static const char HTMLTIMEOUT[]="htmltimeout";

int linuxconf_gethtmltimeout()
{
	return linuxconf_getvalnum (LINUXCONF,HTMLTIMEOUT,10);
}

static void linuxconf_features()
{
	int html_timeout = linuxconf_gethtmltimeout();
	DIALOG dia;
	dia.newf_num (MSG_U(F_HTMLTIMEOUT,"Html timeout"),html_timeout);
	int nof = 0;
	while (1){
		MENU_STATUS code = dia.edit (MSG_U(T_FEATURES,"Linuxconf features")
			,MSG_U(I_FEATURES,"This screen defines some special behavior\n"
				"of linuxconf.")
			,help_features
			,nof);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (html_timeout < 5){
			xconf_error (MSG_U(E_HTMLTIMEOUT,"The html timeout must be 5 minutes or higher"));
		}else{
			linuxconf_replace (LINUXCONF,HTMLTIMEOUT,html_timeout);
			linuxconf_save();
			break;
		}
	}
}

static void linuxconf_logs()
{
	if (perm_access (&p_logs,MSG_U(P_VIEWLOGS
		,"enable configuration changes"))){
		int choice = 0;
		while (1){
			static const char *bootlogs = MSG_U(M_BOOTLOGS,"Boot messages");
			static const char *mylogs   = MSG_U(M_LINUXCONFLOGS,"Linuxconf logs");
			static const char *messages = MSG_U(M_NORMALLOG,"Normal activity logs");
			static const char *errors   = MSG_U(M_ERRORLOGS,"Error logs");

			static const char *menuopt[]={
				" ",		bootlogs,
				" ",		mylogs,
				" ",		messages,
				" "	,		errors,
				NULL
			};
			MENU_STATUS code = xconf_menu (MSG_U(T_SYSLOGS,"System logs")
				,MSG_U(I_SYSLOGS
					,"This menu let you see the different messages generated\n"
					 "by the system. These messages are normally checked to\n"
					 "either detect some problems or as a proof that some event\n"
					 "did happened.")
				,help_logs
				,menuopt,choice);
			if (code != MENU_OK){
				break;
			}else{
				const char *key = menuopt[choice*2+1];
				if (key == bootlogs){
					boot_showlog();
				}else if (key == mylogs){
					net_showlog();
				}else if (key == messages){
				}else if (key == errors){
				}
			}
		}
	}
}



/*
	Main dispatcher to all other configs
*/
void linuxconf_main(int dontcheck)
{
	if (!netconf_mainaccess()) return;
	int choice = 0;
	int was_checked = 0;
	while (1){
		static const char *config_basic  = MSG_U(MNU_BASIC,"basic host information");
		static const char *config_askrun = MSG_U(MNU_BOOT,"boot mode");
		static const char *view_logs	 = MSG_U(MNU_LOGS,"logs");
		static const char *config_fstab	 = MSG_U(MNU_FILESYS,"File systems");
		static const char *config_graphic= MSG_U(MNU_GRAPH,"Graphic mode (X)");
		static const char *config_net	 = MSG_U(MNU_NET,"Networking");
		static const char *config_user	= MSG_U(MNU_USERS,"Users accounts");
		static const char *config_datetime = MSG_U(MNU_DATE,"date & time");
		static const char *config_file	= MSG_U(MNU_CONFIGS,"all configuration files");
		static const char *commands	= MSG_U(MNU_COMMANDS,"all commands and daemons");
		static const char *control	= MSG_U(MNU_CONTROL,"Control panel");
		static const char *config_module = MSG_U(MNU_MODULE,"Linuxconf's modules");
		static const char *config_features = MSG_U(M_FEATURES,"Linuxconf's features");

		static const char *menuopt[]={
			MSG_U(MNU_CONFIG,"Configure"),config_basic,
			"",			config_net,
			"",			config_user,
			"",			config_fstab,
			//"",			config_graphic,
			"",			config_askrun,
			"",			config_module,
			"",			config_features,
			MSG_U(MNU_SET,"Set"),		config_datetime,
			"-",		"",
			" ",		control,
			MSG_U(MNU_VIEW,"View"),		view_logs,
			MSG_U(MNU_LIST,"List"),		config_file,
			" ",						commands,
			"-",		MSG_U(M_MODULES,"Modules"),
			NULL
		};
		DIALOG dia;
		dia.new_menuitems (menuopt);
		char title[80];
		extern char *revision;
		#if LINUXCONF_SUBREVISION > 0
			sprintf (title,"%s %s (subrev %d)"
				,MSG_U(TITLE,"LINUX Configuration manager")
				,revision,LINUXCONF_SUBREVISION);
		#else
			sprintf (title,"%s %s"
				,MSG_R(TITLE),revision);
		#endif
		dialog_clear();
		dia.html_intro (
			MSG_U(I_HTMLINTRO,"<em>\n"
			"This is the main entry to Linux configuration.\n"
			"Check out the help of this screen. It is an\n"
			"introduction to Linuxconf"
			"</em>\n"));
		MENU_STATUS code = dia.editmenu (MENU_MAIN
			,title
			,MSG_U(MNU_INTRO,"This is the main entry to Linux configuration.\n"
			 "\n"
			 "Use the TAB key to navigate between the field\n"
			 "section and the button bar at the bottom\n"
			 "Check out the help of this screen. It is an\n"
			 "introduction to Linuxconf")
			,help_intro
			,choice,0);
		if (code != MENU_OK){
			break;
		}else{
			was_checked = 0;
			const char *key = menuopt[choice*2+1];
			if (key == config_basic){
				netconf_edithost();
			}else if (key == config_fstab){
				fstab_edit ();
			}else if (key == config_graphic){
				xconf_edit ();
			}else if (key == config_net){
				netconf_edit ();
			}else if (key == config_askrun){
				askrunlevel_config();
			}else if (key == config_module){
				module_config();
			}else if (key == view_logs){
				linuxconf_logs();
			}else if (key == config_user){
				userconf_edit();
			}else if (key == config_file){
				configf_show();
			}else if (key == commands){
				daemon_config();
			}else if (key == config_datetime){
				datetime_edit();
			}else if (key == control){
				was_checked = linuxconf_control();
			}else if (key == config_features){
				linuxconf_features();
			}
		}
	}
	if (!dontcheck && !was_checked) netconf_checkupdate();
}

