#pragma implementation
#include "mailconf.h"
#include "internal.h"
#include <netconf.h>
#include "mailconf.m"

MAILCONF_HELP_FILE help_mailconf ("intro");
extern CONFIG_FILE f_sendmail;

PUBLIC void MAILCONF::spcs_edit()
{
	if (spcs.edit() == 0){
		spcs.build(features.dbformat.get());
	}
}

void mailconf_edit()
{
	/* #Specification: mailconf / main menu
	*/
	int choice=0;
	int modified = 0;
	while (1){
		static const char *basic = MSG_U(M_BASIC,"basic information");
		static const char *spc_route = MSG_U(M_SPECIAL,"special (domain) routing");
		static const char *cplx_route = MSG_U(M_COMPLEX,"complex (user) routing");
		static const char *virt_domain = MSG_U(M_VIRTDOM,"virtual email domain");
		static const char *ualias = MSG_U(M_ALIASES,"user aliases");
		static const char *test_cases = MSG_U(M_TESTS,"test cases");
		static const char *test_run = MSG_R(M_TESTS);
		const char *sendpath = f_sendmail.getpath();
		static const char *menuopt[]={
			MSG_U(M_CONFIG,"Configure"),	basic,
			" ",		spc_route,
			" ",		cplx_route,
			" ",		virt_domain,
			MSG_U(M_SETTING,"Setting"),	ualias,
			"-",		"",
			MSG_U(M_GENERATE,"Generate"),sendpath,
			//"Preparing",	test_cases,
			//"Run",		test_run,
			NULL
		};
		MENU_STATUS code = xconf_menu (
			MSG_U(T_SENDMAIL,"Sendmail configurator")
			,MSG_U(I_SENDMAIL
			 ,"This package allows you to configure\n"
			  "Sendmail, the mail delivery system\n")
			,help_mailconf
			,menuopt,choice);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			if (modified){
				char buf[100];
				sprintf (buf,MSG_U(Q_GENSENDMAIL,"Generating %s"),sendpath);
				char intro[1000];
				sprintf (intro
					,MSG_U(I_GENSENDMAIL
						,"You have modified sendmail's configuration.\n"
						 "A new %s must be generated.\n"
						 "Do you want to do it now")
					,sendpath);
				if (xconf_yesno(buf,intro,help_mailconf) == MENU_YES){
					MAILCONF mconf;
					mconf.generate(false);
				}
			}
			break;
		}else{
			const char *key = menuopt[choice*2+1];
			MAILCONF mconf;
			if (key == basic){
				modified |= mconf.basicedit();
			}else if (key == virt_domain){
				VDOMAINS vdomains;
				modified |= vdomains.edit();
			}else if (key == spc_route){
				mconf.spcs_edit();
			}else if (key == cplx_route){
				modified |= complex_edit();
			}else if (key == test_cases){
			}else if (key == test_run){
			}else if (key == ualias){
				aliases_edit();
			}else if (key == sendpath){
				mconf.generate(false);
				modified = 0;
			}
		}
	}
}

int mailconf_main(int, char *[])
{
	mailconf_edit();
	netconf_checkupdate();
	return 0;
}

