#pragma interface
#ifndef FSTAB_H
#define FSTAB_H

#include "misc.h"

#define PARTITION_OS2_HPFS	0x07
#define PARTITION_LINUX_MINIX	0x81
#define PARTITION_LINUX_SWAP	0x82
#define PARTITION_LINUX_NATIVE	0x83
#define PARTITION_DOS_ID12	0x01
#define PARTITION_DOS_ID16	0x04
#define PARTITION_DOS_ID1632	0x06
#define PARTITION_DOS_IDEXT	0x05

enum FSTAB_ENTRY_TYPE {
	FSTAB_ENTRY_LOCAL=0,
	FSTAB_ENTRY_NFS=1,
	FSTAB_ENTRY_SAMBA=2,
	FSTAB_ENTRY_SWAP=3,
	FSTAB_ENTRY_NOVELL=4,
	FSTAB_ENTRY_PROC=5,
};

class PARTITION: public ARRAY_OBJ{
	char drive_letter;
	char *dev;	// Block special device
	int id;		// PARTITION_xxxx 
	long size;	// In block
	/*~PROTOBEG~ PARTITION */
public:
	PARTITION (const char *_dev, int _id, long _size);
	void formatinfo (char *buf);
	const char *getdevice (void);
	char getdosdrive (void);
	int getid (void);
	const char *getos (void);
	long getsize (void);
	int isdos (void);
	int islinux (void);
	int isos2 (void);
	int isswap (void);
	void setdosdrive (char letter);
	~PARTITION (void);
	/*~PROTOEND~ PARTITION */
};

class PARTITIONS: public ARRAY{
	/*~PROTOBEG~ PARTITIONS */
public:
	PARTITIONS (void);
	PARTITION *getitem (const char *device)const;
	PARTITION *getitem (int no)const;
protected:
	void setdosdrive (void);
public:
	/*~PROTOEND~ PARTITIONS */
};

class FSTAB_HELP_FILE: public HELP_FILE{
	/*~PROTOBEG~ FSTAB_HELP_FILE */
public:
	FSTAB_HELP_FILE (const char *fname);
	/*~PROTOEND~ FSTAB_HELP_FILE */
};

struct FSTAB_BOOL_OPT{
	char noauto;	// Not mount at boot time
	char noexec;	// Not allowed to execute a prog from
					// this partition
	char readonly;
	char user;		// User mountable
	char nodev;		// No special device file interpretation
	char nosuid;	// No suid program allowed
};
// Msdos and HPFS special option
struct FSTAB_MSDOS_OPT{
	SSTRING conv;		// Conversion mode for msdos
				// and hpfs
	int uid;
	int gid;
	int perm;
};					

struct FSTAB_NFS_OPT{
	int rsize;
	int wsize;
	char soft;
	char bg;
};

/*
	A FS_ENTRY describe one line of the /etc/fstab file.
	It also remember comments. All field (source mpoint etc except
	comment will be NULL).
*/
class FSTAB_ENTRY: public ARRAY_OBJ{
protected:
	SSTRING source;		// Device or NFS server+path
	SSTRING mpoint;		// Mount point.
	SSTRING type;		// Filesystem type.
	FSTAB_BOOL_OPT bool_opt;
	FSTAB_MSDOS_OPT msdos_opt;					
	FSTAB_NFS_OPT nfs_opt;
	SSTRING options;	// All option not directly understood
				// by this program.
	int dumpfreq;
	int fsckpriority;
	SSTRING comment;
	char valid;			// Tells if the record is valid
						// If not, it is managed as a comment
	/*~PROTOBEG~ FSTAB_ENTRY */
public:
	FSTAB_ENTRY (const char *line);
	FSTAB_ENTRY (void);
	int check (void);
	int edit (FSTAB_ENTRY_TYPE fstype);
	void format_opt (int tosave, char *str)const;
	const char *getcomment (void);
	const char *getfs (void)const;
	const char *getmpoint (void)const;
	const char *getsource (void)const;
	FSTAB_ENTRY_TYPE gettype (void)const;
private:
	void init (void);
public:
	int is_auto (void);
	int is_remote (void)const;
	int is_swap (void)const;
	int is_valid (void)const;
	void parseopt (char *opts);
	void print (FILE *fout)const;
	void setsource (const char *path);
	/*~PROTOEND~ FSTAB_ENTRY */
};

// Common to /etc/fstab and  /etc/mtab
class FSTAB_GEN: public ARRAY{
	/*~PROTOBEG~ FSTAB_GEN */
public:
	FSTAB_ENTRY *getitem (int no);
	FSTAB_ENTRY *locate_mpoint (const char *str);
	/*~PROTOEND~ FSTAB_GEN */
};
class FSTAB: public FSTAB_GEN {
protected:
	/*~PROTOBEG~ FSTAB */
public:
	FSTAB (void);
	void check (void);
	void edit (FSTAB_ENTRY_TYPE fstype);
private:
	void fixroot (FSTAB_ENTRY *root, char *status);
public:
	const char *getrootdev (void);
	int write (void);
	/*~PROTOEND~ FSTAB */
};
class MTAB: public FSTAB_GEN {
protected:
	/*~PROTOBEG~ MTAB */
public:
	MTAB (void);
	/*~PROTOEND~ MTAB */
};

#include "fstab.p"

#endif

