#pragma interface
#ifndef INTERNAL_H
#define INTERNAL_H

#include <stdio.h>
#ifndef MISC_H
	#include "misc.h"
#endif

#ifndef DNSCONF_H
	#include "dnsconf.h"
#endif

class IP_ADDRS: public ARRAY{
	/*~PROTOBEG~ IP_ADDRS */
public:
	IP_ADDR *getitem (int no)const;
	void sort (void);
	/*~PROTOEND~ IP_ADDRS */
};

class DNSCONF_HELP_FILE: public HELP_FILE{
	/*~PROTOBEG~ DNSCONF_HELP_FILE */
public:
	DNSCONF_HELP_FILE (const char *fname);
	/*~PROTOEND~ DNSCONF_HELP_FILE */
};

struct RECORD_PARSE{
	long ttl;
	bool nottl;
	char f1[200];
	char f2[200];
	char f3[200];
	char f4[200];
	char f5[200];
	char f6[200];
	char f7[200];
	char f8[200];
	/*~PROTOBEG~ RECORD_PARSE */
public:
	RECORD_PARSE (void);
	/*~PROTOEND~ RECORD_PARSE */
};


// Manage a bunch of open file (open recursivly)
class TBFILE{
	char *defpath;
	int nbopen;
	FILE *tb[10];	// Maximum 10 level of include file
public:
	FILE *cur;	// Current open file
	/*~PROTOBEG~ TBFILE */
public:
	TBFILE (const char *_defpath);
	void fclose (void);
	FILE *fopen (const char *fname, const char *mode);
	~TBFILE (void);
	/*~PROTOEND~ TBFILE */
};


class TIMESTR: public SSTRING{
public:
	long seconds;		// Store a duration in seconds
				// while the SSTRING store it
				// in hh:mm:ss format
	/*~PROTOBEG~ TIMESTR */
public:
	TIMESTR (long _seconds);
	TIMESTR (void);
private:
	void formatstr (void);
public:
	void setfrom (const char *_str);
	void setfrom (long _seconds);
	/*~PROTOEND~ TIMESTR */
};

class RECORD_IN_CNAME: public RECORD_IN{
public:
	IN_NAME nickname;
	IN_NAME name;
	/*~PROTOBEG~ RECORD_IN_CNAME */
public:
	RECORD_IN_CNAME (const RECORD_PARSE&p);
	RECORD_IN_CNAME (const char *cname,
		 const char *realname);
	int cmp_left (const char *str);
protected:
	int cmpsame (const RECORD *other);
public:
	void print (FILE *fout)const;
	void sethostpart (const char *hostpart);
	/*~PROTOEND~ RECORD_IN_CNAME */
};
class RECORD_IN_SOA: public RECORD_IN{
public:
	SSTRING domain;
	SSTRING machine;
	SSTRING admin;
	long old_serial;
	long new_serial;
	TIMESTR refresh;
	TIMESTR retry;
	TIMESTR expire;
	TIMESTR default_ttl;
	/*~PROTOBEG~ RECORD_IN_SOA */
public:
	RECORD_IN_SOA (const RECORD_PARSE&p);
	RECORD_IN_SOA (void);
	void print (FILE *fout)const;
	void update (const char *name);
	/*~PROTOEND~ RECORD_IN_SOA */
};

class RECORD_IN_NS: public RECORD_IN{
public:
	IN_NAME name;
	IN_NAME ns;
	/*~PROTOBEG~ RECORD_IN_NS */
public:
	RECORD_IN_NS (const RECORD_PARSE&p);
	RECORD_IN_NS (const char *_name, const char *_ns);
	RECORD_IN_NS (void);
	int cmp_left (const char *str);
protected:
	int cmpsame (const RECORD *other);
public:
	void print (FILE *fout)const;
	int set (const RECORD *other);
	void sethostpart (const char *hostpart);
	/*~PROTOEND~ RECORD_IN_NS */
};
class RECORD_IN_MX: public RECORD_IN{
public:
	IN_NAME mailname;
	IN_NAME servname;
	int prefer;
	/*~PROTOBEG~ RECORD_IN_MX */
public:
	RECORD_IN_MX (const RECORD_PARSE&p);
	RECORD_IN_MX (const char *_mailname,
		 int priority,
		 const char *_servname);
	int cmp_left (const char *str);
protected:
	int cmpsame (const RECORD *other);
public:
	void print (FILE *fout)const;
	int set (const RECORD *other);
	void sethostpart (const char *hostpart);
	/*~PROTOEND~ RECORD_IN_MX */
};

class RECORD_INCLUDE: public RECORD{
public:
	SSTRING path;
	/*~PROTOBEG~ RECORD_INCLUDE */
public:
	RECORD_INCLUDE (const char *_path);
	void print (FILE *fout)const;
	/*~PROTOEND~ RECORD_INCLUDE */
};
// A simple marker for telling the system where the include stops in the
// list. All record are stored in a single list even if they comes from
// include files.
class RECORD_END_INCLUDE: public RECORD{
	/*~PROTOBEG~ RECORD_END_INCLUDE */
public:
	RECORD_END_INCLUDE (void);
	void print (FILE *)const;
	/*~PROTOEND~ RECORD_END_INCLUDE */
};

struct FQHOST_DECOMP{
	char host[100];
	char domain[100];
};

class FQHOST{
public:
	int nbelm;	// Number of variation possible.
			// To speed up manipulation
	FQHOST_DECOMP tb[10];
	/*~PROTOBEG~ FQHOST */
public:
	FQHOST (const SSTRING&host);
	FQHOST (const char *host);
	FQHOST (const char *host, const char *domain);
	void formatfull (SSTRING&full);
	void formatfull (char *full);
	const char *gethostpart (const char *domain);
private:
	void init (const char *host);
public:
	int is_member (const char *domain, char *hostpart);
	/*~PROTOEND~ FQHOST */
};

class IPMAP: public ARRAY_OBJ{
	friend class IPMAPS;
	SSTRING iprange;
	IP_ADDR minimum;	// iprange is convert into a minimum/maximum
	IP_ADDR maximum;
	IP_ADDR avail;		// First available IP number in the range
	int over;			// No IP number available in the range
	SSTRING comment;
	/*~PROTOBEG~ IPMAP */
public:
	IPMAP (const char *line);
	IPMAP (void);
	int setup (void);
	void setuse (const IP_ADDR *adr);
	/*~PROTOEND~ IPMAP */
};

class IPMAPS: public ARRAY{
	/*~PROTOBEG~ IPMAPS */
public:
	IPMAPS (void);
	int edit (void);
	IPMAP *getitem (int no);
private:
	void newdiaf (DIALOG&dia, IPMAP *e);
public:
	void setcombo (class FIELD_COMBO *comb);
	void setuse (IP_ADDRS&adrs);
	int write (void);
	/*~PROTOEND~ IPMAPS */
};

#endif

