#include <stdio.h>
#include <string.h>
#include "diadef.h"
#include "dialog.h"
#include "internal.h"

PRIVATE void DIALOG::showtimeout(WINDOW *win)
{
	int t = dialog_getcurtimeout();
	if (t > 0){
		wmove(win, height-1,width-6);
		wattrset(win, dialog_attr);
		char buf[10];
		sprintf (buf,"%3d ",t);
		waddstr (win,buf);
	}
}

PRIVATE MENU_STATUS DIALOG::editterm(
	int &nof,
	int but_options)
{
	MENU_STATUS ret = MENU_NULL;
	WINDOW *dialog = dialog_openwin (height,width);
	if (nof >= getnb()) nof = getnb()-1;
	if (nof < 0) nof = 0;
	if (nof < offset){
		setoffset (nof);
	}else if (nof >= offset + nbvisible){
		int newoff = nof;
		if (newoff + nbvisible > getnb()){
			newoff = getnb() - nbvisible;
		}
		setoffset (newoff);
	}
	draw(dialog);
	dialog_starttimeout();
	showtimeout(dialog);
	int last_nof = nof;
	bool arrow_up = false;
	bool arrow_down = false;
	while (ret == MENU_NULL) {
		drawarrow_if (dialog,offset>0,arrow_up,true,ACS_UARROW);
		drawarrow_if (dialog,offset+nbvisible<getnb()
			,arrow_down,false,ACS_DARROW);
		if (button == -1){
			if (last_nof != nof
				&& last_nof >= offset
				&& last_nof < offset + nbvisible){
				getitem(last_nof)->unselect(dialog);
			}
			if (nof >= 0 && nof < getnb()){
				getitem(nof)->setcursor (dialog);
			}
			last_nof = nof;
		}
		int key = dialog_wgetch(dialog,ret);
		/* #Specification: F3 key / escape
			F3 was not used in Linuxconf and some people claims it
			is fairly common as an equivalent for the escape key.
			So linuxconf support both! Comments are welcome.
		*/
		if (key == ESC || key == KEY_F(3)){
			ret = MENU_ESCAPE;
			break;
		}else if (ret == MENU_INTERNAL_TIMEOUT){
			// Update the timeout counter at the bottom
			showtimeout(dialog);
			ret = MENU_NULL;
		}else if (ret != MENU_NULL){
			break;
		}else if (button != -1 || key == KEY_F(1)){
			ret = buttons->dokey (dialog,key,button,getnb()>0);
		}else if (keymove(dialog,key,nof)==-1){
			switch (key) {
			case TAB:
				button = 0;
				buttons->draw(dialog,button);
				break;
			case '\n':
				if (but_options & MENUBUT_OK){
					ret = MENU_OK;
				}else if (getnb()==1){
					/* #Specification: dialogue / single field case
						A <enter> in a dialogue with a single
						field exit as the first button
						was selected (Generally <Accept>)
						
						If the dialog contain a <Ok> button
						it does the same whatever the number
						of fields. This is a special case for
						menu dialog.
					*/
					button = 0;
					ret = buttons->dokey (dialog,key,button,1);
				}else{
					keymove (dialog,KEY_DOWN,nof);
				}
				break;
			default:
				{
					FIELD_MSG msg;
					getitem(nof)->dokey (dialog,key,msg);
					if (msg.is_loaded) processmsg(dialog,msg);
				}
			}
		}
	}
	attr_clear(stdscr, LINES, COLS, screen_attr);
	wnoutrefresh(stdscr);
	delwin(dialog);
	return ret;
}

