#pragma interface
#ifndef INTERNAL_H
#define INTERNAL_H

#ifndef MISC_H
	#include <misc.h>
#endif


class BUTTONS_INFO {
	int but_options;	// Set of MENUBUT_xxxx
	int nb;
	const char *tb_title[10];
	const char *tb_icon[10];
	MENU_STATUS tbret[10];	// Return code associated with a button
	int y;			/* Coordinate of the line where the buttons are drawn */
	int tbx[10];	/* Horizontal coordinate of each buttons */
	SSTRING helpfile;	/* File to show when help is selected */
	struct {
		short int id;
		SSTRING title;
		SSTRING icon;
	}tbusr[3];
	int nbusr;
	/*~PROTOBEG~ BUTTONS_INFO */
public:
	BUTTONS_INFO (void);
	MENU_STATUS dokey (WINDOW *dialog,
		 int key,
		 int &selected,
		 int other_focus);
	void draw (WINDOW *dialog, int button);
	int evalwidth (void);
private:
	void help (WINDOW *win);
public:
	void html_draw (void);
	void set (int _but_options, HELP_FILE&_helpfile);
	void setbutinfo (int id,
		 const char *title,
		 const char *icon);
	void setcursor (WINDOW *dialog, int button);
	void setup (int _y, int width);
	/*~PROTOEND~ BUTTONS_INFO */
};

class HTML_VARVAL{
	SSTRINGS vars;
	SSTRINGS vals;
	SSTRING context;
	int id;
	/*~PROTOBEG~ HTML_VARVAL */
public:
	HTML_VARVAL (const char *key);
	void add (const char *var, const char *val);
	int exist (const char *var);
	const char *getcontext (void);
	int getid (void);
	int getnb (void);
	const char *getval (const char *var, int &exist);
	const char *getval (int no);
	const char *getvar (int no);
	/*~PROTOEND~ HTML_VARVAL */
};


#endif

