#pragma implementation
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <misc.h>
#include "dialog.h"
#include "fcombo.h"
#include "dialog.m"

PUBLIC ELM_STR::ELM_STR(const char *_value, const char *_verbose)
{
	value = strdup(_value);
	verbose = strdup(_verbose);
}

PUBLIC ELM_STR::~ELM_STR()
{
	free (value);
	free (verbose);
}

PUBLIC ELM_STR *LIST_STR::getitem(int no)
{
	return (ELM_STR*)ARRAY::getitem(no);
}
/*
	Get the "significative" value associate of one item of the choice list
*/
PUBLIC const char *LIST_STR::getvalue(int no)
{
	const char *ret = "";
	ELM_STR *e = getitem(no);
	if (e != NULL){
		ret = e->value;
		if (strcmp(ret," ")==0 || ret[0] == '\0') ret = e->verbose;
	}
	return ret;
}
/*
	The FIELD_COMBO class is a string editor with an assist
	hot key. When triggered a list of string is displayed
	and the user is allowed to pick a value from there.
	The value (if selected) will replace the input buffer.
*/
PUBLIC FIELD_COMBO::FIELD_COMBO(
	const char *_prompt,
	SSTRING &_str)
	: FIELD_STRING_HELP (_prompt,_str)
{
	opts = new LIST_STR;
	listvalueonly = 0;
}

/*
	The FIELD_LIST class is a selector editor with an assist
	hot key. When triggered a list of string is displayed
	and the user is allowed to pick a value from there.
	The value (if selected) will replace the input buffer.

	The use may either use the input buffer to type the value or use
	the list, but the input has to come from the list.
*/
PUBLIC FIELD_LIST::FIELD_LIST(
	const char *_prompt,
	SSTRING &_str)
	: FIELD_COMBO (_prompt,_str)
{
	listvalueonly = 1;
}

PUBLIC FIELD_COMBO::~FIELD_COMBO()
{
	delete opts;
}

/*
	Add one string option to the combo box pick list
*/
PUBLIC void FIELD_COMBO::addopt(const char *str)
{
	opts->add (new ELM_STR(" ",str));
}
/*
	Add one string option to the combo box pick list.
	This time there is two string. The strings will be show in
	the pick list like this

	value verbose
*/
PUBLIC void FIELD_COMBO::addopt(const char *value, const char *verbose)
{
	opts->add (new ELM_STR(value,verbose));
}
PROTECTED void FIELD_COMBO::assist(WINDOW *dialog)
{
	int nbopt = opts->getnb();
	char **tbopt = (char**)malloc_err(nbopt*2*sizeof(char*));
	for (int i=0,ii=0; i<nbopt; i++){
		ELM_STR *elm = opts->getitem(i);
		tbopt[ii++] = elm->value;
		tbopt[ii++] = elm->verbose;
	}
	int sel = 0;
	MENU_STATUS ret = dialog_menu ("Help list"
		,"Pick one value"
		,help_nil
		,0
		,nbopt,tbopt,sel);
	free (tbopt);
	touchwin(stdscr);
	touchwin(dialog);
	if (ret == MENU_OK){
		strcpy (buf,opts->getvalue(sel));
		draw(dialog);
	}
}

PUBLIC void FIELD_COMBO::html_draw(int nof)
{
	char key[100];
	format_htmlkey (key,nof);
	html_printf ("<tr><td>%s<td>",prompt);
	if (readonly){
		html_printf ("%s\n",buf);
	}else{
		if (!listvalueonly){
			html_defvar ("text",key,buf,"size=30 maxlength=256");
		}
		html_defvarcur (key,backup.get());
		int n = opts->getnb();
		if (n > 0){	
			char sel_key[100];
			sprintf (sel_key,"SELECT_%s",key);
			html_defselect (sel_key);
			if (!listvalueonly) html_printf ("<OPTION VALUE=0>\n");
			for (int i=0; i<n; i++){
				int id = i+1;
				const char *vstr = opts->getvalue(i);
				ELM_STR *e = opts->getitem(i);
				if (listvalueonly){
					html_printf ("<OPTION VALUE=%d %s>%s %s\n",id
						,strcmp(buf,vstr)==0 ? "selected" : ""
						,e->value,e->verbose);
				}else{
					#if 0
						html_printf ("<OPTION VALUE=%d>%s\n",id,vstr);
					#else
						html_printf ("<OPTION VALUE=%d>%s %s\n",id
							,e->value,e->verbose);
					#endif
				}
			}
			html_printf ("</SELECT>\n");
		}
	}
}

PUBLIC int FIELD_COMBO::html_validate(int nof)
{
	int ret = -1;
	char key[100];
	format_htmlkey (key,nof);
	const char *old_val = html_getoldval (key);
	const char *new_val = html_getval (key);
	char sel_key[100];
	sprintf (sel_key,"SELECT_%s",key);
	int sel_val = atoi(html_getval (sel_key));
	fprintf (stderr,"validate combo %s val :%s: old :%s: buf :%s: sel_val %d\n",key,new_val,old_val,buf,sel_val);
	if (strcmp(buf,old_val)==0){
		if (sel_val != 0 || listvalueonly){
			strcpy (buf,opts->getvalue(sel_val-1));
		}else{
			strcpy (buf,new_val);
		}
		ret = 0;
	}
	return ret;
}

/*
	Add a combo field to the dialog.
	The object will be destroyed by the dialog itself.
	The object is returned so the caller may add options in the
	pick list.
*/
PUBLIC FIELD_COMBO *DIALOG::newf_combo(
	const char *prompt,
	SSTRING &str)
{
	FIELD_COMBO *s = new FIELD_COMBO(prompt,str);
	add (s);
	return s;
}

/*
	Add a selection field to the dialog.
	The object will be destroyed by the dialog itself.
	The object is returned so the caller may add options in the
	pick list.

	Unlike a combo, the user may not enter anything in it. The value
	must be in the list.
*/
PUBLIC FIELD_LIST *DIALOG::newf_list(
	const char *prompt,
	SSTRING &str)
{
	FIELD_LIST *s = new FIELD_LIST (prompt,str);
	add (s);
	return s;
}

PUBLIC VIRTUAL int FIELD_LIST::post_validate()
{
	int ret = -1;
	int n = opts->getnb();
	for (int i=0; i<n; i++){
		if (strcmp(buf,opts->getvalue(i))==0){
			ret = 0;
			break;
		}
	}
	if (ret == -1){
		xconf_error (MSG_U(E_INLIST,"The value must be taken from the list"));
	}
	return ret;
}

PUBLIC void FIELD_LIST::dokey (
	WINDOW *dialog,
	int ,
	FIELD_MSG &)
{
	if (!is_readonly()) assist(dialog);
}

static SSTRING tmpstr;

/* #Specification: FIELD_ENUM / principle
	A FIELD_ENUM is like a field list, except that the information
	edited is the index (a selector) in the list, while the FIELD_LIST
	edit a string which must have the value of one of the item of the list

	In the FIELD_ENUM, we want to know which elm was choosen.
*/
#
/*
	We do a trick. The contructor for FIELD_LIST need a SSTRING.
	We give a dummy.
	Later when the addopt are done, we will fill the edit buffer
*/
PUBLIC FIELD_ENUM::FIELD_ENUM(
	const char *_prompt,
	int &_sel)
	: FIELD_LIST (_prompt,tmpstr), sel(_sel)
{
	backup_sel = sel;
}

PUBLIC void FIELD_ENUM::restore()
{
	sel = backup_sel;
}

PUBLIC void FIELD_ENUM::save()
{
	int n = opts->getnb();
	for (int i=0; i<n; i++){
		if (strcmp(buf,opts->getvalue(i))==0){
			sel = i;
			break;
		}
	}
}	

PUBLIC void FIELD_ENUM::addopt(const char *str)
{
	if (opts->getnb()==sel){
		strcpy (buf,str);
		backup.setfrom(str);
	}
	FIELD_LIST::addopt(str);
}
/*
	Add one string option to the combo box pick list.
	This time there is two string. The strings will be show in
	the pick list like this

	value verbose
*/
PUBLIC void FIELD_ENUM::addopt(const char *value, const char *verbose)
{
	FIELD_LIST::addopt(value,verbose);
	if (opts->getnb()==sel+1){
		strcpy (buf,opts->getvalue(sel));
		backup.setfrom(buf);
	}
}

/*
	Create a FIELD_ENUM field
*/
PUBLIC FIELD_ENUM *DIALOG::newf_enum(
	const char *prompt,
	int &sel)
{
	FIELD_ENUM *s = new FIELD_ENUM(prompt,sel);
	add (s);
	return s;
}
	
