#include <ctype.h>
#include <limits.h>
#include "diadef.h"
#include "dialog.h"
#include "internal.h"
#include "dialog.m"

/*
	Evaluate the horizontal space needed to draw the buttons
*/
PUBLIC int BUTTONS_INFO::evalwidth()
{
	int ret = 0;
	for (int i=0; i<nb; i++){
		/* add 2 for the < > on each side */
		/* add 2 for some space around the buttons */
		ret += strlen(tb_title[i]) + 2+2;
	}
	if (!helpfile.is_empty()) ret += 6 + 2 + 2;
	return ret;
}
PUBLIC BUTTONS_INFO::BUTTONS_INFO()
{
	nb = 0;
	nbusr = 0;
}

PUBLIC void BUTTONS_INFO::setbutinfo (
	int id,					// MENU_xxxx (Not MENUBUT_xxxx)
	const char *title,		// Name that goes in the button
	const char *icon)		// Icon to use in html mode
{
	tbusr[nbusr].id = id;
	tbusr[nbusr].title.setfrom (title);
	tbusr[nbusr].icon.setfrom (icon);
	nbusr++;
}

PUBLIC void BUTTONS_INFO::set(
	int _but_options,	// MENUBUT_xxxx | MENUBUT_xxxx | ...
	HELP_FILE &_helpfile)
{
	nb = 0;
	but_options = _but_options;
	/*
		Not all buttons combination are meaningful. This
		explain why several buttons may share the same
		but_ret value.
	*/
	static struct BUTTON_ALL{
		short but_id;
		MENU_STATUS but_ret;	// Returned value when this button
					// is picked
		const char *str;
		const char *icon;
	} tbl[]={
		{ MENUBUT_YES,	MENU_YES,	MSG_U(B_YES,"Yes"),	"Yes"	},
		{ MENUBUT_NO,	MENU_NO,	MSG_U(B_NO,"No"),	"No"	},
		{ MENUBUT_OK,	MENU_OK,	MSG_U(B_OK,"Ok"),	"Ok",	},
		{ MENUBUT_ACCEPT,	MENU_ACCEPT,	MSG_U(B_ACCEPT,"Accept"),	"Accept"},
		{ MENUBUT_CANCEL,	MENU_CANCEL,	MSG_U(B_CANCEL,"Cancel"),	"Cancel"},
		{ MENUBUT_QUIT,		MENU_QUIT,	MSG_U(B_QUIT,"Quit"),		"Quit"	},
		{ MENUBUT_SAVE,		MENU_SAVE,	MSG_U(B_SAVE,"Save"),		"Save"	},
		{ MENUBUT_ADD,		MENU_ADD,	MSG_U(B_ADD,"Add"),			"Add"	},
		{ MENUBUT_DEL,		MENU_DEL,	MSG_U(B_DEL,"Del"),			"Del"	},
		{ MENUBUT_INS,		MENU_INS,	MSG_U(B_INS,"Ins"),			"Ins"	},
		{ MENUBUT_EDIT,		MENU_EDIT,	MSG_U(B_EDIT,"Edit"),		"Edit"	},
		{ MENUBUT_RESET,	MENU_RESET,	MSG_U(B_RESET,"Reset"),		"Reset"	},
		{ MENUBUT_MORE,		MENU_MORE,	MSG_U(B_MORE,"More"),		"More"	},
		{ MENUBUT_USR1,		MENU_USR1,	MSG_U(B_USR1,"Usr1"),		"Usr1"	},
		{ MENUBUT_USR2,		MENU_USR2,	MSG_U(B_USR2,"Usr2"),		"Usr2"	},
		{ MENUBUT_USR3,		MENU_USR3,	MSG_U(B_USR3,"Usr3"),		"Usr3"	},
	};
	BUTTON_ALL *ptl = tbl;
	for (unsigned i=0; i<sizeof(tbl)/sizeof(tbl[0]); i++, ptl++){
		if ((ptl->but_id & _but_options) != 0
			&& (ptl->but_id != MENUBUT_OK || _but_options == MENUBUT_OK)){
			/* #Specification: dialog / MENUBUT_OK / nerver displayed
				The button "Ok" is never shown except if it is the
				only button of the dialog. It is implied by an
				<enter> on a menu item. Initially it was shown but soon
				user have started complaining that it was useless.

				From the outside, it looks like a normal buttons, but
				deep in dialog/buttons.c, it is simply not shown.
			*/
			tb_title[nb] = ptl->str;
			tb_icon[nb] = ptl->icon;
			int but_ret = tbret[nb] = ptl->but_ret;
			for (int u=0; u<nbusr; u++){
				if (tbusr[u].id == but_ret){
					tb_title[nb] = tbusr[u].title.get();
					tb_icon[nb] = tbusr[u].icon.get();
					break;
				}
			}
			nb++;
		}
	}
	char rpath[PATH_MAX];
	_helpfile.getrpath(rpath);
	helpfile.setfrom (rpath);
	if (!helpfile.is_empty()){
		tb_title[nb] = MSG_U(B_HELP,"Help");
		tb_icon[nb] = "Help";
		tbret[nb] = MENU_HELP;
		nb++;
	}
}	

/*
	Setup the coordinate of each button in the dialog
*/
PUBLIC void BUTTONS_INFO::setup(
	int _y,		// Line where the buttons will be drawn
	int width)	// Width of the window
{
	if (nb > 0){
		y = _y;
		int onebut = width/nb;
		for (int i=0; i<nb; i++){
			const char *but = tb_title[i];
			tbx[i] = i*onebut + (onebut - strlen(but))/2 - 1;
		}
	}
}	

/*
	Set the screen cursor on the active button
*/
PUBLIC void BUTTONS_INFO::setcursor (
	WINDOW *dialog,
	int button)	// Which buttons is currently selected
			// or -1 if none
{
	if (button != -1 && button < nb){
		int x = tbx[button];
		const char *but = tb_title[button];
		while (*but == ' '){
			but++;
			x++;
		}
		wmove (dialog,y,x+1);
	}
}

/*
	Draw all buttons
*/
PUBLIC void BUTTONS_INFO::draw(
	WINDOW *dialog,
	int button)		// Which buttons is currently selected
				// or -1 if none
{
	for (int i=0; i<nb; i++){
		print_button(dialog,tb_title[i],y,tbx[i]
			, button == i ? TRUE : FALSE);
	}
	setcursor (dialog,button);
}
PRIVATE void BUTTONS_INFO::help (WINDOW *win)
{
	char path[PATH_MAX];
	const char *relpath = helpfile.get();
	if (html_locatefile (relpath,".help",path)!=-1){
		dialog_textbox (path,path);
		touchwin(stdscr);
		touchwin(win);
		dialog_clear ();
		refresh();
	}else{
		xconf_error (MSG_U(E_NOHELPFILE,"Missing help file %s"),relpath);
	}
}

/*
	Process one key.
	This function is called when the focus is in the button section.
	It will process the help button by itself.

	It return -1 is nothing special happened. It return the number
	of the selected button otherwise. The called generally
	terminate then.
*/
PUBLIC MENU_STATUS BUTTONS_INFO::dokey(
	WINDOW *dialog,
	int key,
	int &selected,
	int other_focus)	// Is there something other that buttons
				// or something that require specific focus
{
	MENU_STATUS ret = MENU_NULL;
	int button = selected;
	key = toupper(key);
	
	if (key == TAB){
		button++;
		if (button == nb) button = -1;
	}else if (key == KEY_RIGHT){
		button++;
		if (button == nb) button = 0;
	}else if (key == KEY_LEFT){
		button--;
		if (button == -1) button = nb-1;
	}else if (key == '\n'){
		if (!helpfile.is_empty() && button == nb -1){
			help (dialog);
			button = -1;
		}else{
			ret = tbret[button];
		}
	}else if (key == KEY_F(1) && !helpfile.is_empty()){
		help (dialog);
		button = -1;
	}else if (key == 'Y' && (but_options & MENUBUT_YES)){
		ret = MENU_YES;
	}else if (key == 'N' && (but_options & MENUBUT_NO)){
		ret = MENU_NO;
	}
	if (!other_focus && button == -1) button = 0;
	draw(dialog,button);
	selected = button;
	return ret;
}

