#include <unistd.h>
#include <limits.h>
#include "askrunlevel.h"
#include <misc.h>
#include <netconf.h>
#include "../paths.h"

static HELP_FILE helpf (HELP_ASKRUN,"ksyms");

static CONFIG_FILE f_procsym ("/proc/ksyms",helpf
	,CONFIGF_OPTIONNAL|CONFIGF_PROBED);


#if 0

struct PARMDESC{
	const char *parm;
	const char *desc;
};

enum USAGE_MODE {
	USAGE_KERNELD,		// On demand loading
	USAGE_BOOT,		// Load at boot time
	USAGE_MANUAL.		// Don't load automaticly
	USAGE_KERNELD_STICK,	// Load once with kerneld
};

class MODULE: public ARRAY_OBJ{
	SSTRING name;
	const PARMDESC *opts;	// Array of configurable parameter
	SSTRINGS values;	// With values
	USAGE_MODE umode;
	/*~PROTOBEG~ MODULE */
	/*~PROTOEND~ MODULE */
};

#endif

/*
	Make sure the modules are properly installed
	Return 0 if nothing at all, 1 if the directory exist, 2 if modules.dep
	exist.
*/
static int modules_installed()
{
	int ret = 0;
	int v[3];
	/* #Specification: modules / depmod
		linuxconf will call "depmod -a" if /lib/modules/kernel_version
		exist and /lib/modules/kernel_version/modules.dep do not exist
		and /proc/ksyms exist.
	*/
	if (kernel_version(v)!=-1
		&& f_procsym.exist()){
		char path[PATH_MAX];
		sprintf (path,"%s/%d.%d.%d",LIB_MODULES,v[0],v[1],v[2]);
		if (file_exist(path)){
			ret = 1;
			sprintf (path,"%s/%d.%d.%d/modules.dep",LIB_MODULES,v[0],v[1],v[2]);
			if (file_exist(path)){
				ret = 2;
			}
		}
	}
	return ret;
}
/*
	Make sure the modules are properly installed
*/
void modules_check()
{
	if (modules_installed() == 1){
		netconf_system_if ("depmod","-a");
	}
	{
		int avail = modules_avail();
		if (avail != -1) netconf_startstop ("kerneld",avail);
	}
}

/*
	Return 1 if there are some kernel modules available on this system,
		0 if there are none or -1 if it can't be sure.
*/
int modules_avail ()
{
	int ret = -1;
	if (modules_installed()==2){
		DAEMON *dae = daemon_find ("modprobe");
		if (dae != NULL && dae->is_managed()){
			char cmd[200];
			sprintf (cmd,"%s -l",dae->getpath());
			FILE *fin = popen (cmd,"r");
			ret = 0;
			if (fin != NULL){
				char buf[300];
				if (fgets(buf,sizeof(buf)-1,fin)!=NULL) ret = 1;
				fclose (fin);
			}
		}
	}
	return ret;
}

/*
	Just to ease linking
*/
void modules_dummy()
{
}

