#include <stdio.h>
#include <netconf.h>
#include "internal.h"

PUBLIC MODULE_APACHE::MODULE_APACHE()
{
	DAEMON *dae = new DAEMON_HTTPD;
	char buf[200];
	sprintf (buf,"%s -f %s",VAR_LIB_WWW_BIN_HTTPD,VAR_LIB_WWW_HTTPD_CONF);
	daemon_register (dae,"httpd",buf);
}
PUBLIC void MODULE_APACHE::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_NETWORK){
		dia.new_menuitem ("Configure","general options");
		dia.new_menuitem (" ","virtual domains");
		dia.new_menuitem ("Manage","restricted directories");
	}
}

PUBLIC int MODULE_APACHE::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_NETWORK){
		printf ("apache was called with key %s\n",key);
	}
	return 0;
}

PUBLIC int MODULE_APACHE::probe (int state, int target)
{
	int ret = 0;
	if (state == 2){
		ret = netconf_startstop ("httpd",1);
	}else if (state == 1 && target < 2){
		ret = netconf_startstop ("httpd",0);
	}
	return ret;
}

static MODULE_APACHE apache;

/*
	Restart httpd if HTTPD_CONF is newer than the process
*/
PUBLIC int DAEMON_HTTPD::startif ()
{
	/* #Specification: httpd / strategy
		httpd depends on /etc/httpd.conf.
		If the file is empty or do not exist, then httpd
		is not need. It will be killed, or not started.

		If httpd.conf is not empty, it will be started. If it is
		already running and httpd.conf is younger than the process,
		it will be kill and restart.

	*/
	extern CONFIG_FILE httpd_conf;
	return startif_file(httpd_conf);
}

