//==========================================================
// prefs.cpp
// Part of Kwatch
// (c) 1997 by Ralph C. Weichert

#include <qpushbt.h>
#include <qlabel.h>
#include <qfiledlg.h>
#include <qlayout.h>

#include <kapp.h>
#include <kfontdialog.h>
#include <kcolordlg.h>
#include <ksimpleconfig.h>

#include "utils.h"

#include "prefs.moc"

int set_width( QWidget * w, int wd = 0 ) {
    w->adjustSize();
    w->setMinimumSize( w->size() );
    w->setFixedHeight( w->height() );
    int w2 = w->width();
    return w2 > wd ? w2 : wd;
}

KLogPrefs::KLogPrefs ( KConfigBase * cfg, QWidget * parent,
                       const char * name, bool modal ) :
    QTabDialog( parent, name, modal )
{
    initMetaObject();
//     dir = new QDir();
    // KConfig * cfg = kapp -> getConfig();
    KLocale * locale = KApplication::getKApplication()->getLocale();

    filelist = getFileList( cfg );
    
    //======================================================
    QWidget * filetab = new QWidget( this );

    files = new QListBox( filetab );
    //    files -> setGeometry( 10, 10, 150, 100 );
    files -> insertStrList( filelist );

    QPushButton *newfile = new QPushButton( locale->translate( "Add..." ), filetab );
    //    newfile -> setGeometry( 170, 20, 50, 25 );
    connect( newfile, SIGNAL(clicked()), SLOT(addFile()) );

    QPushButton *delfile = new QPushButton( locale->translate( "Remove" ), filetab );
    //    delfile -> setGeometry( 170, 60, 50, 25 );
    connect( delfile, SIGNAL(clicked()), SLOT(delFile()) );

    int w = set_width( newfile );
    w = set_width( delfile, w );
    files->resize( 2*w, 100 );

    QHBoxLayout * hl = new QHBoxLayout( filetab, 10 );
    hl->addWidget( files, 1 );
    QVBoxLayout * vl = new QVBoxLayout();
    hl->addLayout( vl );
    vl->addWidget( newfile );
    vl->addWidget( delfile );
    vl->addStretch( 1);

    hl->activate();

    fileschanged = FALSE;
    addTab( filetab, locale->translate( "Files" ) );

    //======================================================
    QWidget * viewtab = new QWidget( this );

    cfg -> setGroup( "Window" );
    preview = new QLabel( viewtab );
    preview -> setFont( cfg -> readFontEntry( "Font", kapp -> font() ) );
    setPreviewForeground( cfg -> readColorEntry( "Foreground",
                                                 &foregroundColor() ) );
    preview -> setBackgroundColor( cfg -> readColorEntry( "Background",
                                                          &backgroundColor() ) );
    preview -> setText( locale->translate( "Sample\nText" ) );
    preview -> setAlignment( AlignCenter );
    preview -> setFrameStyle( QLabel::Panel | QLabel::Sunken );
    preview -> setGeometry( 10, 10, 100, 100 );

    QPushButton * fnt = new QPushButton( locale->translate( "Font..." ), viewtab );
    fnt -> setGeometry( 130, 10, 80, 25 );
    connect( fnt, SIGNAL(clicked()), SLOT(chooseFont()) );

    QPushButton * fg = new QPushButton( locale->translate( "Foreground..." ), viewtab );
    fg -> setGeometry( 130, 50, 80, 25 );
    connect( fg, SIGNAL(clicked()), SLOT(chooseForeground()) );

    QPushButton * bg = new QPushButton( locale->translate( "Background..." ), viewtab );
    bg -> setGeometry( 130, 90, 80, 25 );
    connect( bg, SIGNAL(clicked()), SLOT(chooseBackground()) );

    w = set_width( fnt );
    w = set_width( fg, w );
    w = set_width( bg, 0 );
    preview->resize( 2*w, 100 );

    hl = new QHBoxLayout( viewtab, 10 );
    hl->addWidget( preview, 1 );
    vl = new QVBoxLayout();
    hl->addLayout( vl );
    vl->addWidget( fnt );
    vl->addWidget( fg );
    vl->addWidget( bg );
    vl->addStretch( 1);

    hl->activate();

    fontchanged = fgchanged = bgchanged = FALSE;
    addTab( viewtab, locale->translate( "Window" ) );

    //======================================================
    resize( 240,200 );
    setOKButton( locale->translate( "OK" ) );
    setApplyButton( locale->translate( "Apply" ) );
    setCancelButton( locale->translate( "Cancel" ) );

    setCaption( locale->translate( "Kwatch Preferences" ) );

    resize( minimumSize() );

    connect( this, SIGNAL(applyButtonPressed()), SLOT(applyChanges()) );
}

KLogPrefs::~KLogPrefs() {
    delete filelist;
}

void KLogPrefs::addFile() {
    KLocale * locale = KApplication::getKApplication()->getLocale();
    QFileDialog * fd = new QFileDialog( this, "addfile", TRUE );
//     fd -> setDir( dir -> absPath() );
    // Why does this produce a core dump???
    fd -> setCaption( locale->translate( "Add file to log" ) );
    if (fd -> exec() == Accepted) {
        QString f = absFilePath( fd -> selectedFile() );
        if (!f.isEmpty()) {
            if (filelist -> find( f.data() ) < 0) {
                files -> insertItem( f.data() );
                filelist -> append( f.data() );
                fileschanged = TRUE;
            }
        }
    }
//     *dir = fd -> *dir();
    delete fd;
}

void KLogPrefs::delFile() {
    int i = files -> currentItem();
    if (i < 0) return;

    QString f = files -> text( i );
    if (f.isEmpty()) return;

    filelist -> remove( f );
    files -> removeItem( i );
    fileschanged = TRUE;
}

void KLogPrefs::chooseFont() {
    QFont f = preview -> font(), old = f;
    if (KFontDialog::getFont( f ) == Accepted && f != old) {
        preview -> setFont( f );
        fontchanged = TRUE;
    }        
}

void KLogPrefs::setPreviewForeground( const QColor &c ) {
    QPalette mypalette = (preview->palette()).copy();
    
    QColorGroup cgrp = mypalette.normal();
    QColorGroup ncgrp(c,preview->backgroundColor(),
                      cgrp.light(),cgrp.dark(),cgrp.mid(),c,
                      preview->backgroundColor());
    
    mypalette.setNormal(ncgrp);
    mypalette.setDisabled(ncgrp);
    mypalette.setActive(ncgrp);
    
    preview->setPalette(mypalette);
}

void KLogPrefs::chooseForeground() {
    QColor c = preview -> foregroundColor(), old = c;
    if (KColorDialog::getColor( c ) == Accepted && c != old) {
        setPreviewForeground( c );
        fgchanged = TRUE;
    }
}

void KLogPrefs::chooseBackground() {
    QColor c = preview -> backgroundColor(), old = c;
    if (KColorDialog::getColor( c ) == Accepted && c != old) {
        preview -> setBackgroundColor ( c );
        bgchanged = TRUE;
    }
}

void KLogPrefs::closeEvent( QCloseEvent *e ) {
    QTabDialog::closeEvent( e );
    emit dlgClosed();
}

void KLogPrefs::applyChanges() {
    if (fontchanged || fgchanged || bgchanged || fileschanged) {
        // KConfig * cfg = kapp -> getConfig();
        KSimpleConfig * cfg = new KSimpleConfig( "/dev/null" );
    
        if (fontchanged) {
            cfg -> setGroup( "Window" );
            cfg -> writeEntry( "Font", preview -> font() );
        }

        if (fgchanged) {
            cfg -> setGroup( "Window" );
            cfg -> writeEntry( "Foreground",
                               preview -> foregroundColor() );
        }

        if (bgchanged) {
            cfg -> setGroup( "Window" );
            cfg -> writeEntry( "Background",
                               preview -> backgroundColor() );
        }

        if (fileschanged)
            putFileList( cfg, *filelist );

        emit apply( cfg );
        
        // cfg->rollBack();
        delete cfg;
    }
}

// EOF
