//==========================================================
// main.cpp
// Part of Kwatch
// (c) 1997 by Ralph C. Weichert
//
// $Id: main.cpp,v 1.11 1998/03/08 01:05:42 rcw Exp $
//
// $Log: main.cpp,v $
// Revision 1.11  1998/03/08 01:05:42  rcw
// RMB gets check right
//
//
//==========================================================

#include "../config.h"
#include <kapp.h>
#include <kmsgbox.h>
#include <ksimpleconfig.h>
#include <kwm.h>

#include "prefs.h"
#include "main.moc"

TopLevel::TopLevel ( KConfig * cfg, QWidget * parent = 0, const char * name = 0 ) :
    QWidget( parent, name )
{
    initMetaObject();

    log = new KLogWidget( cfg, this, "logfiles" );

    prefs = NULL;

    setCaption( "Kwatch" );

    kapp->setTopWidget( this );
    kapp->enableSessionManagement();
    connect( kapp, SIGNAL(saveYourself()), SLOT(saveState()) );

    cfg -> setGroup( "Window" );

    show_date = cfg->readNumEntry( "ShowDate", TRUE );
    //    show_date = TRUE;                   //leon
    log->SetShowDate(show_date);        //leon
 
    QString s = cfg->readEntry( "geometry" );
    if ( !s.isEmpty() )
        setGeometry( KWM::setProperties( winId(), s ) );

    s = cfg -> readEntry( "Menubar" );
    if (s == "invisible")
        menubar_visible = FALSE;
    else
        menubar_visible = TRUE;
    s = cfg -> readEntry( "MenubarPosition", "top" );
    if ( s == "bottom" )
        initMenus( KMenuBar::Bottom );
    else if ( s == "floating" ) {
        initMenus( KMenuBar::Floating );
        s = cfg->readEntry( "menubargeometry" );
        if ( !s.isEmpty() )
            menubar->setGeometry( KWM::setProperties( menubar->winId(), s ) );
    }
    else initMenus( KMenuBar::Top );

    KDNDDropZone * drop = new KDNDDropZone( this, DndURL );
    connect( drop, SIGNAL(dropAction( KDNDDropZone *)),
             log, SLOT(dropEvent( KDNDDropZone *)) );
}

TopLevel::~TopLevel() {
    if (prefs) {
        prefs -> hide();
        delete prefs;
    }
    if (menubar) delete menubar;
}

void TopLevel::initMenus( KMenuBar::menuPosition mp ) {

    KLocale * locale = kapp->getLocale();

    QPopupMenu *file    = new QPopupMenu ();
    file -> insertItem( locale->translate( "&Reopen files" ), log, SLOT(reOpen()) );
    file -> insertSeparator ( -1 );
    file -> insertItem( locale->translate( "E&xit" ), this, SLOT(exit()) );

    options = new QPopupMenu();
    options -> setCheckable( TRUE );
    id_menubar = options -> insertItem( locale->translate( "Show &Menubar" ),
                           this, SLOT(toggleMenuBar()) );
//leon
    id_showdate = options -> insertItem( locale->translate("Show &Date" ),
                                         this, SLOT(toggleShowDate()) );
    options->setItemChecked( id_showdate, show_date );
//leon

    options -> insertItem( locale->translate( "&Preferences..." ),
                           this, SLOT(preferences()) );
    options -> insertSeparator ( -1 );
    options -> insertItem( locale->translate( "&Save Options" ),
                           this, SLOT(saveOptions()) );

    context = new KPopupMenu( "KWatch" );
    context -> setCheckable( TRUE );
    context -> insertItem( locale->translate( "&Help" ),
                           this, SLOT(help()) );
    context -> insertSeparator ( -1 );
    context -> insertItem( locale->translate( "&Reopen files" ),
                           log, SLOT(reOpen()) );
    context -> insertSeparator ( -1 );
    id_menubar2 = context -> insertItem( locale->translate( "Show &Menubar" ),
                           this, SLOT(toggleMenuBar()) );
    id_showdate2 = context -> insertItem( locale->translate("Show &Date" ),
                                          this, SLOT(toggleShowDate()) );
    context->setItemChecked( id_showdate2, show_date );
    context -> insertItem( locale->translate( "&Preferences..." ),
                           this, SLOT(preferences()) );
    context -> insertSeparator ( -1 );
    context -> insertItem( locale->translate( "&Save Options" ),
                           this, SLOT(saveOptions()) );
    QString about_text =
        "Kwatch, Version " \
        VERSION \
        "\n" \
        "\n" \
        "Copyright (C) 1997,1998 Ralph C. Weichert " \
        "<Ralph.Weichert@physik.tu-darmstadt.de>\n" \
        "\n" \
        "\"Show Date\" option by Leon van Heerden <dj@electro.zsd.co.za>";
    QPopupMenu *help = kapp->getHelpMenu( TRUE, about_text );

    menubar = new KMenuBar( this, "menubar" );
    menubar -> setMenuBarPos( mp );
    menubar -> insertItem( locale->translate( "&File" ), file );
    menubar -> insertItem( locale->translate( "&Options" ), options );
    menubar -> insertSeparator( -1 );
    menubar -> insertItem( locale->translate( "&Help" ), help );

    if (menubar_visible)
        menubar->show();
    else
        menubar->hide();
    options->setItemChecked( id_menubar, menubar_visible  );
    context->setItemChecked( id_menubar2, menubar_visible  );

    connect( menubar,
             SIGNAL(moved(menuPosition)),
             SLOT(menuBarMoved(KMenuBar::menuPosition)) );
    
    log -> setRMBMenu( context );
}

void TopLevel::exit() {
    close();
}

void TopLevel::saveState() {
    saveOptionsTo( kapp->getSessionConfig() );
}

void TopLevel::menuBarMoved( KMenuBar::menuPosition ) {
    resize( width(), height() );
}

void TopLevel::toggleMenuBar() {
    if (menubar_visible) {
        menubar_visible = FALSE;
        menubar -> hide();
    }
    else {
        menubar_visible = TRUE;
        menubar -> show();
    }
    options->setItemChecked( id_menubar, menubar_visible );
    context->setItemChecked( id_menubar2, menubar_visible  );
    resize( width() , height() );
}

//leon
void TopLevel::toggleShowDate() {
    if (show_date) {
        show_date = FALSE;
    }
    else {
        show_date = TRUE;
    }
    log->SetShowDate(show_date);

        options->setItemChecked( id_showdate, show_date);
        context->setItemChecked( id_showdate2, show_date);
        //resize( width() , height() );

}
//leon

void TopLevel::preferences() {
    if (prefs) {
        prefs -> show();
        return;
    }
    KSimpleConfig * cfg = new KSimpleConfig( "/dev/null" );
    log->saveOptionsTo( cfg );
    prefs = new KLogPrefs( cfg, 0, "prefsdlg", FALSE );
    // cfg->rollBack();
    delete cfg;

    connect( prefs, SIGNAL(apply(KConfigBase *)), SLOT(reConfig(KConfigBase *)) );
    prefs -> show();
}

void TopLevel::prefsClosed() {
    if (prefs) delete prefs;
    prefs = 0;
}

void TopLevel::reConfig( KConfigBase * cfg ) {
    log -> reConfig( cfg );
}

void TopLevel::saveOptions() {
    saveOptionsTo( kapp->getConfig() );
}

void TopLevel::saveOptionsTo( KConfigBase * cfg ) {
    cfg -> setGroup( "Window" );
    if (menubar_visible)
        cfg -> writeEntry( "Menubar", "visible" );
    else
        cfg -> writeEntry( "Menubar", "invisible" );
    cfg->writeEntry( "ShowDate", show_date );
    switch (menubar -> menuBarPos()) {
        case KMenuBar::Bottom:
            cfg -> writeEntry( "MenubarPosition", "bottom" );
            break;
        case KMenuBar::Floating:
            cfg -> writeEntry( "MenubarPosition", "floating" );
            break;
        case KMenuBar::Top:
        default:
            cfg -> writeEntry( "MenubarPosition", "top" );
            break;
    }

    cfg->writeEntry( "geometry", KWM::getProperties( winId() ) );
    if ( menubar->menuBarPos() == KMenuBar::Floating )
        cfg->writeEntry( "menubargeometry",
                         KWM::getProperties( menubar->winId() ) );

    log->saveOptionsTo( cfg );

    cfg->sync();
}

void TopLevel::help() {
    kapp -> invokeHTMLHelp( "", "" );
}

void TopLevel::resizeEvent( QResizeEvent * ) {
    int w = width();
    int h = height();
    if (menubar_visible) {
        int d = menubar -> height();
        switch (menubar -> menuBarPos()) {
            case KMenuBar::Floating:
                log -> setGeometry( 0, 0, w, h );
                break;
            case KMenuBar::Bottom:
                menubar -> setGeometry( 0, h - d, w, d );
                log -> setGeometry( 0, 0, w, h - d );
                break;
            case KMenuBar::Top:
            default:
                menubar -> setGeometry( 0, 0, w, d );
                log -> setGeometry( 0, d, w, h - d );
        }
    }
    else
        log -> setGeometry( 0, 0, w, h );
}

int main( int argc, char **argv ) {
    KApplication a( argc, argv, "kwatch" );
    
    TopLevel *w =
        new TopLevel( a.isRestored() ? a.getSessionConfig() : a.getConfig(),
                      NULL, "kwatch" );
    a.setMainWidget( w );
    w->show();
    
    return a.exec();
}

// EOF
