// -*- c++ -*-
//==========================================================
// klogwidget.h
// Part of Kwatch
// (c) 1997 by Ralph C. Weichert

#ifndef KLOGWIDGET_H
#define KLOGWIDGET_H

#include <qmlined.h>
#include <qtimer.h>
#include <qpopmenu.h>
//Leon Van Heerden {Dec 7 1997}
#include <qdatetm.h>
//Leon Van Heerden {Dec 7 1997}

class KLogFile : public QObject {
    Q_OBJECT
    friend class KLogWidget;

public:
    KLogFile( const char * name, QObject * parent = 0 );
    ~KLogFile();
    bool readMore();

signals:
    void moreLines( KLogFile * l, QString text );

private slots:
    void activate();

private:
    QFile * file;
};

/**
 * KLogWidget: watch a group of files
 *
 * KLogWidget keeps track of a group of files which are written to
 * somewhere else (e.g. logfiles).
 *
 * @short Log Widget
 * @author Ralph Weichert <Ralph.Weichert@physik.tu-darmstadt.de>
 */
class KLogWidget : public QMultiLineEdit {
    Q_OBJECT

public:
    KLogWidget( KConfigBase * cfg, QWidget * parent = 0, const char * name = 0 );
    virtual ~KLogWidget();

    void saveOptionsTo( KConfigBase * cfg );

public slots:
    void reOpen();
    void reConfig( KConfigBase * );
    void dropEvent( KDNDDropZone * );
    void moreText( KLogFile *, QString );
    void timeout();
    void SetShowDate( bool d);  //leon

private:
    // Popup for right mouse button
    QPopupMenu *rmbmenu;

    // Files to watch
    QList<KLogFile> * loglist;
    QStrList * logfiles;

    KLogFile * current;
    int r, c;
    bool ShowDate;              //leon

    void setupWindow( KConfigBase * cfg );

protected:
    bool eventFilter ( QObject *, QEvent * );

public:
    void setRMBMenu( QPopupMenu * );

    void addFile( const char * n );
    void delFile( const char * n );
    KLogFile * findName( const char * n );
    QTimer * timer;
};

#endif

// EOF
