// $Id: setup.h,v 1.4 1998/01/14 10:53:58 knoll Exp $
#ifndef SETUP_H
#define SETUP_H

#include <qtabdlg.h>
#include <qwidget.h>
#include <qlabel.h>
#include <qcombo.h>

class Data;
class QGridLayout;
class QButtonGroup;
class QRadioButton;

class Setup : public QTabDialog
{
  Q_OBJECT

public:
  Setup(QWidget* parent=0, const char* name=0);
  ~Setup();

  void readConfig();
  void writeConfig(bool sync);


protected:
  void setupModem(void);
  void setupLocations(void);
  void setupGeneral(void);

private:
  void createDialog();
  int getIndex(const QString *value, const char** list);
QComboBox *addComboRow(QWidget *_parent, QGridLayout *_layout,
		       QString _label, const char *_items[], 
		       QString _current,
		       int _row);

  Data *data;

  QWidget *wProperties;
  QComboBox *cPort;
  QComboBox *cSpeed;  
  QComboBox *cType;
  QString modemType;

  QWidget *wLocations;
  QComboBox *cSpoolDir;
  QComboBox *cVoiceDir;
  QComboBox *cFaxDir;
  QComboBox *cMgettyDir;
  QComboBox *cTmpDir;
  QString spoolDir;
  QString voiceDir;
  QString faxDir;
  QString mgettyDir;
  QString tmpDir;

  QWidget *wGeneral;
  QButtonGroup *soundButtonGrp;
  QRadioButton *buttonSoundCard;
  QRadioButton *buttonHeadSet;

public slots:
  void applySettings();

signals:
};

#endif







