// $Id: setup.cpp,v 1.5 1998/01/14 10:53:58 knoll Exp $
#include "setup.moc"

#include <unistd.h>

#include <qfileinf.h>
#include <qmsgbox.h>
#include <qtstream.h>
#include <qlayout.h>
#include <qbttngrp.h>
#include <qradiobt.h>

#include <ksimpleconfig.h>
#include <kconfig.h>
#include <klocale.h>

#include "global.h"
#include "data.h"

#include "defaults.h"

Setup::Setup(QWidget* parent=0, const char* name=0)
   : QTabDialog(parent, name)
{
  data = Data::getData();
  readConfig();

  setCancelButton();
  createDialog();

  connect(this, SIGNAL(applyButtonPressed()), SLOT(applySettings()) );
}

Setup::~Setup()
{
}

void
Setup::readConfig()
{
  QString str;
  int w,h;

  gcfg->setGroup("location");
  spoolDir = gcfg->readEntry("spoolDir");
  voiceDir = gcfg->readEntry("voiceDir");
  voiceDir = voiceDir.right(voiceDir.size() - voiceDir.findRev("/") - 2);
  faxDir = gcfg->readEntry("faxDir");
  faxDir = faxDir.right(faxDir.size() - faxDir.findRev("/") - 2);
  mgettyDir = gcfg->readEntry("mgettyDir");
  tmpDir = gcfg->readEntry("tmpDir");

  gcfg->setGroup("modem");
  modemType = gcfg->readEntry("type");

  setMinimumSize(200,200);
  cfg->setGroup("geometry");
  str = cfg->readEntry("setup", "350 350");
  sscanf(str.data(), "%d %d", &w, &h);
  resize(w, h);
}

void
Setup::writeConfig(bool sync)
{
  QString aStr,tmpStr;

  cfg->setGroup("voice");
  if(buttonSoundCard->isChecked())
    cfg->writeEntry("device","SoundCard");
  else
    cfg->writeEntry("device","Headset");

  if(sync)
    cfg->sync();

  // privileged part
  if( isSuid && getuid() != 0 )
    return;
  gcfg->setGroup("location");
  gcfg->writeEntry("spoolDir", cSpoolDir->currentText() );
  aStr = cSpoolDir->currentText();
  aStr += "/"; 
  aStr += cVoiceDir->currentText();
  gcfg->writeEntry("voiceDir", aStr);
  //FIXME
  tmpStr = aStr + "/incoming";
  gcfg->writeEntry("voiceIncoming",tmpStr);
  tmpStr = aStr + "/messages";
  gcfg->writeEntry("voiceMessages",tmpStr);
  
  aStr = cSpoolDir->currentText();
  aStr +=  "/";
  aStr += cFaxDir->currentText();
  gcfg->writeEntry("faxDir", aStr );
  // FIXME
  tmpStr = aStr + "/incoming";
  gcfg->writeEntry("faxIncoming",tmpStr);
  tmpStr = aStr + "/outgoing";
  gcfg->writeEntry("faxOutgoing",tmpStr);

  gcfg->writeEntry("mgettyDir", cMgettyDir->currentText() );
  gcfg->writeEntry("tmpDir", cTmpDir->currentText() );

  gcfg->setGroup("modem");
  gcfg->writeEntry("type", cType->currentText() );

  cfg->setGroup("geometry");
  aStr.sprintf("%d %d", width(), height());
  cfg->writeEntry("setup", aStr);

  gcfg->setGroup("kvoice");
  gcfg->writeEntry("configured","yes");

  if (sync)
    gcfg->sync();

}

void 
Setup::applySettings()
{
  writeConfig(true);

  // don't write back if the user doesn't have the permissions
  if(data->readonly()) return;

  //use the changed configuration
  //FIXME: add dirty flags
  data->setPort( cPort->currentText() );
  data->mgettyReplace( "speed", cSpeed->currentText());
  data->voiceReplace( "port_speed", cSpeed->currentText());
#ifdef BROKEN
  data->writeBack();
#endif
}

void Setup::createDialog()
{
  setupGeneral();
  setupModem();
  setupLocations();

  show();
  setMinimumSize(200,200);
}

void Setup::setupModem()
{
  QString aStr;

  wProperties = new QWidget(this, "properties");
  QGridLayout *layout = new QGridLayout(wProperties, 4, 2, 4, 4);
  layout->setColStretch(0,1);
  layout->setColStretch(1,100);
  layout->setRowStretch(3,100);

  if(data->getPort() != 0)
    aStr = data->getPort()->data();
  else
    aStr = "";
  cPort = addComboRow(wProperties, layout, nls("modem device"),
		      Defaults::modemdevice, 
		      aStr,
		      0 );

  if(data->readMgettyEntry("speed") != 0)
    aStr = data->readMgettyEntry("speed")->data();
  else
    aStr = "";
  cSpeed = addComboRow(wProperties, layout, nls("Baud Rate"),
		       Defaults::speed,  
		       aStr,
		       1 );
  cType = addComboRow(wProperties, layout, nls("modem Type"),
		      Defaults::modemtype, modemType,
		      2 );


  addTab(wProperties, nls("modem"));
  if(isSuid && getuid() != 0)
    setTabEnabled("properties",false);
}

void
Setup::setupLocations()
{
  wLocations = new QWidget(this,"locations");
  QGridLayout *layout = new QGridLayout(wLocations, 6, 2, 4, 4);
  layout->setColStretch(0,1);
  layout->setColStretch(1,100);
  layout->setRowStretch(5,100);

  cSpoolDir = addComboRow(wLocations, layout, nls("Spool Directory"),
			  Defaults::spooldir, 
			  spoolDir,
			  0 );
  
  cVoiceDir = addComboRow(wLocations, layout, nls("  Voice Directory"),
			  Defaults::voicespool,
			  voiceDir,
			  1 );

  cFaxDir = addComboRow(wLocations, layout, nls("  Fax Directory"),
			  Defaults::faxspool,
			  faxDir,
			  2 );

  cMgettyDir = addComboRow(wLocations, layout, nls("mgetty Directory"),
			  Defaults::mgettydir,
			  mgettyDir,
			  3 );

  cTmpDir = addComboRow(wLocations, layout, nls("tmp Directory"),
			  Defaults::tmpdir,
			  tmpDir,
			  4 );
  
  addTab(wLocations, nls("Directories"));
  if(isSuid && getuid() != 0)
    setTabEnabled("locations",false);
}

void 
Setup::setupGeneral()
{
  wGeneral = new QWidget(this);
  QBoxLayout *box = new QVBoxLayout(wGeneral, 4);

  soundButtonGrp = new QButtonGroup(nls("Play voice files through:"), 
				    wGeneral);
  box->addWidget(soundButtonGrp);

  QGridLayout *layout = new QGridLayout(soundButtonGrp, 2, 1, 20, 4);
  buttonSoundCard = new QRadioButton(soundButtonGrp);
  buttonSoundCard->setMinimumSize(buttonSoundCard->size());
  buttonSoundCard->setText(nls("Soundcard"));
  layout->addWidget(buttonSoundCard, 0, 0);

  buttonHeadSet = new QRadioButton(soundButtonGrp);
  buttonHeadSet->setMinimumSize(buttonHeadSet->size());
  buttonHeadSet->setText(nls("Headset"));
  layout->addWidget(buttonHeadSet, 1, 0);
  layout->activate();
  soundButtonGrp->adjustSize();
  soundButtonGrp->show();
  cfg->setGroup("voice");
  if(cfg->readEntry("device") == "SoundCard")
    buttonSoundCard->setChecked(true);
  else
    buttonHeadSet->setChecked(true);

  box->addStretch(100);
  box->activate();

  addTab(wGeneral, nls("general"));
  wGeneral->adjustSize();
}

QComboBox *
Setup::addComboRow(QWidget *_parent, QGridLayout *_layout,
		   QString _label, const char *_items[], 
		   QString _current,
		   int _row)
{
  int i=0;

  QLabel *label = new QLabel(_parent);
  label->setText(_label);
  label->adjustSize();
  label->setMinimumSize(label->size());
  _layout->addWidget(label, _row, 0);
  
  QComboBox *combo = new QComboBox(true, _parent);
  combo->insertStrList(_items);
  if(!_current.isEmpty())
    while(1)
    {
      if(_items[i] == _current)
      {
	combo->setCurrentItem(i);
	break;
      }
      if(_items[i] == 0 )
      {
	combo->insertItem( _current , 0);
	break;
      }
      i++;
    }
  
  combo->adjustSize();
  combo->setMinimumSize(combo->size());
  _layout->addWidget(combo, _row, 1);

  _layout->setRowStretch(_row,1);

  return combo;
}

