// $Id: sendfax.h,v 1.3 1998/01/04 13:50:10 knoll Exp $

#ifndef SENDFAX_H
#define SENDFAX_H

#include <ktopwidget.h>
#include <qlist.h>

class QGridLayout;
class QWidget;
class KEdit;
class QLineEdit;
class KProcess;
class QString;
class KDNDDropZone;
class KTabListBox;

class SendFax : public KTopLevelWidget
{
  Q_OBJECT

public:
  SendFax(const char *name = 0);
  virtual ~SendFax();

signals:
  void closed(); 

protected:
  void readConfig();
  void writeConfig(bool sync = false);
  void setupMenuBar();
  void setupToolBar();
  void init();
  void addFile(QString file);

protected slots:
  void slotClose();
  void slotSend();
  void slotAddFile();
  void slotRemoveFile();
  void slotSpooled(KProcess *);
  void slotHelp();
  void slotDropOnEditor();
  void slotDropOnFile();
  void slotOpen();
  void slotInsert();

private:

  QGridLayout *layout;
  QWidget *view;
  KEdit *editor;
  QLineEdit *toEdt;
  QLineEdit *fileEdt;
  KProcess *proc;
  KDNDDropZone *dropZoneEditor;
  KDNDDropZone *dropZoneFile;
  KTabListBox *fileListBox;
  QStrList fileList;
  QString aTmpFile;
};


#endif
