// $Id: sendfax.cpp,v 1.4 1998/01/11 15:53:15 knoll Exp $

#include "sendfax.moc"

#include "global.h"
#include "keditcl.h"

#include <kmenubar.h>
#include <ktoolbar.h>
#include <qpopmenu.h>
#include <kapp.h>
#include <kstdaccel.h>
#include <kiconloader.h>
#include <qstring.h>
#include <qlabel.h>
#include <qlined.h>
#include <qlayout.h>
#include <kprocess.h>
#include <kmsgbox.h>
#include <ksimpleconfig.h>
#include <ktablistbox.h>
#include <qfile.h>

SendFax::SendFax(const char * name)
  : KTopLevelWidget(name)
{
  setupMenuBar();
  setupToolBar();
  init();

  readConfig();
  show();
}

SendFax::~SendFax()
{
  writeConfig();
}

// protected members
void 
SendFax::readConfig()
{
  QString str;
  int w,h;

  cfg->setGroup("geometry");
  str = cfg->readEntry("sendfax", "480 300");
  sscanf(str.data(), "%d %d", &w, &h);
  setMinimumSize(200,200);
  resize(w, h);
}


void
SendFax::writeConfig(bool sync)
{
  QString str;

  cfg->setGroup("geometry");
  str.sprintf("%d %d", width(), height());
  cfg->writeEntry("sendfax", str);

  if (sync) cfg->sync();
}

// private methods

void
SendFax::setupMenuBar()
{
  KMenuBar *menubar = new KMenuBar(this);

  // menu: file
  QPopupMenu *file = new QPopupMenu();
  file->insertItem( nls("Send"), this, SLOT(slotSend()) );
  file->insertItem( nls("&addFile"), this, SLOT(slotAddFile()) );
  file->insertItem( nls("&removeFile") , this, SLOT(slotRemoveFile()) );
  file->insertSeparator();
  file->insertItem( nls("&Close"), this, SLOT(slotClose()), keys->close() );
  menubar->insertItem(nls("&File"),file);

  QPopupMenu *editMenu = new QPopupMenu();
  editMenu->insertItem( nls("&Open"), this, SLOT(slotOpen()), keys->open() );
  editMenu->insertItem( nls("&Insert File"), this, SLOT(slotInsert()) );
  menubar->insertItem(nls("&Edit"), editMenu);

  menubar->insertSeparator();
  QPopupMenu *help = new QPopupMenu();
  help->insertItem( nls("Help"), this, SLOT(slotHelp()) );
  menubar->insertItem(nls("&Help"),help);

  setMenu(menubar);
}

void 
SendFax::setupToolBar()
{
  KIconLoader* loader = kapp->getIconLoader();

  KToolBar *toolbar = new KToolBar(this);

  toolbar->insertButton(loader->loadIcon("send.xpm"),0,
			SIGNAL(clicked()),this,
			SLOT(slotSend()),TRUE,"Send message");
  toolbar->insertSeparator();

  addToolBar(toolbar);
}

void
SendFax::init()
{
  // FIXME: edit widget doesn't word wrap
  bool wordWrap = true;
  int lineBreak = 80;

  view = new QWidget(this);
  setView(view);

  layout = new QGridLayout(view, 3, 2, 4, 4);
  layout->setColStretch(0, 1);
  layout->setColStretch(1, 100);
  layout->setRowStretch(0, 1);
  layout->setRowStretch(1, 100);
  layout->setRowStretch(2, 1);
//  layout->setRowStretch(3, 1);

  // row: To
  toEdt = new QLineEdit(view);
  QLabel *toLbl = new QLabel(view);
  toLbl->setText(nls("&To:"));
  toLbl->adjustSize();
  toLbl->resize((int)toLbl->sizeHint().width(),toLbl->sizeHint().height() + 6);
  toLbl->setMinimumSize(toLbl->size());
  toLbl->show();
  toLbl->setBuddy(toEdt);

  toEdt->show();
  toEdt->setMinimumSize(100, toLbl->height()+2);
  toEdt->setMaximumSize(1000, toLbl->height()+2);
  
  layout->addWidget(toLbl,0,0);
  layout->addWidget(toEdt,0,1);

  // edit widget
  editor = new KEdit(kapp, view);
  editor->toggleModified(FALSE);

  // Word wrapping setup
  if(wordWrap) 
    editor->setWordWrap(TRUE);
  else {
    editor->setWordWrap(FALSE);
    editor->setFillColumnMode(0,FALSE);    
  }
  if(wordWrap && (lineBreak > 0)) 
    editor->setFillColumnMode(lineBreak,TRUE);

  // Font setup

  // FIXME: Color setup
/*  if( mForeColor.isEmpty())
    mForeColor = "black";

  if( mBackColor.isEmpty())
    mBackColor = "white";

  foreColor.setNamedColor(mForeColor);
  backColor.setNamedColor(mBackColor);

  QPalette myPalette = (editor->palette()).copy();
  QColorGroup cgrp  = myPalette.normal();
  QColorGroup ncgrp(foreColor,cgrp.background(),
		    cgrp.light(),cgrp.dark(), cgrp.mid(), foreColor,
		    backColor);
  myPalette.setNormal(ncgrp);
  myPalette.setDisabled(ncgrp);
  myPalette.setActive(ncgrp);

  editor->setPalette(myPalette);
  editor->setBackgroundColor(backColor);
  */
  layout->addMultiCellWidget(editor, 1, 1, 0, 1);

  // row: File
  fileListBox = new KTabListBox(view, 0, 5);
  fileListBox->setColumn(0, nls("F"),16, KTabListBox::PixmapColumn);
  fileListBox->setColumn(1, nls("Name"), 200);
  fileListBox->setColumn(2, nls("Size"), 80);
  fileListBox->setMinimumSize(100, 80);
  fileListBox->show();
  layout->addMultiCellWidget(fileListBox, 2, 2, 0, 1);

  layout->activate();

  dropZoneEditor = new KDNDDropZone(editor, DndURL);
  connect(dropZoneEditor, SIGNAL(dropAction(KDNDDropZone *)), 
	  SLOT(slotDropOnEditor()));

  dropZoneFile = new KDNDDropZone(fileListBox, DndURL);
  connect(dropZoneFile, SIGNAL(dropAction(KDNDDropZone *)), 
	  SLOT(slotDropOnFile()));

}


// slots

void 
SendFax::slotClose()
{
  // FIXME: ask when changes whre made
  writeConfig();
  emit closed();
}

void
SendFax::slotSend()
{
  QString aStr;
  QString phoneNumber, file;
  
  phoneNumber = toEdt->text();
  phoneNumber = phoneNumber.stripWhiteSpace();
  if(phoneNumber.isEmpty())
  {
    KMsgBox::message(0,0,"No fax number specified.",
		     KMsgBox::EXCLAMATION);
    toEdt->setFocus();
    return;
  }

  aStr = editor->text();
  aStr = aStr.stripWhiteSpace();

  if(fileList.isEmpty() && aStr.isEmpty())
  {
    KMsgBox::message(0,0,"Please enter either a message\n"
		     "or a filename to send.",
		     KMsgBox::EXCLAMATION);
    return;
  }

  proc = new KProcess();
  proc->setExecutable("faxspool");
  *proc << phoneNumber;
  
  if(!aStr.isEmpty())
  {
    aTmpFile = gcfg->readEntry("tmpDir") + "/kvoice__send1.txt";
    QFile aFile;
    aFile.setName(aTmpFile);
    if(aFile.exists())
      unlink(aTmpFile);
    editor->doSave(aTmpFile);
    *proc << aTmpFile;
  }

  for (file=fileList.first(); !file.isEmpty() ; file=fileList.next())
  {
    file.replace("file:","");
    *proc << file;
  }

  connect(proc, SIGNAL(processExited(KProcess *)), 
	  this, SLOT(slotSpooled(KProcess *)) );
  proc->start(KProcess::NotifyOnExit);
}

void
SendFax::slotSpooled(KProcess *)
{
  KMsgBox::message(0,0,"Your fax has been put on the queue.",
		   KMsgBox::EXCLAMATION);
  if(!aTmpFile.isEmpty())
  {
    unlink(aTmpFile);
    aTmpFile="";
  }
  delete proc;
  writeConfig();
  emit closed();
}

void 
SendFax::slotAddFile()
{
  QString fileName = QFileDialog::getOpenFileName();
  if ( !fileName.isNull() ) 
    addFile(fileName);
}

void
SendFax::slotRemoveFile()
{
  QString file,aStr;

  int current = fileListBox->currentItem();
  aStr = fileListBox->text(current,1);
  if(current != -1)
  {
    // find the file int the list
    for (file=fileList.first(); !file.isEmpty() ; file=fileList.next())
    {
      if(file.contains(aStr))
	fileList.remove();
    }
    fileListBox->removeItem(current);
  }
}

void
SendFax::slotHelp()
{
  kapp->invokeHTMLHelp("kvoice/faxSending.html",0);
}


void 
SendFax::slotDropOnFile()
{
  QString  file;
  QStrList *urlList;

  urlList = &dropZoneFile->getURLList();

  for (file=urlList->first(); !file.isEmpty() ; file=urlList->next())
  {
    file.replace("file:","");
    addFile(file);
  }
}

void
SendFax::slotDropOnEditor()
{
  QString  file;
  QStrList *urlList;

  urlList = &dropZoneEditor->getURLList();
  if(urlList->count() == 1)
  {
    file = urlList->first();
    file.replace("file:","");
    // FIXME: add some possibility to insert the file
    editor->loadFile(file, KEdit::OPEN_READWRITE);
    editor->toggleModified(true);
    return;
  }
  // else put everything into the filelist.
  for (file=urlList->first(); !file.isEmpty() ; file=urlList->next())
  {
    file.replace("file:","");
    addFile(file);
  }
}

void
SendFax::addFile(QString aUrl)
{
  QString name;
  int i;

  i = aUrl.findRev('/');
  name = (i>=0 ? aUrl.mid(i+1, 256) : aUrl);
  name = " \n" + name;

  fileListBox->insertItem(name);
  fileList.append(aUrl);
}

void
SendFax::slotOpen()
{
  QString fileName = QFileDialog::getOpenFileName();
  if ( !fileName.isNull() ) 
  {
    editor->loadFile(fileName, KEdit::OPEN_READWRITE);
    editor->toggleModified(true);
  }
}

void
SendFax::slotInsert()
{
  QString fileName = QFileDialog::getOpenFileName();
  if ( !fileName.isNull() ) 
  {
    editor->loadFile(fileName, KEdit::OPEN_INSERT);
    editor->toggleModified(true);
  }
}
