// $Id: modem.h,v 1.2 1997/12/14 22:37:56 cvs Exp $
#ifndef HANDLER_H
#define HANDLER_H

#include <sys/file.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <termios.h>
#include <unistd.h>

#include <qstring.h>
#include <qtimer.h>
#include <qapp.h>

#define DLE		16
#define DLE_ETX ""

#define MO_READY 0
#define MO_TIMEOUT 1
#define MO_ERROR 2


class Modem : public QObject
{
  Q_OBJECT

public:
  Modem(QObject *parent=0);
  ~Modem();
  
  int sendAtCommand(char *command, char *wait = "OK");
  char *status();

public slots:
  void waitForAnswer();
  void timeoutSlot();

signals:
  void ready();
  void timeout();

private:
  int outChr(int c);
  int outEsc(int c);
  void sendDLE_ETX(int timeout = 500);
  bool getAnswer(char *wait, int timeout=500);
  int write(char *text, int timeout=500);
  void reset();
  bool lockModem();
  void unlockModem();
  bool openModem();
  void closeModem();

  char *filename;
  char *waitfor;
  char *esc_string;
  bool expecting;
  bool timed_out;
  bool opened;
  bool locked;
  //  bool finished;
  //  int sleeptime;
  int modemfd;
  int out_pos;

  QString retstring;
  QTimer *readtimer;
  QTimer *timeout_timer;

  struct termios tp;
};


#endif
