// $Id: modem.cpp,v 1.2 1997/12/14 22:37:56 cvs Exp $
#include "modem.moc"

#include <assert.h>
#include <errno.h>
#include <unistd.h>

#include <klocale.h>

#include <kmsgbox.h>
#include <qregexp.h>
#include <kapp.h>

#include "global.h"
#include "data.h"
 
Modem::Modem(QObject *parent)
  : QObject(parent)
{
  waitfor = 0;	        /* String to wait		*/
  esc_string = 0;	/* Escape chars to wait		*/
  expecting=false;
  opened = false;
  locked = FALSE;

  readtimer = new QTimer(this);
  connect(readtimer, SIGNAL(timeout()), this, SLOT(waitForAnswer()));

  timeout_timer = new QTimer(this);
  connect(timeout_timer, SIGNAL(timeout()), this, SLOT(timeoutSlot()));
  
  /* Open modem device. */
  lockModem();
  openModem();

  debug("Initialized Modem; status %d",opened);
}

Modem::~Modem()
{
  if(opened)
    closeModem();

  unlockModem();
}

int Modem::sendAtCommand(char* command, char* wait = "OK")
{
  if(!opened) return false;
  write(command); 
  // FIXME: return string must be configurable
  write("\r");

  return getAnswer(wait);
}

/*----------------------------------------------------------------------*/
/* Write c to output file, return TRUE if received waitfor.		*/
/*----------------------------------------------------------------------*/
// FIXME: has to be rewritten
int Modem::outChr(int c)
{
  int out_len=strlen(waitfor);

  if (waitfor == NULL)
    return FALSE;
  else
    {
      if (( char)c == waitfor[out_pos]) out_pos++;
      else out_pos = 0;
      if (out_pos == out_len)
	{
	  return TRUE;
	}
      else
	return FALSE;
    }
}

/*----------------------------------------------------------------------*/
/* Write c to escape file, return TRUE if c is in esc_string.		*/
/*----------------------------------------------------------------------*/
int Modem::outEsc(int c)
{
   int i;

   if (esc_string == 0)
      return FALSE;
   else
      {
      for (i = 0; esc_string[i] != '\0' && esc_string[i] != (char)c; i++);
      if (esc_string[i] == '\0')
         return FALSE;
      else
         {
         return TRUE;
         }
      }
}


void Modem::sendDLE_ETX(int timeout = 500)
{

  ::write(modemfd,DLE_ETX,2);
  getAnswer("VCON",timeout);
}



bool Modem::getAnswer(char *wait, int timeout=500)
{
  retstring="";
  expecting = true;
  timed_out = false;
  waitfor=wait;

  // if we are stuck anywhere we will time out
  timeout_timer->start(timeout); 

  // this timer reads from the modem
  readtimer->start(1);
  
  while(expecting && !timed_out)
      kapp->processEvents();
  if(!expecting) return true;

  debug("Modem::getAnswer timed out");
  debug("returned string is: %s", (const char *) retstring);
  return false;
}

void Modem::waitForAnswer()
{
  char n;

  if(read(modemfd, &n , 1) == 1) 
    {
      retstring += n;
    }

  if(expecting)
    {
      if(retstring.contains(waitfor)){
	expecting = false;
	readtimer->stop();
	timeout_timer->stop();
	debug("got Answer: %s", (const char *) retstring);
	emit ready();
      }
    }
}

void Modem::timeoutSlot()
{
  //  emit timeout();
  timed_out = true;
}

int Modem::write(char *text, int timeout=500)
{
  int i;
  fd_set rfds;
  struct timeval to;

  to.tv_sec=0;
  to.tv_usec=timeout;
  FD_ZERO(&rfds);
  FD_SET(modemfd, &rfds);
  // wait until serial line is ready.
  i = select(modemfd + 1, NULL, &rfds, NULL, &to);

  if(!i) 
    {
      KMsgBox::message(0, nls("error"),nls("modem timeout"),
		       KMsgBox::EXCLAMATION);
      exit(-1);
    }
  i = strlen(text);
  if(::write(modemfd,text,i) != i) 
    {
      KMsgBox::message(0, nls("error"),nls("write error"),
		       KMsgBox::EXCLAMATION);
      exit(-1);
    }
  return 0;
}


char *Modem::status()
{
  if(!opened) return strdup(nls("Could not open modem"));

  bool test = sendAtCommand("AT&F");
  if(test) return strdup(nls("Modem: Ready"));

  return strdup(nls("Modem: Error"));
}


bool Modem::lockModem()
{
  int fd;
  char newlock[255];

  //FIXME: error handling missing
  Data *data = Data::getData();
  if(data->getPort() == 0) return FALSE;

  QString port = data->getPort()->copy();
  port.replace(QRegExp("/dev/"),"");
  if((fd = open("/var/lock/LCK.."+port, 
		O_WRONLY|O_TRUNC|O_CREAT|O_EXCL,0644)) >= 0) {
    sprintf(newlock,"%05d %s %s\n", getpid(), "kvoice", "user" );
    ::write(fd, newlock, strlen(newlock));
    close(fd);
  }
  else
    return FALSE;

  usleep(10000);
  locked = TRUE;

  return TRUE;
}

void Modem::unlockModem()
{
  if(!locked) return;

  Data *data = Data::getData();
  QString port = *data->getPort();
  port.replace(QRegExp("/dev/"),"");
  unlink("/var/lock/LCK.." + port);
}

bool Modem::openModem()
{
  struct termios ts;
  //FIXME: error handling

  Data *data = Data::getData();
  if(!locked) return FALSE;

  filename = strdup(*data->getPort());
  if((modemfd = open(filename, O_RDWR | O_NDELAY)) == -1 ) 
    {
      opened = false;
      return false;
    }
  assert(fcntl(modemfd, F_SETLK) == 0);
  assert( 0 == tcgetattr( modemfd, &tp ) ); // store original setting

  tcgetattr( modemfd, &ts );
  cfsetospeed(&ts, (speed_t)B38400);
  cfsetispeed(&ts, (speed_t)B38400);  

  ts.c_cc[VMIN] = 0; // nonblocking 
  ts.c_cc[VTIME] = 0;
  ts.c_oflag = 0;
  ts.c_lflag = 0;

  ts.c_cflag &= ~(CSIZE | CSTOPB |PARENB | CLOCAL);
  ts.c_cflag |= CREAD | CS8;
  ts.c_cflag |= CRTSCTS; 
  ts.c_iflag  = IGNBRK | IGNPAR | ISTRIP; 
  ts.c_iflag &= ~(IXON|IXOFF|IXANY); 
  ts.c_iflag |= CRTSCTS;
  ts.c_lflag &= ~ICANON;
  ts.c_lflag &= ~(ECHO|ECHOE|ECHOK|ECHOKE);

  tcsetattr(modemfd, TCSANOW, &ts); 

  opened = true;
  return true;
}

void Modem::closeModem()
{
  if(!opened) return;
  assert( 0 == tcsetattr( modemfd, TCSANOW, &tp )); //reset modem
  assert( 0 == fcntl(modemfd, F_UNLCK) );
  assert( 0 == close(modemfd));
}





