// $Id: messages.h,v 1.5 1998/01/14 14:54:37 knoll Exp $

#ifndef MESSAGES_H
#define MESSAGES_H

#include "data.h"

#include <qlabel.h>
#include <qdir.h> 
#include <qpushbt.h>
#include <qdialog.h>
#include <qlined.h>

#include <kstatusbar.h>
#include <ksimpleconfig.h>
#include <kprocess.h>
#include <kapp.h>

#include "messagelist.h"

extern "C" {
#include <mediatool.h>
}
#ifndef _KAUDIO_H_
#define _KAUDIO_H_
#include "kaudio.h"
#endif

class MainWidget;

class Messages : public QWidget
{
  Q_OBJECT

public:
  Messages(QWidget* _parent=0, const char* name=0);
  ~Messages();

  void getAll();
  void getVoice();
  void getFax();
  void playVoice(const char *filename);
  void quit();

protected:
  void resizeEvent(QResizeEvent *);

public slots:
  void slotFaxHighlighted(int index, int);
  void slotVoiceHighlighted(int index, int);
  void slotFaxSelected(int index, int column);
  void slotVoiceSelected(int index, int column);
  void slotPlay();
  void slotShow();
  void slotStop();
  void slotComment();
  void slotPrint();
  void slotDelete();
  void slotFinishedPlaying(KProcess *);
  void slotFinishedPlaying();
  void slotAdjustChanges();

private:

  QString readVoiceComment( const char *vfile );
  void parseFax(QString _fax);

  QLabel     *voiceLabel;
  QLabel     *faxLabel;

  MessageList   *voiceListBox;
  MessageList   *faxListBox;

  QDir faxDir;
  QDir voiceDir;
  QStrList voice;
  QStrList fax;
  KSimpleConfig *voiceIndex; // comments and status of the message
  KSimpleConfig *faxIndex;   // status of the message
  Data *data;
  MainWidget *main;

  bool voicehighlighted;
  int highlighted;
  
  KProcess *proc;
  
  bool isplaying;
  KAudio *audio;
};

class CommEdit : public QDialog
{
 Q_OBJECT
 
private:
 QPushButton	*ok,*cancel,*clear;
 QLineEdit	*ql;
 QLabel		*lab;

public slots:
 void		clearClicked();

public:
 CommEdit( QWidget *parent, const char *name );
 ~CommEdit();

 void		setString( QString a );
 QString	getString();
};

#endif
