// $Id: messages.cpp,v 1.6 1998/01/14 14:54:37 knoll Exp $
#include "messages.moc"
#include "messagelist.h"
#include "mainwidget.h"

#include "global.h"

#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
 
#include <qdir.h>
#include <qstring.h>
#include <qmsgbox.h>
#include <qfileinf.h>
#include <qdatetm.h>
#include <qfont.h>
#include <qdialog.h>
#include <qlined.h>
#include <qregexp.h>

#include <kstatusbar.h>
#include <kapp.h>
#include <kprocess.h>

Messages::Messages(QWidget* _parent, const char* name)
  : QWidget(_parent, name)
{
  main = MainWidget::getMainWidget();
  data = Data::getData();
  audio = data->getAudio();

  isplaying = FALSE;

  QFont listboxfont("lucidatypewriter",14,QFont::DemiBold);

  gcfg->setGroup("location");
  voiceDir = gcfg->readEntry("voiceIncoming");
  voiceDir.setFilter(QDir::Files);
  voiceDir.setSorting(QDir::Time);
  voiceIndex = new KSimpleConfig(gcfg->readEntry("voiceIncoming")
				 + "/.index");
  voiceLabel = new QLabel(nls("received Voice Mails:"),this);
  voiceLabel->setMargin(0);
  voiceLabel->setAutoResize(TRUE);
  voiceListBox = new MessageList(0, this, "voice");
  voiceListBox->setFont(listboxfont);

  gcfg->setGroup("location");
  faxDir = gcfg->readEntry("faxIncoming");
  faxDir.setFilter(QDir::Files);
  faxDir.setSorting(QDir::Time);
  faxIndex = new KSimpleConfig(gcfg->readEntry("faxIncoming")
			       + "/.index");
  faxLabel = new QLabel(nls("received Fax:"),this);
  faxLabel->setMargin(0);
  faxLabel->setAutoResize(TRUE);
  faxListBox = new MessageList(1, this, "fax");
  faxListBox->setFont(listboxfont);

  getAll();

  connect(voiceListBox,SIGNAL(highlighted(int, int)),
	  this,SLOT(slotVoiceHighlighted(int, int)) );
  connect(faxListBox,  SIGNAL(highlighted(int, int)),
	  this,SLOT(slotFaxHighlighted(int, int))   );
  connect(voiceListBox,SIGNAL(selected(int, int)),
	  this,SLOT(slotVoiceSelected(int, int)) );
  connect(faxListBox,  SIGNAL(selected(int, int)),
	  this,SLOT(slotFaxSelected(int, int))   );
//  if(audio->serverStatus() != 0)
//    connect(audio, SIGNAL(playFinished()),
//	    this, SLOT(slotFinishedPlaying()) );

  highlighted = -1;
  resize(200,200); // get around some error messages from qt
}


Messages::~Messages()
{
  // write back index files
  voiceIndex->sync();
  delete voiceIndex;
  faxIndex->sync();
  delete faxIndex;

  delete voiceLabel;
  delete voiceListBox;
  delete faxLabel;
  delete faxListBox;
  delete data;
}

void Messages::quit()
{
  unsigned int i;
  QString flag;
  // mark every new message which wasn't read as unread
  // delete messages marked as deleted
  voiceIndex->setGroup("status");
  if(voiceDir.exists())
  {
    for(i=0;i<voiceDir.count();i++)
    {
      QString message=voiceDir[i];
      flag = voiceIndex->readEntry(message);
      if(flag == 0 || flag == "new")
	voiceIndex->writeEntry(message,"unseen");
      if(flag == "deleted")
      {
	voiceIndex->deleteEntry(message,FALSE);
	voiceIndex->setGroup("comments");
	voiceIndex->deleteEntry(message,FALSE);
	voiceIndex->setGroup("status");
	voiceDir.remove(message);
      }
    }
    voiceIndex->sync();
  }

  gcfg->setGroup("location");
  QString tmpdir = gcfg->readEntry("tmpdir");

  faxIndex->setGroup("status");
  if(faxDir.exists())
  {
    for(i=0;i<faxDir.count();i++)
    {
      QString message=faxDir[i];
      if(message.right(3) == ".01")
      {
	QString aStr;
	
	message.truncate(message.size()-4);
	// remove unused tmpfiles
	aStr.sprintf("rm -f %s/%s*",
		     (const char *)tmpdir,(const char *)message);
	system( aStr );
	
	flag = faxIndex->readEntry(message);
	if(flag == 0 || flag == "new")
	  faxIndex->writeEntry(message,"unseen");
	if(flag == "deleted")
	{
	  int j;
	  faxIndex->deleteEntry(message,FALSE);
	  faxIndex->setGroup("comments");
	  faxIndex->deleteEntry(message,FALSE);
	  faxIndex->setGroup("status");
	  faxIndex->deleteEntry(message,FALSE);
	  faxIndex->setGroup("pages");
	  int pages = faxIndex->readNumEntry(message);
	  faxIndex->deleteEntry(message,FALSE);
	  for(j=1;j<=pages;j++)
	  {
	    if(i<10) 
	      aStr.sprintf("%s/%s.0%d",faxDir.path(),faxDir[i],j); 
	    else
	      aStr.sprintf("%s/%s.%d",faxDir.path(),faxDir[i],j); 
	    faxDir.remove(aStr);
	  }
	}
      }
    }
    faxIndex->sync();
  }

  // drop privileges for writing config files...
  uid_t uid = geteuid();
  seteuid(getuid());
  voiceListBox->writeConfig(TRUE);
  faxListBox->writeConfig(TRUE);
  seteuid(uid);
}


void Messages::resizeEvent(QResizeEvent *)
{
  int w=width();
  int h=height();

  int listheight=(h-60)/2;

  voiceLabel->move(20,10);
  voiceListBox->setFixedSize(w-40,listheight);
  voiceListBox->move(20,30);

  faxLabel->move(20,listheight+30);
  faxListBox->setFixedSize(w-40,listheight);
  faxListBox->move(20,listheight+50);
}


void Messages::getAll()
{
  getVoice();
  getFax();
}

void Messages::getVoice()
{
  unsigned int i;
  QFileInfo info;
  QDate		date;
  QTime		time;
  QString	mydate,comment;
  QString flag;

  voiceListBox->clear();
  voice.clear();

  gcfg->setGroup("location");
  voiceDir = gcfg->readEntry("voiceIncoming");
  if(!voiceDir.exists()) return;

  for(i=0;i<voiceDir.count();i++)
  {
    voiceIndex->setGroup("status");
    QString message=voiceDir[i];
    if( (flag = voiceIndex->readEntry(message))  == 0)
      flag = "new";
    message = voiceDir.path();
    message += "/";
    message += voiceDir[i];

    info.setFile( (const char *)message);
    QDateTime written = info.lastModified();
    date=written.date();
    time=written.time();
    mydate.sprintf("%s %d, %d:%02d",
		   date.monthName(date.month()),date.day(),
		   time.hour(),time.minute());

    int length = info.size()*8/(data->getModemSpeed());

    voiceIndex->setGroup("comments");
    if((comment = voiceIndex->readEntry(voiceDir[i]))  == 0)
      comment = "";

    voice.append(voiceDir[i]);

    message.sprintf("%s\n%s\n%d %s\n%s",(const char *)flag, 
		    (const char *)mydate, 
		    length, (const char *)nls("secs"), 
		    (const char *)comment);
    //debug( "    ----> %s",(const char *) message );
    voiceListBox->insertItem(message);
  }
}


void Messages::getFax()
{
  unsigned int i;
  int pages;
  QFileInfo info;
  QDate		date;
  QTime		time;
  QString	mydate,comment;
  QString flag;

  faxListBox->clear();
  fax.clear();

  gcfg->setGroup("location");
  faxDir = gcfg->readEntry("faxIncoming");
  if(!faxDir.exists()) return;

  for(i=0;i<faxDir.count();i++)
  {
    QString message=faxDir[i];
    if(message.right(3) == ".01")
    {
      message.truncate(message.size()-4);
      fax.append(message);
	  
      faxIndex->setGroup("status");
      if( (flag = faxIndex->readEntry(message))  == 0)
      {
	flag = "new";
	parseFax(message);
      }
      
      faxIndex->setGroup("pages");
      pages = faxIndex->readNumEntry(message);
      faxIndex->setGroup("callerID");
      QString ID = faxIndex->readEntry(message);

      // get the time
      message = faxDir.path();
      message += "/";
      message += faxDir[i];
      info.setFile( (const char *)message);
      QDateTime written = info.lastModified();
      date=written.date();
      time=written.time();
      mydate.sprintf("%s %d, %d:%02d",
		     date.monthName(date.month()),date.day(),
		     time.hour(),time.minute());

      faxIndex->setGroup("comments");
      if((comment = faxIndex->readEntry(faxDir[i]))  == 0)
	comment = "";

      message.sprintf("%s\n%s\n%d %s\n%s",(const char *)flag, 
		      (const char *)mydate,
		      pages,
		      (const char *)nls("page(s)"),
		      (const char *)ID,
		      (const char *)comment);
      faxListBox->insertItem(message);
    }
  }
}

void Messages::parseFax(QString _fax)
{
  //get number of pages
  int pages = 0;
  unsigned int j = 0;
  while(j<faxDir.count())
  {
    if(strncmp(_fax,faxDir[j],9) == 0)
    {	    
      pages++;
    }
    j++;
  }
  faxIndex->setGroup("pages");
  faxIndex->writeEntry(_fax,pages);
  // get callerID
  QString ID ="x";
  int index = _fax.find("-");
  ID += _fax.right(_fax.size()-index-1); 
  ID.replace(QRegExp("_"),"");
  ID.replace(QRegExp("x-*"),"+");
  ID.replace(QRegExp("--"),"-");

  faxIndex->setGroup("callerID");
  faxIndex->writeEntry(_fax,ID);
}


void Messages::slotFaxHighlighted(int index, int)
{
  voicehighlighted=FALSE;
  highlighted=index;

  main->setPlay(FALSE);
  main->setDelete(TRUE);
  main->setPrint(TRUE);
  main->setComment(TRUE);
  main->setShow(TRUE);

  voiceListBox->unmarkAll();
}

void Messages::slotVoiceHighlighted(int index, int)
{
  voicehighlighted=TRUE;
  highlighted=index;

  main->setPlay(TRUE);
  main->setDelete(TRUE);
  main->setComment(TRUE);
  main->setPrint(FALSE);
  main->setShow(FALSE);

  faxListBox->unmarkAll();
}

void Messages::slotFaxSelected(int index, int column)
{
  QString aStr,aStr2,tmpDir;
  int pages, i;

  if(column == 4)
  {
    slotComment();
    return;
  }

  faxIndex->setGroup("pages");
  pages = faxIndex->readNumEntry(fax.at(index));

  gcfg->setGroup("location");
  tmpDir = gcfg->readEntry("tmpDir");

  KProcess proc;
  proc.setExecutable("kfax");

  // tell kfax which pages to show
  for(i=1;i<=pages;i++)
  {
    QString copy;
    if(i<10) 
    {
      aStr.sprintf("%s/%s.0%d",tmpDir.data(),fax.at(index),i); 
      aStr2.sprintf("%s/%s.0%d",faxDir.path(),fax.at(index),i); 
    }
    else
    {
      aStr.sprintf("%s/%s.%d",tmpDir.data(),fax.at(index),i); 
      aStr2.sprintf("%s/%s.%d",faxDir.path(),fax.at(index),i); 
    }
    copy.sprintf("cp %s %s",(const char *)aStr2, (const char *)aStr);
    system( copy );
    chmod(aStr, S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH ); 

    debug("adding page %s",(const char *)aStr);
    proc << aStr;
  }
  // have to start kfax without privileges
  uid_t uid = geteuid();
  seteuid(getuid());
  proc.start(KProcess::DontCare);
  seteuid(uid);

  // mark as seen
  faxIndex->setGroup("status");
  faxIndex->writeEntry(fax.at(index),"old");
  faxListBox->changeItemPart("old",index,0);
}

void Messages::slotVoiceSelected(int index, int column)
{
  debug("selected column %d",column);
  if(column == 3)
  {
    slotComment();
    return;
  }

  QString aStr;

  aStr=voiceDir.path();
  aStr+="/";
  aStr+=voice.at(index);
  
  playVoice((const char *)aStr);

  // mark as old
  voiceIndex->setGroup("status");
  voiceIndex->writeEntry(voice.at(index),"old");
  faxListBox->changeItemPart("old",index,0);

}


void Messages::playVoice(const char *filename)
{
  if(isplaying) return;

  cfg->setGroup("voice");
  QString device = cfg->readEntry("device");
  debug("device =%s\n",(const char *)device);

  if( device == "Headset" || device == 0)
  {
    bool ok = QMessageBox::query( nls("Hear Message"), 
				  nls("Lift up your telphone handset \n" 
				      "to hear the message."), 
				  nls("OK"), nls("Cancel") );
    if ( ok ) {
      proc = new KProcess();
      proc->setExecutable("vm");
      *proc << "play" << "-H" << filename;
      connect(proc, SIGNAL(processExited(KProcess *)),
	      this, SLOT(slotFinishedPlaying(KProcess *)) );
      proc->start(KProcess::NotifyOnExit);
      data->getKStatusBar()->changeItem(nls("Playing"),ID_PLAY);
      isplaying = TRUE;
    }
  } 
  if( device == "SoundCard"  )
  {
    QString tmpfile = "/tmp/__kvoice__convert.wav";
    QString tmpfile2 = "/tmp/__kvoice__convert.pvf";
    KProcess proc;
    data->getKStatusBar()->changeItem(nls("Converting"),ID_PLAY); 
    proc.setExecutable("rmdtopvf");
    proc << filename << (const char *)tmpfile2;
    proc.start(KProcess::Block);
    proc.clearArguments();

    data->getKStatusBar()->changeItem(nls("Converting..."),ID_PLAY);
    proc.setExecutable("pvftowav");
    proc << (const char *) tmpfile2 << (const char *) tmpfile;
    proc.start(KProcess::Block);

    data->getKStatusBar()->changeItem(nls("Playing"),ID_PLAY);
    isplaying = TRUE;
    audio->play(strdup(tmpfile));
  }

  if(isplaying)
  {
    main->setPlay(FALSE);
    main->setStop(TRUE);
  }
}

void Messages::slotFinishedPlaying(KProcess *)
{
  delete proc;
  slotFinishedPlaying();
}

void Messages::slotFinishedPlaying()
{
  data->getKStatusBar()->changeItem(nls("Idle"),ID_PLAY);
  isplaying = FALSE;

  if(voicehighlighted)
  {
    main->setPlay(TRUE);
    main->setStop(FALSE);
  }
}


void Messages::slotPlay()
{
  if (highlighted == -1 || !voicehighlighted) return;
  slotVoiceSelected(highlighted, 0);
}

void Messages::slotShow()
{
  if (highlighted == -1 || voicehighlighted) return;
  slotFaxSelected(highlighted, 0);
}


void Messages::slotStop()
{
  if (!isplaying) return;
  
  cfg->setGroup("voice");
  QString device = cfg->readEntry("device");
  if( device == "Headset" || device == 0)
  {
    debug("killing vm...\n");
    proc->kill(SIGKILL);
  }
  if( device == "SoundCard")
  {
    audio->stop();
  }

  data->getKStatusBar()->changeItem(nls("Idle"),ID_PLAY);
  isplaying = FALSE;

  main->setPlay(TRUE);
  main->setStop(FALSE);
}

void Messages::slotComment()
{
  QString s;

  if(highlighted == -1) return;
  
  
  CommEdit ce(this,"edit");
  voiceIndex->setGroup("comments");
  if (voicehighlighted) {
    s = voiceIndex->readEntry(voice.at(highlighted));
  } else {
    s = faxIndex->readEntry(fax.at(highlighted));
  }
  ce.setString(s.data());
  if (ce.exec()) {
    if (voicehighlighted) {
      voiceIndex->setGroup("comments");
      voiceIndex->writeEntry(voice.at(highlighted),ce.getString());
      voiceListBox->changeItemPart(ce.getString(),highlighted, 3);
    } else {
      faxIndex->setGroup("comments");
      faxIndex->writeEntry(fax.at(highlighted),ce.getString());
      faxListBox->changeItemPart(ce.getString(),highlighted, 4);
    }
  }
}

void Messages::slotPrint()
{
  if(highlighted == -1 || voicehighlighted) return;
  warning("This feature isn't implemented.\n"
    "Please use show, and then print with the help of kfax");
}

void Messages::slotDelete()
{
  if(highlighted == -1) return;
  if(voicehighlighted)
  {
    voiceIndex->setGroup("status");
    if(voiceIndex->readEntry(voice.at(highlighted)) == "deleted")
    {
      voiceIndex->writeEntry(voice.at(highlighted),"old");
      voiceListBox->changeItemPart("old",highlighted, 0);
    } 
    else 
    {
      voiceIndex->writeEntry(voice.at(highlighted),"deleted");
      voiceListBox->changeItemPart("deleted",highlighted, 0);
    }
  } 
  else 
  {
    faxIndex->setGroup("status");
    if(faxIndex->readEntry(fax.at(highlighted)) == "deleted")
    {
      faxIndex->writeEntry(fax.at(highlighted),"old");
      faxListBox->changeItemPart("old",highlighted, 0);
    } 
    else 
    {
      faxIndex->writeEntry(fax.at(highlighted),"deleted");
      faxListBox->changeItemPart("deleted",highlighted, 0);
    }
  }
}

void
Messages::slotAdjustChanges()
{
  gcfg->setGroup("location");
  voiceDir = gcfg->readEntry("voiceIncoming");
  voiceDir.setFilter(QDir::Files);
  voiceDir.setSorting(QDir::Time);
  if(voiceIndex != 0)
    delete voiceIndex;
  voiceIndex = new KSimpleConfig(gcfg->readEntry("voiceIncoming")
				 + "/.index");
  gcfg->setGroup("location");
  faxDir = gcfg->readEntry("faxIncoming");
  faxDir.setFilter(QDir::Files);
  faxDir.setSorting(QDir::Time);
  if(faxIndex != 0)
    delete faxIndex;
  faxIndex = new KSimpleConfig(gcfg->readEntry("faxIncoming")
			       + "/.index");

  getAll();
}

//----------------------------------------

CommEdit::CommEdit( QWidget *parent, const char *name )
  : QDialog( parent, name, TRUE )
{
  ok = new QPushButton(nls("Ok"),this);
  cancel = new QPushButton(nls("Cancel"),this);
  clear = new QPushButton(nls("Clear"),this);
  ql = new QLineEdit(this,nls("Edit"));
  lab = new QLabel(nls("Comment:"),this); 
  
  lab->setGeometry(10,10,60,30);
  ql->setGeometry(70,10,200,30);
  ok->setGeometry(10,50,70,30);
  cancel->setGeometry(85+20,50,70,30);
  clear->setGeometry(160+40,50,70,30);
  
  resize(300,90);
  
  connect( ok, SIGNAL(clicked()), SLOT(accept()) );
  connect( cancel, SIGNAL(clicked()), SLOT(reject()) );
  connect( clear, SIGNAL(clicked()), SLOT(clearClicked()) );
  connect( ql, SIGNAL(returnPressed()), SLOT(accept()) );
}

void CommEdit::clearClicked()
{
  ql->setText("");
}

CommEdit::~CommEdit()
{
}

void CommEdit::setString( QString a )
{
  ql->setText(a.data());
  ql->selectAll();
}

QString CommEdit::getString( )
{
  return( QString(ql->text()) );
}
