// $Id: messagelist.cpp,v 1.3 1998/01/02 01:20:17 knoll Exp $
//
// parts are taken from kmail
#include "messagelist.moc"
#include "global.h"

#include <drag.h>
#include <qstrlist.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kapp.h>

MessageList::MessageList(int cID, 
			 QWidget *parent, const char *_name) :
  KTabListBox(parent, _name, 4+cID)
{
  QString kdir = kapp->kdedir();
  KIconLoader* loader = kapp->getIconLoader();
  static QPixmap pixNew, pixUns, pixDel, pixOld, pixRep;
  name = strdup(_name);
  callerID = cID;

  readConfig();

  setColumn(0, nls("F"), col0, KTabListBox::PixmapColumn);
  setColumn(1, nls("Date"), col1);
  setColumn(2, nls("Length"), col2);
  if(callerID == 1)
  {
    setColumn(3, nls("From"), col3);
    setColumn(4, nls("Comment"), col4);
  }
  else
    setColumn(3, nls("Comment"), col3);

  pixNew = loader->loadIcon("kmmsgnew.xpm");
  pixUns = loader->loadIcon("kmmsgunseen.xpm");
  pixDel = loader->loadIcon("kmmsgdel.xpm");
  pixOld = loader->loadIcon("kmmsgold.xpm");
  pixRep = loader->loadIcon("kmmsgreplied.xpm");

  dict().insert("new", &pixNew);
  dict().insert("unseen", &pixUns);
  dict().insert("deleted", &pixDel);
  dict().insert("old", &pixOld);
  dict().insert("replied", &pixRep);

}

MessageList::~MessageList()
{
  writeConfig(TRUE);
}

void MessageList::readConfig()
{
  QString str;

  cfg->setGroup("geometry");

  str = cfg->readEntry(name + "-listbox", "15 90 70 113 210");
  sscanf(str.data(), "%d %d %d %d %d", &col0, &col1, &col2, &col3, &col4);
}

void MessageList::writeConfig(bool sync)
{
  QString str;

  debug("inWriteConfig()");
  cfg->setGroup("geometry");

  if(callerID ==1)
    str.sprintf("%d %d %d %d %d", cellWidth(0), cellWidth(1),
		cellWidth(2), cellWidth(3), cellWidth(4));
  else
    str.sprintf("%d %d %d %d %d", cellWidth(0), cellWidth(1),
		cellWidth(2), cellWidth(3), 0);
  cfg->writeEntry(name + "-listbox", str);

  if(sync) cfg->sync();
}




