// $Id: mainwidget.h,v 1.4 1998/01/11 15:53:15 knoll Exp $
#ifndef MODEM_H
#define MODEM_H

#include <qpopmenu.h>
#include <qtabdlg.h>
#include <qdir.h>
#include <qlined.h>

#include <kmenubar.h>
#include <ktoolbar.h>
#include <kstatusbar.h>
#include <ktopwidget.h>

#define BUTTON_PLAY 0  
#define BUTTON_STOP 1
#define BUTTON_COMMENT 2
#define BUTTON_SHOW 3
#define BUTTON_PRINT 4
#define BUTTON_DELETE 5

class SendFax;
class Data;
class Messages;
class Setup;
class Greetings;

class MainWidget : public KTopLevelWidget
{
  Q_OBJECT
public:

  MainWidget( const char *name = 0 );
  ~MainWidget();

  void setPlay(bool);
  void setStop(bool);
  void setComment(bool);
  void setPrint(bool);
  void setDelete(bool);
  void setShow(bool);

  static MainWidget *getMainWidget() { return mainObject; }
 
protected: 
  static MainWidget *mainObject;

public slots:
  void kpppSlot();
  void komSlot();
  void setupSlot();
  void setupFinishedSlot();
  void slotGreeting();
  void slotGreetingExited();
  void slotQuit();
  void slotUnimplemented();
  void slotSendFax();
  void slotSendExited();

private:
  void readConfig();
  void writeConfig(bool sync = false);

  void setupMenuBar();
  void setupToolBar();
  void setupStatusBar();
  void setupMessages();
  
  KMenuBar *menubar;
  KToolBar *toolBar;
  KStatusBar *statusbar;
  Messages *messages;

  Greetings *greetings;
  Setup *setupWindow;
  SendFax *sendfax;

  Data *data;
};


#endif
