// $Id: mainwidget.cpp,v 1.9 1998/01/14 14:54:35 knoll Exp $
#include "mainwidget.moc"

#include "global.h"
#include "modem.h"
#include "messages.h"
#include "data.h"
#include "setup.h"
#include "sendfax.h"
#include "greetings.h"

#include <stdio.h>
#include <unistd.h>
#include <string.h>

#include <kapp.h>
#include <kcolordlg.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kstdaccel.h>
#include <kprocess.h>
#include <kmsgbox.h>

#include <qwidget.h>
#include <qpushbt.h>
#include <qfont.h>
#include <qmsgbox.h>
#include <qstring.h>
#include <qtabdlg.h>
#include <qkeycode.h>
#include <qfiledlg.h>
#include <qfile.h>
#include <qstrlist.h>
#include <kapp.h>

#include "global.h"

MainWidget *MainWidget::mainObject = 0L;

MainWidget::MainWidget( const char *name)
  : KTopLevelWidget(name)
{
  data = Data::getData();
  sendfax = 0;
  greetings = 0;

  mainObject = this;
  
  readConfig();

  setupMessages();

  setupMenuBar();
  setupToolBar();
  setupStatusBar();
}

MainWidget::~MainWidget()
{
  writeConfig(true);
  delete data;

  delete menubar;
  delete statusbar;
  delete messages;
}

// private functions
void 
MainWidget::readConfig()
{
  QString str;
  int w,h;

  setMinimumSize(400,300);
  cfg->setGroup("geometry");
  str = cfg->readEntry("main", "550 400");
  sscanf(str.data(), "%d %d", &w, &h);
  resize(w, h);
}

void 
MainWidget::writeConfig(bool sync)
{
  QString str;

  cfg->setGroup("geometry");
  str.sprintf("%d %d", width(), height());
  cfg->writeEntry("main", str);

  if (sync) cfg->sync();
}

void MainWidget::setupMenuBar()
{
  menubar = new KMenuBar(this);

  // menu: file
  QPopupMenu *file = new QPopupMenu();
//  file->insertSeparator();
  file->insertItem( nls("&Quit"), this, SLOT(slotQuit()), keys->quit() );
  menubar->insertItem(nls("&File"), file);

  // menu: voice
  QPopupMenu *voice = new QPopupMenu();
  voice->insertItem( nls("&Greeting message"), this, SLOT(slotGreeting()) );
  voice->insertItem( nls("Play"), messages, SLOT(slotPlay()) );
  voice->insertItem( nls("Stop"), messages, SLOT(slotStop()) );
  menubar->insertItem(nls("Voice"), voice);
  
  // menu: fax
  QPopupMenu *fax = new QPopupMenu();
  fax->insertItem( nls("Show Fax"), messages, SLOT(slotShow()) );
  fax->insertItem( nls("Send Fax"), this, SLOT(slotSendFax()) );
  menubar->insertItem(nls("Fax")    , fax);
  
  // menu: connect
  QPopupMenu *mconnect = new QPopupMenu();
  bool test =false;
  if(QFile::exists(kapp->kdedir() + "/bin/kppp"))
    {
      mconnect->insertItem( nls("&ppp connection"), this, SLOT(kpppSlot()) );
      test = true;
    }
  if(QFile::exists(kapp->kdedir() + "/bin/kom"))
    {
      mconnect->insertItem( nls("&modem terminal"), this, SLOT(komSlot()) );
      test = true;
    }
  if(test) 
    menubar->insertItem(nls("&Connect"), mconnect);

  // menu: options
  QPopupMenu *options = new QPopupMenu();
  options->insertItem( nls("&setup"), this, SLOT(setupSlot()) );
  menubar->insertItem(nls("&Options"), options);

  menubar->insertSeparator(-1);

  // menu: help
  QPopupMenu *help = kapp->getHelpMenu(TRUE, aboutText);
  menubar->insertItem(nls("&Help") , help);

  setMenu(menubar);
  menubar->show();
}

void MainWidget::setupToolBar()
{
  KIconLoader* loader = kapp->getIconLoader();

  toolBar = new KToolBar(this);
  toolBar->insertButton(loader->loadIcon("kvplay.xpm"), BUTTON_PLAY,
			SIGNAL(clicked()), messages,
			SLOT(slotPlay()), TRUE,
			nls("Play message") );
  setPlay(FALSE);

  toolBar->insertButton(loader->loadIcon("kvstop.xpm"), BUTTON_STOP,
			SIGNAL(clicked()), messages,
			SLOT(slotStop()), TRUE,
			nls("Stop playing") );
  setStop(FALSE);

  toolBar->insertButton(loader->loadIcon("kvcomment.xpm"), BUTTON_COMMENT,
			SIGNAL(clicked()), messages,
			SLOT(slotComment()), TRUE,
			nls("Add a comment") );
  setComment(FALSE);

  toolBar->insertSeparator();

  toolBar->insertButton(loader->loadIcon("viewzoom.xpm"), BUTTON_SHOW,
			SIGNAL(clicked()), messages,
			SLOT(slotShow()), TRUE,
			nls("Show Fax") );
  setShow(FALSE);

  toolBar->insertSeparator();

  toolBar->insertButton(loader->loadIcon("fileprint.xpm"), BUTTON_PRINT,
			SIGNAL(clicked()), messages,
			SLOT(slotPrint()), TRUE,
			nls("Print Fax"));
  setPrint(FALSE);

  toolBar->insertButton(loader->loadIcon("filedel2.xpm"), BUTTON_DELETE,
			SIGNAL(clicked()), messages,
			SLOT(slotDelete()), TRUE,
			nls("Delete Message or Fax"));
  setDelete(FALSE);

  addToolBar(toolBar);
}

void MainWidget::setupStatusBar()
{
  statusbar = new KStatusBar( this );
  data->setKStatusBar(statusbar);
  statusbar->setBorderWidth(1);

  statusbar->setInsertOrder( KStatusBar::RightToLeft );
  statusbar->insertItem("                      ",ID_PLAY);
  statusbar->changeItem(nls("Idle"),ID_PLAY);
  
  statusbar->insertItem("Modem:           ", ID_MODEM);
  Modem *modem = new Modem(this);
  statusbar->changeItem(modem->status(), ID_MODEM);
  delete modem;
  
  setStatusBar( statusbar );
  // show statusBar
  enableStatusBar( KStatusBar::Show );
}

void MainWidget::setupMessages()
{

  messages = new Messages(this, "messages");
  setView(messages,TRUE);
  messages->setFocus ();
  messages->show();
}


// SLOTS:

void MainWidget::slotGreeting()
{
  if(greetings != 0) return;
  greetings = new Greetings(nls("Greeting Messages"), messages);
  connect(greetings,SIGNAL(finished()),this,SLOT(slotGreetingExited()) );
  greetings->show();
}

void MainWidget::slotGreetingExited()
{
  delete greetings;
  greetings = 0;
}

// Answering machine

void MainWidget::setPlay(bool stat) { 
  toolBar->setItemEnabled(BUTTON_PLAY,stat); 
}

void MainWidget::setStop(bool stat) { 
  toolBar->setItemEnabled(BUTTON_STOP,stat); 
}

void MainWidget::setComment(bool stat) {
  toolBar->setItemEnabled(BUTTON_COMMENT,stat); 
}

void MainWidget::setDelete(bool stat) { 
  toolBar->setItemEnabled(BUTTON_DELETE,stat); 
}

void MainWidget::setPrint(bool stat) { 
  toolBar->setItemEnabled(BUTTON_PRINT,stat); 
}

void MainWidget::setShow(bool stat) { 
  toolBar->setItemEnabled(BUTTON_SHOW,stat); 
}

// Fax

void MainWidget::slotSendFax()
{
  if(sendfax != 0) return;
  sendfax = new SendFax(nls("Fax Composer"));
  connect(sendfax,SIGNAL(closed()), 
	  this, SLOT(slotSendExited()) );
}

void MainWidget::slotSendExited()
{
  delete sendfax;
  sendfax = 0;
}

// mconnect (terminal or ppp connection)
void MainWidget::kpppSlot()
{
  KProcess proc;
  proc.setExecutable("kppp");
  proc.start(KProcess::DontCare);
}

void MainWidget::komSlot()
{
  KProcess proc;
  proc.setExecutable("kom");
  proc.start(KProcess::DontCare);
}

// options

void MainWidget::setupSlot()
     // creates the setup dialog
{
  setupWindow = new Setup( 0, nls("kvoice configuration") );
  connect(setupWindow,SIGNAL(applyButtonPressed()),
	  this,SLOT(setupFinishedSlot()) );

  setupWindow->show();
}

void MainWidget::setupFinishedSlot()
// deletes the setup dialog, after pressing the ok button.
{
  setupWindow->applySettings();
  delete setupWindow;
  messages->slotAdjustChanges();
}

void MainWidget::slotQuit()
{
  writeConfig();

  messages->quit();

  seteuid(getuid()); //drop privileges for writing!
  cfg->sync();
  data->sync();
  kapp->quit();
}

void MainWidget::slotUnimplemented()
{
  KMsgBox::message(0,0,"Sorry, but this feature is\n"
		   "still unimplemented.",KMsgBox::EXCLAMATION);
}







