// $Id: main.cpp,v 1.6 1998/01/11 15:53:14 knoll Exp $
#include "mainwidget.h"
#include "global.h"
#include "kvconfig.h"
#include "data.h"
#include "defaults.h"

#include <stdio.h>
#include <stdarg.h>      
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <dirent.h>
#include <sys/stat.h>

#include <kapp.h>
#include <klocale.h>
#include <kstdaccel.h>
#include <kapp.h>
#include <kconfig.h>
#include <ksimpleconfig.h>
#include <kmsgbox.h>

// sound support
extern "C" {
#include <mediatool.h>
}
#ifndef _KAUDIO_H_
#define _KAUDIO_H_
#include "kaudio.h"
#endif

KApplication* app = 0;
KLocale* NLS = 0;
KConfig *cfg = 0;
KStdAccel* keys = 0;
KSimpleConfig *gcfg = 0;
bool isSuid = false;

const char *aboutText = 
"kvoice v" VERSION "\n"
"written by Lars Knoll (knoll@mpi-hd.mpg.de)\n"
"This program is covered by the GPL.";

void warning(const char *msg, ...)
{
    va_list ap;
    va_start( ap, msg );                        // use variable arg list
    QString mess;
    mess.sprintf(msg, ap );         
    va_end( ap );
    KMsgBox::message(0,0,mess,KMsgBox::EXCLAMATION);
}       

void setup()
{
  if(getuid() != geteuid())
  // we are running suid, and aren't root
  {
    KMsgBox::message(0,0,nls("kvoice is not configured.\n"
			     "Run kvoice as root to configure it,\n"
			     "or ask your system administrator.")
		     ,KMsgBox::EXCLAMATION);
    exit(1);
  }
  // o.k. lets set things up.
  KVConfig::setup();

}

void testDir( const char *_name )
{
  DIR *dp;
  dp = opendir(_name);
  if (dp == NULL)
    mkdir(_name, S_IRWXU);
  else
    closedir(dp);
}


int main( int argc, char **argv )
{
  // do we have root permissions?
  debug("uid = %d  euid = %d",getuid(), geteuid());
  isSuid = false;
  if(geteuid() == 0)
    isSuid = true;
  // this is needed, because otherwise some directories and files in ~/.kde
  // would be created as root
  uid_t uid=geteuid();
  seteuid(getuid()); // temporarily drop privileges
  app = new KApplication (argc, argv, "kvoice");
  seteuid(uid);

  //FIXME: command line processing

  NLS = app->getLocale();
  cfg = app->getConfig();
  keys = new KStdAccel(cfg);

  // make sure the directory exists
  QString aStr;
  if(isSuid)
    aStr = app->kdedir().copy();
  else
  {
    aStr = getenv("HOME");
    aStr += "/.kde";
  }
  testDir(aStr);
  aStr += "/share";
  testDir(aStr);
  aStr += "/apps";
  testDir(aStr);
  aStr += "/kvoice";
  testDir(aStr);

  aStr += "/config";
  gcfg = new KSimpleConfig(aStr);
  gcfg->setGroup("kvoice");
  if(gcfg->readEntry("configured") != "yes")
    setup();
  else
    debug("configured\n");

  Data *data = new Data();

  KAudio *KAS = new KAudio();
  if (KAS->serverStatus() != 0)
    debug( "Failed contacting audio server\n");
  else
    KAS->setSignals();
  data->setAudio(KAS);

  MainWidget *toplevel = new MainWidget();
  if (app->isRestored())
  { 
    // FIXME: DO SESSION MANGEMENT !!!!!
    if (KTopLevelWidget::canBeRestored(1))
      toplevel->restore(1);
  }

  app->setMainWidget( toplevel );
  toplevel->show();
  return app->exec();
}


