// $Id: kvconfig.cpp,v 1.7 1998/01/14 13:17:21 knoll Exp $
#include "kvconfig.moc"
#include "global.h"
#include "data.h"

#include <qdir.h>

#include <kmsgbox.h>
#include <klocale.h>
#include <kapp.h>
#include <qregexp.h>

#include "defaults.h"

KVConfig::KVConfig(QWidget *parent, const char *name)
  : QObject(parent,name)
{
  QString aStr;
  aStr = kapp->kdedir().copy();
  aStr += "/share/config/kvoicerc";
  config = new KSimpleConfig(aStr);
}

KVConfig::~KVConfig()
{
  gcfg->sync();
  config->sync();
  delete config;

  // update the global cfg object
  cfg->reparseConfiguration();
}

// static methods

int
KVConfig::setup()
{
  KMsgBox::message(0,0,nls("kvoice hasn't been run before.\n"
			   "Please check the configuration\n"
			   "in options->setup.")
		   ,KMsgBox::EXCLAMATION);
  
  KVConfig *conf = new KVConfig();
  conf->success = true;

  conf->findLocations();
  conf->lookForExecutables();
  conf->setupModem();
  if(conf->success)
    conf->configured();
    
  delete conf;
  return 0;
}

// private methods

QString 
KVConfig::findDir(const char *root, const char **list)
{
  int i=0;
  QDir dir;

  while( !(list[i] == 0) )
  {
    QString path = root;
    path = path + '/'; 
    path = path + list[i];
    path.replace("//","/");
    debug("looking for %s...",(const char *)path);
    if(dir.cd(path)) 
    {
      debug("found.");
      return path;
    }
    i++;
  }
  debug("Couldn't find directory in stringlist.");
  success= false;
  return 0;
}

QString 
KVConfig::findDir(const char **roots, const char **list)
{
  int i=0;
  while ( !(roots[i] == 0) )
  {
    QString dir;
    if((dir = findDir(roots[i], list)) != 0)
      return dir;
    i++;
  }
  success = false;
  return 0;
}

QString 
KVConfig::findFile(const char *directory, const char **list)
{
  int i=0;
  QDir dir;
  while( !(list[i] == 0) )
  {
    QString file = directory;
    file = file + '/';
    file = file + list[i];
    file.replace("//","/");
    debug("looking for %s...",(const char *)file);
    if( dir.exists(file) )
    {
      debug("found.");      
      return file;
    }
    i++;
  }
  success= false;
  return 0;
}

QString 
KVConfig::askForDir(const char *message)
{
  //FIXME
  printf("in askForDir. arg=%s\n",message);
  return "";
  success = false;
}

void
KVConfig::findLocations()
{
  QString aStr;
  QString spool = "";
  QString voice,fax;

  gcfg->setGroup("location");

  // find mgetty directory
  aStr = findDir("", Defaults::mgettydir);
  if(aStr == 0)
    aStr = askForDir("could not find the mgetty directory.\n"
		     "(normally /etc/mgetty+sendfax)\n"
		     "Please enter the correct location.");
  gcfg->writeEntry("mgettyDir",aStr);

  // find spool directory.
  spool = findDir("", Defaults::spooldir);
  if(spool == 0)
    spool = askForDir("could not find the spool directory.\n"
		      "Please enter the correct location.");
  gcfg->writeEntry("spoolDir",spool);

  // find voice directory
  voice = findDir(spool, Defaults::voicespool);
  if(voice == 0)
    voice = askForDir("could not find directory, where vgetty\n"
		      "stores the voice files (normally /usr/spool/voice).\n"
		      "Please enter the correct location.");
  gcfg->writeEntry("voiceDir",voice);

  aStr = findDir(voice, Defaults::incoming);
  if(aStr == 0)
    aStr = askForDir("could not find directory, where vgetty\n"
		      "stores incoming messages.\n"
		      "Please enter the correct location.");
  gcfg->writeEntry("voiceIncoming",aStr);

  aStr = findDir(voice, Defaults::messages);
  if(aStr == 0)
    aStr = askForDir("could not find directory, where vgetty\n"
		     "stores the messages.\n"
		     "(normally /usr/spool/voice/messages)\n"
		      "Please enter the correct location.");
  gcfg->writeEntry("voiceMessages",aStr);
  
  // fax spool
  fax = findDir(spool, Defaults::faxspool);
  if(fax == 0)
    fax = askForDir("could not find directory, where vgetty\n"
		     "stores the faxes.\n"
		     "(normally /usr/spool/fax)\n"
		      "Please enter the correct location.");
  gcfg->writeEntry("faxDir",fax);

  aStr = findDir(fax, Defaults::incoming);
  if(aStr == 0)
    aStr = askForDir("could not find directory, where vgetty\n"
		     "stores the incoming faxes.\n"
		     "(normally /usr/spool/fax/incoming)\n"
		      "Please enter the correct location.");
  gcfg->writeEntry("faxIncoming",aStr);

  aStr = findDir(fax, Defaults::outgoing);
  if(aStr == 0)
    aStr = askForDir("could not find directory, where vgetty\n"
		     "stores the outgoing faxes.\n"
		     "(normally /usr/spool/fax/outgoing)\n"
		      "Please enter the correct location.");
  gcfg->writeEntry("faxOutgoing",aStr);

  gcfg->writeEntry("tmpDir","/tmp");
}

void
KVConfig::configured()
{
  gcfg->setGroup("kvoice");
  gcfg->writeEntry("configured","yes");
}

void 
KVConfig::setupModem()
{
  // FIXME
}

void
KVConfig::lookForExecutables()
{
  // FIXME
}
