// $Id: greetings.h,v 1.3 1998/01/11 15:53:13 knoll Exp $
#ifndef GREETING_H
#define GREETING_H

#include <ktopwidget.h>
#include <qpushbt.h>
#include <qlined.h>
#include <qstring.h>
#include <qframe.h>

#include <kprocess.h>


class Data;
class KConfig;
class Messages;
class KVFileDlg;
class KDNDDropZone;
class QDir;
class MessageList;

class Greetings : public KTopLevelWidget
{
  Q_OBJECT

public:
  Greetings(const char *name=0, 
	    Messages *m = 0);
  ~Greetings();
  void readConfig();
  void writeConfig(bool sync = false);

signals:
  void finished();

public slots:
  void slotFinished();
  void slotPlay();
  void slotDelete();
  void slotNew();
  void slotNewFinished();
  void slotImportFile(const char *name);
  void slotRecFromHeadset();
  void slotRecordFinished(KProcess *proc);
  void slotRecordStdout(KProcess *proc, char *buffer, int buflen);
  void slotDrop();
  void slotHelp();

private:
  void setupMenuBar();
  void setupToolBar();
  void init();

  void getGreetings();
  bool makeIndex();
  void initNewDialog();

  MessageList *greetings;
  QDir *greetingDir;
  QLineEdit *entergreeting;
  QString indexfilename;
  QWidget *recorddialog;
  QWidget *view;

  KVFileDlg *filedlg;
  KProcess *proc;
  KDNDDropZone *dropZone;

  Data *data; 
  Messages *messages;
};

#endif

