// $Id: data.h,v 1.2 1997/12/14 22:37:52 cvs Exp $
#ifndef DATA_H
#define DATA_H

#include <qstring.h>
#include <qfile.h>
#include <qdict.h>

#include <kstatusbar.h>

// sound support
extern "C" {
#include <mediatool.h>
}
#ifndef _KAUDIO_H_
#define _KAUDIO_H_
#include "kaudio.h"
#endif

// statusbar definitions
#define ID_MODEM 0
#define ID_PLAY  1
 
class Data 
{

public:
  Data();
  ~Data();
  static Data *getData(){  return dataobject; };

  const QString *readMgettyEntry(const char *key);
  const QString *readVoiceEntry(const char *key);
  void mgettyReplace(const char *key, const char *value);
  void voiceReplace(const char *key, const char *value);

  const QString *getPort();
  bool setPort(const char *port, bool respawn = true);
  int getModemSpeed();
  const char *getModemType();
  const char *getCompression();

  void read();
  void writeBack();

  bool readonly();

  KAudio *getAudio();
  void setAudio(KAudio *kas);

  KStatusBar *getKStatusBar();
  void setKStatusBar(KStatusBar *ks);

  void sync();

protected:
  static Data *dataobject;

  
private:
  void readMgettyConfig();
  void readVoiceConfig();
  void getDefaultValues();
  void readConfigFile(QFile *file, QDict<QString> *dict);
  bool testWritePermission();

  QDict<QString> *mgettyoptions;
  QDict<QString> *voiceoptions;

  bool readonlyflag;

  KAudio *KAS;
  KStatusBar *KSB;

};

#endif
