// $Id: data.cpp,v 1.6 1998/01/19 11:45:37 knoll Exp $
#include "data.h"

#include <kapp.h>
#include <ksimpleconfig.h>

#include <qmsgbox.h>
#include <qfileinf.h>
#include <qfile.h>

#include <unistd.h>
#include <sys/types.h>
#include <assert.h>

#include "global.h"

Data *Data::dataobject = 0L;

Data::Data()
{
  dataobject = this;

  mgettyoptions = new QDict<QString>(71, true, true);
  mgettyoptions->setAutoDelete(true);
  voiceoptions = new QDict<QString>(71, true, true);
  voiceoptions->setAutoDelete(true);

  cfg = KApplication::getKApplication()->getConfig();
  getDefaultValues();
  readonlyflag = !testWritePermission();

  read();
  debug("Initialized Data");
}

Data::~Data()
{
  delete mgettyoptions;
  delete voiceoptions;

}

bool Data::readonly()
{
  return readonlyflag;
}

void Data::read()
{
  readMgettyConfig();
  readVoiceConfig();      
}


void Data::readMgettyConfig()
{
  QString aStr;
  gcfg->setGroup("location");
  aStr = gcfg->readEntry("mgettyDir").copy();
  aStr += "/mgetty.config";

  QFile *file = new QFile(aStr);
  if(!file->exists()) 
    {
      debug(nls("Could not find mgetty config file") );
      return;
    }

  readConfigFile(file, mgettyoptions);

  delete file;
}

void Data::readVoiceConfig()
{
  QString aStr;
  gcfg->setGroup("location");
  aStr = gcfg->readEntry("mgettyDir").copy();
  aStr += "/voice.conf";

  QFile *file = new QFile(aStr);
  if(!file->exists()) 
    {
      debug(nls("Could not find vgetty config file"));
      return;
    }

  readConfigFile(file, voiceoptions);

  delete file;
}

void Data::readConfigFile(QFile *file, QDict<QString> *dict)
{
  QString line; 
  QString key;
  if(!file->open(IO_ReadOnly)) return;
  QTextStream aStream( file );
  aStream.device()->at(0);
 
  while(!aStream.eof())
    {
      line = aStream.readLine();
      if( line.isEmpty() || line.find( '#' ) == 0 )
	continue;
      line = line.simplifyWhiteSpace();

      int pos = line.find(' ');
      if( pos == -1 ) 
	{
	  debug("File %s contains empty key %s",
		file->name(),
		(const char *)line);
	  continue;
	}
      key = line.left( pos );
      QString *value = new QString(line.right( line.length()-pos-1 ));
      debugAll("key=%s value=%s",(const char *)key,
	      (const char *)value->data() );
      if( value->isEmpty() )
	{
	  dict->remove(key);
	} else {
	  dict->replace(key, value);
	}
    }
  file->close();
}




void Data::writeBack()
{
  cfg->sync();   // write back user changes

#ifdef BROKEN
  bool ok = QMessageBox::query("kvoice", 
		     nls("Do you want me to apply the changes\n"
			 "to the mgetty and vgetty config files?"),
			       nls("Yes"), nls("No"));
  if(!ok) return;

  // the m+vgetty configuration should only written back, if the user
  // has the privileges to do so...
  if (readonlyflag) return;

  uid_t uid=geteuid();
  seteuid(getuid()); // temporarily drop privileges

  QString value;
  QDictIterator<QString> mgettyit(*mgettyoptions);

  gcfg->setGroup("location");
  QString filename = gcfg->readEntry("mgettyDir");
  filename += "/mgetty.config";
  QFile file(filename);
  if(!file.open(IO_WriteOnly))
    {
      seteuid(uid); // get back privileges
      debug("got no write permission");
      return;
    }

  while ( mgettyit.current() ) {
    QString buffer;
    value = *mgettyit.current();
    buffer.sprintf("%s %s\n", mgettyit.currentKey(), (const char *)value );
    file.writeBlock( buffer,buffer.length() );
    ++mgettyit;
  }
  file.close();

  QDictIterator<QString> voiceit(*voiceoptions);

  gcfg->setGroup("location");
  filename = gcfg->readEntry("mgettyDir") + "/voice.conf";
  file.setName(filename);
  file.open(IO_WriteOnly);

  while ( voiceit.current() ) {
    QString buffer;
    value = *voiceit.current();
    buffer.sprintf("%s %s\n", voiceit.currentKey(), (const char *)value );
    file.writeBlock( buffer,buffer.length() );
    ++voiceit;
  }
  file.close();

  seteuid(uid); // get back privileges
#endif
}


void Data::mgettyReplace(const char *key, const char *value)
{
  QString *val = new QString(value);
  mgettyoptions->replace(key,val);
}
void Data::voiceReplace(const char *key, const char *value)
{
  QString *val = new QString(value);
  voiceoptions->replace(key,val);
}


void Data::getDefaultValues()
{
  mgettyReplace("speed", "38400");
  mgettyReplace("direct", "no");
  mgettyReplace("blocking", "no");
  mgettyReplace("port-mode", "0664");
  mgettyReplace("toggle-dtr", "yes");
  mgettyReplace("toggle-dtr-waittime", "500");
  mgettyReplace("data-only", "no");
  mgettyReplace("fax-only", "no");
  mgettyReplace("modem-type", "auto");
  mgettyReplace("modem-check-time", "0");
  mgettyReplace("rings", "5");
  mgettyReplace("answer-chat-timeout", "5");
  mgettyReplace("autobauding", "no");
  mgettyReplace("ringback", "no");
  mgettyReplace("ringback-time", "0");
  mgettyReplace("ignore-carrier", "false"); // shouldn't this be no??
  mgettyReplace("prompt-waittime", "0");
  mgettyReplace("login-time", "0");
  mgettyReplace("fido-send-emsi", "yes");
  mgettyReplace("fax-id", "xx xxxx xxxxxx");
  mgettyReplace("diskspace", "1024");
  mgettyReplace("fax-owner", "root");
  mgettyReplace("fax-group", "uucp");
  mgettyReplace("fax-mode", "0640");
  mgettyReplace("term", "vt100");
  mgettyReplace("debug", "4");

  voiceReplace("voice_log_level", "4");
  voiceReplace("voice_dir", "/usr/spool/voice");
  voiceReplace("message_flag_file", ".flag");
  voiceReplace("receive_dir", "incoming");
  voiceReplace("message_dir ", "messages");
  voiceReplace("message_list", "Index");
  voiceReplace("backup_message", "standard.rmd");
  voiceReplace("port_speed", "38400");
  voiceReplace("voice_shell", "/bin/sh");
  voiceReplace("port_timeout", "10");
  voiceReplace("dial_timeout", "90");
  voiceReplace("command_delay", "20");
  voiceReplace("dtmf_len", "30");
  voiceReplace("dtmf_threshold", "40");
  voiceReplace("dtmf_wait", "7");
  voiceReplace("ignore_fax_dle", "false");
  voiceReplace("raw_data", "false");
  voiceReplace("rec_compression", "4");
  voiceReplace("rec_speed", "0");
  voiceReplace("rec_silence_len", "70");
  voiceReplace("rec_silence_threshold", "40");
  voiceReplace("rec_remove_silence", "false");
  voiceReplace("rec_max_len", "300");
  voiceReplace("rec_min_len", "0");
  voiceReplace("do_hard_flow", "true");
  voiceReplace("beep_frequency", "933");
  voiceReplace("beep_length", "150");
  voiceReplace("max_tries", "3");
  voiceReplace("retry_delay", "5");
  voiceReplace("watchdog_timeout", "60");
  voiceReplace("receive_gain", "-1");
  voiceReplace("transmit_gain", "-1");
  voiceReplace("enable_command_echo", "true");
  voiceReplace("rings", "5");
  voiceReplace("answer_mode", "voice:fax");
  voiceReplace("force_autodetect", "false");
  voiceReplace("toll_saver_rings", "0");
  voiceReplace("rec_always_keep", "true");
  voiceReplace("dtmf_program", "dtmf.sh");
  voiceReplace("do_message_light", "false");
  voiceReplace("voice_devices", "ttyS1");
  voiceReplace("dialout_timeout", "90");
}


bool Data::testWritePermission()
{
  bool retval = false;

  gcfg->setGroup("location");
  QFileInfo info(gcfg->readEntry("mgettyDir") + "/mgetty.config");

  if(info.isWritable())
    {
      info.setFile(gcfg->readEntry("mgettyDir") + "/voice.conf");
      if(info.isWritable()) 
	{
	  retval=true;
	  debug("Got write permission.");
	}
    }

  if(!retval) debug("Not root.");

  return retval;
}

const QString *Data::readMgettyEntry(const char *key)
{
  QString *astring = mgettyoptions->find(key);
  if(astring == 0) HERE;
  return astring;
}

const QString *Data::readVoiceEntry(const char *key)
{
  return voiceoptions->find(key);
}

const QString *Data::getPort()
{
  QString line;

  // can this be in other locations???
  QFile inittab("/etc/inittab"); 

  inittab.open(IO_ReadOnly);
  
  QTextStream aStream(&inittab);

  while(!aStream.eof())
    {
      line = aStream.readLine();
      if(line.find("vgetty") != -1 || line.find("mgetty") != -1 )
	if (line.find("#") == -1) // not 100% correct, but not bad... FIXME!
	{
	  // device name should come last...
	  int pos = line.findRev(" ") + 1;
	  QString *port = new QString(line.right(line.length()-pos));
	  if(port->find("/dev/") == -1)
	    port->prepend("/dev/");
	  debugAll("port = %s",(const char *)*port);
	  return port;
	}
    }
  return 0;
}

bool Data::setPort(const char *port, bool respawn=true)
{
#ifdef BROKEN
  bool found=false;

  uid_t uid;
  uid = geteuid();
  seteuid(getuid()); // drop permissions for all write accesses

  QString line;

  // can this be in other locations???
  QFile inittab("/etc/inittab"); 

  if(!inittab.open(IO_ReadWrite)) {
    seteuid(uid);
    return false;
  }

  bool ok = QMessageBox::query(nls("new port"),
			       nls("Shall I write the new port\n"
				   "to /etc/inittab?"),
			       nls("Yes"), nls("No"));
  if(!ok) return false;

  QFile newtab("/tmp/kvoice___.newinittab");
  assert( newtab.open(IO_WriteOnly) );
  
  QTextStream aStream(&inittab);

  while(!aStream.eof())
    {
      line = aStream.readLine();
      if(line.find("vgetty") != -1 || line.find("mgetty") != -1 )
	if (line.find("#") == -1) // not 100% correct, but not bad... FIXME!
	{
	  found = true;
	  // device name should come last...
	  line = "mo:23:";
	  if(respawn) { 
	    line += "respawn:";
	  } else {
	    line += "off:";
	  }
	  line += "/usr/local/sbin/vgetty ";
	  line += (const char *)port;
	}
      newtab.writeBlock( (const char *)line, line.length() );
      newtab.putch('\n');
    }
  if(!found)
    {
      // have to write a new entry...
      line = "mo:23:";
      if(respawn) { 
	line += "respawn:";
      } else {
	line += "off:";
      }
      line += "/usr/local/sbin/vgetty ";
      line += (const char *)port;
      newtab.writeBlock( (const char *)line, line.length() );
      newtab.putch('\n');
    }

  unlink("/etc/inittab");
  rename("/tmp/kvoice___.newinittab","/etc/inittab");

  seteuid(uid);
  return true;

#endif
}  

int Data::getModemSpeed()
{
  return mgettyoptions->find("speed")->toInt();
}

//FIXME
const char *Data::getModemType()
{
  gcfg->setGroup("modem");
  return gcfg->readEntry("type");
}

//FIXME
const char *Data::getCompression() { return "4"; }

KAudio *Data::getAudio() { return KAS; }
void Data::setAudio(KAudio *kas) { KAS = kas; }

KStatusBar *Data::getKStatusBar() { return KSB; }
void Data::setKStatusBar( KStatusBar *ks ) { KSB=ks; };
 
void Data::sync() 
{ 
 // drop privileges
  uid_t uid = geteuid();
  seteuid(getuid());
  cfg->sync(); 
  seteuid(uid);
}
