
#include <qslider.h>
#include <qfiledlg.h>
#include <klocale.h>
#include <kapp.h>
#include <kiconloader.h>
#include "main.h"
#include "main.moc"


KApplication *TestApp;
datenclass *daten;


void MyWidget::about()
{
        QMessageBox aboutmsg;
        aboutmsg.message( "About", 
        "KSamba v0.3\t (c) 1997\n"
        "Lars Kneschke\t Lars.Kneschke@kiel.netsurf.de\n" 
        "Jan Kneschke\t Jan Kneschke@kiel.netsurf.de");
        
}
void MyWidget::help()
{
        TestApp->invokeHTMLHelp("","");
}


void MyWidget::globalsettings()
{
}

void MyWidget::new_smbconf()
{
}

void MyWidget::open_smbconf()
{
        filedialog_widget = new QFileDialog();
        QString name = filedialog_widget->getOpenFileName("/etc","smb.conf");
        if( !name.isNull() ) 
        {
//              printf("datei = %s\n", name->data()); 
                sb->changeItem( name.data() , 0 );
                daten = new datenclass(&name);
                maindialog_widget->set_listbox();
                maindialog_widget->enable_buttons();
		filemenu->setItemEnabled(saveID,true);
		parametermenu->setItemEnabled(newserviceID,true);
		parametermenu->setItemEnabled(copyID,true);
		tb->setItemEnabled(2,true);
		maindialog_widget->info_service(0);

        }
}

void MyWidget::save_smbconf()
{
//	printf("mal ngel mit kpfen machen :-) \n");

	daten->saveSmbconfFile();
}

void MyWidget::quit()
{
        TestApp->quit();
}

MyWidget::MyWidget (int argc, char **argv, QWidget *, const char * name) : KTopLevelWidget (name) 
{
//	printf("lppt\n");
        maindialog_widget = new maindialog(this ,"_page1");
//	maindialog_widget->setGeometry(2,50,320, 330);
	setMinimumSize(350,405);
	setView(maindialog_widget);

        filemenu = new QPopupMenu;
        filemenu->insertItem( klocale->translate("&New File..."), this, SLOT( new_smbconf()) );
        filemenu->insertItem( klocale->translate("&Open File..."), this,  SLOT( open_smbconf()) );
        saveID = filemenu->insertItem( klocale->translate("&Save File"), this,  SLOT( save_smbconf()) );
	filemenu->setItemEnabled(saveID,false);
        filemenu->insertSeparator();
        filemenu->insertItem( klocale->translate("E&xit"), this, SLOT( quit() ) );

        parametermenu = new QPopupMenu;
        newserviceID = parametermenu->insertItem( klocale->translate("&New Service..."), maindialog_widget , SLOT( new_service() ) );
	parametermenu->setItemEnabled(newserviceID,false);
        copyID = parametermenu->insertItem( klocale->translate("&Copy Service..."), maindialog_widget , SLOT( copy_service() ) );
	parametermenu->setItemEnabled(copyID,false);
        QPopupMenu *helpmenu = new QPopupMenu;
        helpmenu->insertItem( klocale->translate("&Help"), this, SLOT( help() ) );
        helpmenu->insertItem( klocale->translate("&About"), this, SLOT( about() ) );
        KMenuBar *menu = new KMenuBar( this );
        menu->insertItem( klocale->translate("&File"), filemenu );
        menu->insertItem( klocale->translate("&Parameter"), parametermenu );
        menu->insertSeparator();
        menu->insertItem( klocale->translate("&Help"), helpmenu );
        setMenu( menu );

	KIconLoader *iconloader = kapp->getIconLoader();
        tb = new KToolBar( this, "toolbar" );

        tb->setFullWidth(TRUE);

        // First three buttons

 	tb->insertButton( iconloader->loadIcon("filenew2.xpm") , 0, SIGNAL( clicked() ), this, SLOT(new_smbconf()),TRUE,klocale->translate("New smb.conf") );

	tb->insertButton( iconloader->loadIcon("fileopen.xpm") , 1, SIGNAL( clicked() ), this, SLOT(open_smbconf()),TRUE,klocale->translate("Open smb.conf") );

	tb->insertButton( iconloader->loadIcon("filefloppy.xpm"), 2, SIGNAL( clicked() ), this, SLOT(save_smbconf()),FALSE,klocale->translate("Save smb.conf") );
//	tb->setItemEnabled(2,false);

        tb->setBarPos( KToolBar::Top );
        enableToolBar( KToolBar::Toggle, addToolBar( tb ));

        
        sb = new KStatusBar( this );

	tmpstring = klocale->translate("This is KSamba 0.3...");
	sb->insertItem( tmpstring.data(), 0 );
	setStatusBar( sb );


//	show();
	setCaption(TestApp->getCaption());
	resize(350,405);        
	show();
	resize(350,405);  
	if (argc > 1)
	{
		if (strcmp(argv[1],"-caption") > 0)
		{
		filename = argv[1];
//		KDEBUG1(KDEBUG_INFO,3700-3800,"Filename = %s",argv[1]);
                sb->changeItem( filename.data() , 0 );
                daten = new datenclass(&filename);
                maindialog_widget->set_listbox();
                maindialog_widget->enable_buttons();
		filemenu->setItemEnabled(saveID,true);
		parametermenu->setItemEnabled(newserviceID,true);
		parametermenu->setItemEnabled(copyID,true);
		tb->setItemEnabled(2,true);
		}
	}

}




int main (int argc, char **argv)

{
        TestApp = new KApplication(argc,argv);

        MyWidget TestWid(argc,argv);
        TestApp->setMainWidget (&TestWid);
        TestWid.show();
        return TestApp->exec();
}


