#include "kgdictlist.h"

KGDictList::KGDictList( KGDictIterator * aIter, bool delIt) {
  if (aIter == NULL) {
    grouppos = -1;
  } else {
    grouppos = 1;
  }
  
  deleteIter = delIt;
  
  iter = aIter;
}

KGDictList::KGDictList( QGDict * aDict) {
  
  if (aDict == NULL) {
    grouppos = -1;
  } else {
    grouppos = 1;
  }
  deleteIter = true;
  
  iter = new KGDictIterator ( *aDict );
}

KGDictList::~KGDictList() {
  if (deleteIter == true)
    delete iter;
}

const char * KGDictList::first() {

  if (iter != NULL) return(NULL);
  
  iter->toFirst();			// move iterator to first item
  grouppos = 1;
  
  if ( (QString)iter->getKey() == "<default>" ) {
    ++(*iter);
    grouppos++;
  }
  if (grouppos > iter->count()) return ( NULL ); // out of range
  
  return( iter->getKey() );
}
const char * KGDictList::current() {
  
  if (grouppos) {
    iter->toFirst();
    (*iter) += grouppos-1;
    return(iter->getKey());
  } else
    return( NULL );
}
const char * KGDictList::next() {
  
  if (grouppos == 0) return( NULL );
  
  grouppos++;			// next item/grouppos
  iter->toFirst();
  (*iter) += grouppos-1;	// move iterator to current item
  
  if ( (QString)iter->getKey() == "<default>" ) {	// skip "<default>"
    ++(*iter);
    grouppos++;
  }
  
  if (grouppos > iter->count()) {
    grouppos = 0;		// out of range
    return ( NULL );
  }
  
  return( iter->getKey() );
}
const char * KGDictList::prev() {
  
  if (grouppos == 0) return( NULL );
  
  iter->toFirst();
  
  if (grouppos > 1)
    (*iter) += grouppos-2;		// move iterator to current item-1
  else {
    grouppos = 0;
    return ( NULL );
  }
  
  grouppos--;
  if ( (QString)iter->getKey() == "<default>" ) {	// skip "<default>"
    iter->toFirst();
    if (grouppos > 1)
      (*iter) += grouppos-2;		// move iterator to current item-1
    else {
      grouppos = 0;
      return ( NULL );
    }
    grouppos--;
  }
  
  return( iter->getKey() );
}
const char * KGDictList::last() {

  grouppos = iter->count();
  
  iter->toFirst();
  
  (*iter) += grouppos-1;
  
  if ( iter->getKey() == "<default>" ) {	// skip "<default>"
    iter->toFirst();
    if (grouppos > 1)
      (*iter) += grouppos-2;		// move iterator to current item-1
    else return( NULL );
    grouppos--;
  }
  
  return( iter->getKey() );
}

