#include "daten2.h"
#include <kdictlist.h>
#include <kapp.h>

void datenclass::newService(QString servicename, int servicetype, QString servicepath)
{
	if (services_list.contains(servicename) == 0)
	{
		services_list.inSort(servicename);
		confdata->setGroup(servicename);
		printf("%d\n",servicetype);
		
		if (servicetype == 0)
		{
			confdata->writeEntry("printable", "no" );
		}
		else
		{
			confdata->writeEntry("printable", "yes" );
		}
		confdata->writeEntry("path", servicepath.data() );
		getServiceData();
	}
}

void datenclass::deleteService(int index)
{
//	confdata->removeGroup( services_list.at(index) );
	services_list.remove(index);
	getServiceData();
}


void datenclass::getServiceData()
{
	if (filesrvlist.isEmpty() == false)
	{
		filesrvlist.clear();
//		printf("Datei wird neu eingelesen\n"); 
	}

	confdata->reparseConfiguration();
	
	for (services_list.first(); services_list.current(); services_list.next() )
	{
//		printf("%s\n",services_list.current());
		service2daten = new QCharDict(DICT_SIZE,false,true);
		confdata->setGroup(services_list.current());
		
		QDictIterator<char> itdef( *servicedefaults );
		while ( itdef.current() ) 
		{
			
			charString = new QString();
//			printf("read \n");
			charString = new QString(confdata->readEntry( itdef.currentKey()));
//			printf("read ok\n");
			if (charString->isNull()) 
			{
				charString = new QString(servicedefaults->find(itdef.currentKey()));
			}
		  	service2daten->insert( itdef.currentKey(), charString->data() );
			if (strcmp(itdef.currentKey(),"printable") == 0)
			{
//			printf("inserted %s -> %s\n",itdef.currentKey(), charString->data());
			}
			++itdef;

		}
		service2daten->insert("service name",  services_list.current());
		filesrvlist.append(service2daten);
//		printf("comment = %s\n",service2daten->find("comment"));
	}
}

QCharDict *datenclass::getServiceDataPointer(int index)
{
	return filesrvlist.at(index);
}

void datenclass::getServices()
{
	if (services_list.isEmpty() == false)
	{
		services_list.clear();
	}
	
	KGroupIterator *iter = confdata->groupIterator();
	KGroupList *confgl = new KGroupList (iter);
	
	for (confgl->first();confgl->current();confgl->next()) 
	{
//		if(strcmp(confgl->current(),"global") != 0)
			services_list.inSort(confgl->current());
	}
	
	delete confgl;
	delete iter;
}


void datenclass::getGlobalData()
{
// Listen initialisieren
	print_list.inSort("BSD");
	print_list.inSort("SYSV");
	print_list.inSort("HPUX");
	print_list.inSort("AIX");
	print_list.inSort("QNX");
	print_list.inSort("PLP");

	if (globaldaten->isEmpty() == false)
	{
//		globaldaten->setAutoDelete(TRUE);
		globaldaten->clear();
//		globaldaten->setAutoDelete(FALSE);
//		printf("reset GlobalData!!\n");
	}

	confdata->reparseConfiguration();
	confdata->setGroup("global");

	QDictIterator<char> itdef( *globaldefaults );
	while ( itdef.current() ) 
	{
		charString = new QString(confdata->readEntry( itdef.currentKey() ));

		if (charString->isNull()) 
		{
			charString = new QString(globaldefaults->find(itdef.currentKey()));
		}
	  	globaldaten->insert( itdef.currentKey(), charString->data() );
//		printf("inserted %s -> %s\n",itdef.currentKey(), charString->data());
		++itdef;
	}

//	printf("deadtime = %s\n",globaldaten->find("deadtime"));

//	QDictIterator<char> it( *globaldaten );
//	while ( it.current() ) 
//	{
//		printf( "%s -> %s\n", it.currentKey(), it.current() );
//		++it;
//	}
}

QCharDict *datenclass::getGlobalDataPointer()
{
	return globaldaten;
}

void datenclass::saveSmbconfFile()
{
//Save global parameters
	confdata->setGroup("global");
	QDictIterator<char> it( *globaldaten );
	while ( it.current() ) 
	{
		if (strcmp(globaldaten->find(it.currentKey()),
			   globaldefaults->find(it.currentKey()) ) == 0)
		{
//		printf( "delete: %s\n", it.currentKey());
		confdata->deleteEntry(it.currentKey(),false);
		}
		else
		{
//		printf( "save: %s -> %s\n", it.currentKey(), it.current() );
		confdata->writeEntry( it.currentKey(), it.current());
		}
		++it;
	}

//Save services
	for (services_list.first(); services_list.current(); services_list.next() )
	{
		if (services_list.current() != "global") 
		{
			confdata->setGroup( services_list.current() );
			service2daten = filesrvlist.at( services_list.at() );
			QDictIterator<char> it( *service2daten );
			while ( it.current() ) 
			{
				if (strcmp(it.currentKey(),"service name" ) == 0)
				{
				}
				else
				{
				if (strcmp(service2daten->find(it.currentKey()),
				   servicedefaults->find(it.currentKey()) ) == 0)
				{
//				printf( "delete: %s in %s\n", it.currentKey(), services_list.current());
				confdata->deleteEntry(it.currentKey(),false);
				}
				else
				{
//				printf( "save: %s -> %s\n", it.currentKey(), it.current() );
				confdata->writeEntry( it.currentKey(), it.current());
				}
				}
				++it;
			}

		}
	}
	
	confdata->sync();
	confdata->reparseConfiguration();
	getGlobalData();
	getServices();
	getServiceData();
}

void datenclass::SetupGlobalDefaults()
{
	globaldefaults->insert("announce as","NT");
	globaldefaults->insert("announce version","4.2");
	globaldefaults->insert("auto services","");
	globaldefaults->insert("bind interfaces only","no");
	globaldefaults->insert("browse list","yes");
	globaldefaults->insert("character set","");
	globaldefaults->insert("client code page","850");
	globaldefaults->insert("config file","");
	globaldefaults->insert("deadtime","0");
	globaldefaults->insert("debuglevel","0");
//	globaldefaults->insert("default","");
	globaldefaults->insert("default service","");
	globaldefaults->insert("dfree command","");
	globaldefaults->insert("dns proxy","yes");
	globaldefaults->insert("domain controller","no");
	globaldefaults->insert("domain logons","no");
	globaldefaults->insert("domain master","no");
	globaldefaults->insert("encrypt passwords","no");
	globaldefaults->insert("getwd cache","no");
	globaldefaults->insert("homedir map","auto.home");
	globaldefaults->insert("hosts equiv","");
	globaldefaults->insert("include","");
	globaldefaults->insert("interfaces","");
	globaldefaults->insert("keep alive","0");
	globaldefaults->insert("lm announce","auto");
	globaldefaults->insert("lm interval","60");
	globaldefaults->insert("load printers","yes");
	globaldefaults->insert("local master","yes");
	globaldefaults->insert("lock directory","/tmp/samba");
	globaldefaults->insert("log file","");
	globaldefaults->insert("log level","");
	globaldefaults->insert("logon drive","");
	globaldefaults->insert("logon home","\\\\%N\\%U");
	globaldefaults->insert("logon path","\\\\%N\\%U\\profile");
	globaldefaults->insert("logon script","");
	globaldefaults->insert("lpq cache time","10");
	globaldefaults->insert("mangled stack","50");
	globaldefaults->insert("max disk size","0");
	globaldefaults->insert("max log size","5000");
	globaldefaults->insert("max mux","50");
	globaldefaults->insert("max packet","");
	globaldefaults->insert("max ttl","14400");
	globaldefaults->insert("max wins ttl","259200");
	globaldefaults->insert("max xmit","65535");
	globaldefaults->insert("message command","");
	globaldefaults->insert("min wins ttl","21600");
	globaldefaults->insert("netbios aliases","");
	globaldefaults->insert("netbios name","");
	globaldefaults->insert("nis homedir","no");
	globaldefaults->insert("null passwords","no");
	globaldefaults->insert("os level","2");
	globaldefaults->insert("packet size","");
	globaldefaults->insert("passwd chat",
	"passwd  chat  =  *old*password* %o\\n *new*password* %n\\n *new*password* %n\\n *changed*");
	globaldefaults->insert("passwd program","/bin/passwd");
	globaldefaults->insert("password level","0");
	globaldefaults->insert("password server","");
	globaldefaults->insert("preferred master","no");
	globaldefaults->insert("preload","");
	globaldefaults->insert("printcap name","/etc/printcap");
	globaldefaults->insert("printer driver file","");
	globaldefaults->insert("protocol","NT1");
	globaldefaults->insert("read bmpx","");
	globaldefaults->insert("read bmpx","");
	globaldefaults->insert("read prediction","no");
	globaldefaults->insert("read raw","yes");
	globaldefaults->insert("read size","2048");
	globaldefaults->insert("remote announce","");
	globaldefaults->insert("remote browse sync","");
	globaldefaults->insert("root","/");
	globaldefaults->insert("root dir","/");
	globaldefaults->insert("root directory","/");
	globaldefaults->insert("security","SHARE");
	globaldefaults->insert("server string","Samba %v");
	globaldefaults->insert("shared file entries","113");
	globaldefaults->insert("shared mem size","102400");
	globaldefaults->insert("smb passwd file","");
	globaldefaults->insert("smbrun","");
	globaldefaults->insert("socket address","");
	globaldefaults->insert("socket options","");
	globaldefaults->insert("status","yes");
	globaldefaults->insert("strip dot","no");
	globaldefaults->insert("syslog","1");
	globaldefaults->insert("syslog only","no");
	globaldefaults->insert("time offset","0");
	globaldefaults->insert("time server","no");
	globaldefaults->insert("unix realname","no");
	globaldefaults->insert("username level","0");
	globaldefaults->insert("username map","");
	globaldefaults->insert("use rhosts","");

	globaldefaults->insert("wins proxy","no");
	globaldefaults->insert("wins server","");
	globaldefaults->insert("wins support","no");
	globaldefaults->insert("workgroup","");
	globaldefaults->insert("write raw","no");
//	globaldefaults->insert("","");
}
void datenclass::SetupServiceDefaults()
{
	servicedefaults->insert("admin users","");
	servicedefaults->insert("allow hosts","");
	servicedefaults->insert("alternate permissions","no");
	servicedefaults->insert("available","yes");
	servicedefaults->insert("browseable","yes");
	servicedefaults->insert("case sensitive","");
	servicedefaults->insert("case sig names","");
	servicedefaults->insert("comment","");
	servicedefaults->insert("copy","");
	servicedefaults->insert("create mask","0744");
	servicedefaults->insert("default case","");
	servicedefaults->insert("delete readonly","no");
	servicedefaults->insert("delete veto files","no");
	servicedefaults->insert("deny hosts","");
	servicedefaults->insert("directory mask","0755");
	servicedefaults->insert("dont descend","");
	servicedefaults->insert("dos filetimes","no");
	servicedefaults->insert("fake oplocks","no");
	servicedefaults->insert("follow symlinks","yes");
	servicedefaults->insert("force create mode","000");
	servicedefaults->insert("force directory mode","000");
	servicedefaults->insert("force group","");
	servicedefaults->insert("force user","");
	servicedefaults->insert("guest account","nobody");
	servicedefaults->insert("guest only","no");
	servicedefaults->insert("hide dot files","yes");
	servicedefaults->insert("hide files","");
	servicedefaults->insert("invalid users","");
	servicedefaults->insert("locking","yes");
	servicedefaults->insert("lppause command","");
	servicedefaults->insert("lpq command","");
	servicedefaults->insert("lpresume command","");
	servicedefaults->insert("lprm command","");
	servicedefaults->insert("magic output","");
	servicedefaults->insert("magic script","");
	servicedefaults->insert("mangle case","");
	servicedefaults->insert("mangled map","");
	servicedefaults->insert("mangled names","yes");
	servicedefaults->insert("mangling char","~");
	servicedefaults->insert("map archive","yes");
	servicedefaults->insert("map hidden","no");
	servicedefaults->insert("map system","no");
	servicedefaults->insert("max connections","0");
	servicedefaults->insert("min print space","0");
	servicedefaults->insert("only user","no");
	servicedefaults->insert("oplocks","yes");

	servicedefaults->insert("postexec","");
	servicedefaults->insert("postscript","no");
	servicedefaults->insert("preexec","");
	servicedefaults->insert("preserve case","no");
	servicedefaults->insert("print command","lpr -r -P %p %s");
	servicedefaults->insert("printable","no");
	servicedefaults->insert("printer name","");
	servicedefaults->insert("printer driver","");
	servicedefaults->insert("printer driver location","");
	servicedefaults->insert("printing","");
	servicedefaults->insert("public","no");
	servicedefaults->insert("read list","");
	servicedefaults->insert("revalidate","no");
	servicedefaults->insert("root postexec","");
	servicedefaults->insert("root preexec","");
	servicedefaults->insert("set directory","no");
	servicedefaults->insert("share modes","yes");
	servicedefaults->insert("short preserve case","no");
	servicedefaults->insert("strict locking","no");
	servicedefaults->insert("sync always","no");
	servicedefaults->insert("username","");
	servicedefaults->insert("valid chars","");
	servicedefaults->insert("valid users","");
	servicedefaults->insert("veto files","");
	servicedefaults->insert("veto oplock files","");
	servicedefaults->insert("volume","");
	servicedefaults->insert("wide links","yes");
	servicedefaults->insert("writeable","no");
	servicedefaults->insert("write list","");
	servicedefaults->insert("path","");
}

QCharDict *datenclass::getGlobalDefaultsPointer()
{
	return globaldefaults;
}

datenclass::datenclass(QString *filename)
{
	globaldefaults = new QCharDict(DICT_SIZE, false, true);
	SetupGlobalDefaults();
	servicedefaults = new QCharDict(DICT_SIZE, false, true);
	SetupServiceDefaults();

	confdata = new KSimpleConfig(filename->data());

	getServices();
	getServiceData();

	globaldaten = new QCharDict(DICT_SIZE, false, true);
//	globaldaten->setAutoDelete(TRUE);
	getGlobalData();

	language = getenv( "LANG" ); 
	kdedir = KApplication::kdedir().data();
}

datenclass::~datenclass()
{
 	delete confdata;
}
