//
//  Fixperms - set and get permissions on lists of files
//  Copyright (C) 1993-1994  Anthony Edward Hall (aehall@seattleu.edu)
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// $Id: getperms.C,v 1.11 1994/01/29 15:49:07 aehall Exp $

static char rcsid[] = "$Id: getperms.C,v 1.11 1994/01/29 15:49:07 aehall Exp $";

#include <stdio.h>
#include <sys/stat.h>  // for file mode defines
#include <string.h>
#include <sys/dir.h>   // for directory stuff
#include <unistd.h>    // for readlink
#include "fixperms.H"
#include "getperms.H"
#include "file.H"

// dummy function to prevent "rcsid not used" warning on compile
void getperms_C_rcsid()
  {
  printf("%s",rcsid);
  };

// get file data
int  getfile(int argc, char *argv[], int options, char *pname, FILE *pptr)
  {
  DIR *dptr=NULL;      // pointer to a directory
  struct dirent *dir;  // directory data
  char *Rargv[1024];   // Recursive ARGuments
  int i, Rargc, k, error=0;
  file fptr;

  for (i=1; i < argc; i++)  // loop through all arguments
    {
    error=fptr.get_file(argv[i], options);
    fptr.output(pptr,&fptr,options);
    fptr.output(stdout,&fptr,options);
    if (O_IS_RECURSIVE(options) && (fptr.ftype == 'd'))
      {
      Rargc=1; // reset for each instance of recursion!
      dptr=opendir(fptr.fname);
      while((dir=readdir(dptr)) !=NULL)
        {
        if (strcmp(dir->d_name,"..") && strcmp(dir->d_name,"."))
          {       // get all files in dir except ".." and "."
          Rargv[Rargc]=new(char[MAX_NAME_LEN]);
          sprintf(Rargv[Rargc],"%s/%s",fptr.fname,dir->d_name);
          Rargc += 1;
          };
        };
      closedir(dptr);
      error=getfile(Rargc,Rargv,options,pname,pptr); // perform recursive call
      for (k=0; k < Rargc; k++)
        {
        delete(Rargv[k]);
        };
      };
    };
  return error;
  };  // end getfile

// get permissions on a list of files
int getperms(int argc, char *argv[], int options)
  {
  FILE *fptr, *pptr;
  char *pname;
  int error=0;

  pname=new(char[MAX_NAME_LEN]);
  sprintf(pname,"%s/%s.%s",PERMS_DIR,argv[0],PERMS_SUFFIX);
  if (((fptr=fopen(pname,"r")) != NULL) && \
      (!O_IS_FORCE(options))) // does package already exist and not FORCE ?
    {
    fprintf(stderr,"\n%s: package already exists\n",argv[0]);
    return 1;
    };
  if ((pptr=fopen(pname,"w+")) == NULL) // open package for writing
    {
    perror(pname);
    return 1;
    };
  if (!O_IS_QUIET(options))
    fprintf(stdout,"\n%s: creating package\n",argv[0]);
  error=getfile(argc,argv,options,pname,pptr);
  fclose(pptr);
  if ((error == 0) && !O_IS_QUIET(options))
    fprintf(stdout,"%s: package created\n",argv[0]);
  else
    fprintf(stderr,"%s: package not created\n",argv[0]);
  delete(pname);
  return error;
  }; // end getperms

// end $Id: getperms.C,v 1.11 1994/01/29 15:49:07 aehall Exp $
