//
//  Fixperms - set and get permissions on lists of files
//  Copyright (C) 1993-1994  Anthony Edward Hall (aehall@seattleu.edu)
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// $Id: fixperms.C,v 1.11 1994/01/29 16:25:25 aehall Exp $

static char rcsid[] = "$Id: fixperms.C,v 1.11 1994/01/29 16:25:25 aehall Exp $";

#include <stdio.h>
#include <sys/stat.h>  // for stat stuff
#include <dirent.h>    // for NAME_MAX and PATH_MAX
#include <string.h>
#include <getopt.h>
#include <posix1_lim.h> // for posix limits
#include "getperms.H"
#include "setperms.H"
#include "fixperms.H"
#include "version.H"

// dummy function to prevent "rcsid not used" warning on compile
void fixperms_C_rcsid()
  {
  printf("%s",rcsid);
  };

void version()  // print out GNU General Public License
  {
  fprintf(stdout,"\n    Copyright (C) 1993-1994  Anthony Edward Hall (aehall@seattleu.edu)\n");
  fprintf(stdout,"    Version: %s  Date: %s\n",VERSION,DATE);
  fprintf(stdout,"\n    This program is free software; you can redistribute it and/or modify\n");
  fprintf(stdout,"    it under the terms of the GNU General Public License as published by\n");
  fprintf(stdout,"    the Free Software Foundation; either version 2 of the License, or\n");
  fprintf(stdout,"    (at your option) any later version.\n");
  fprintf(stdout,"\n    This program is distributed in the hope that it will be useful,\n");
  fprintf(stdout,"    but WITHOUT ANY WARRANTY; without even the implied warranty of\n");
  fprintf(stdout,"    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n");
  fprintf(stdout,"    GNU General Public License for more details.\n");
  fprintf(stdout,"\n    You should have received a copy of the GNU General Public License\n");
  fprintf(stdout,"    along with this program; if not, write to the Free Software\n");
  fprintf(stdout,"    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.\n\n");
  }; // end version

int usage(char *app_name)       // display command line options
  {
  if (strrchr(app_name,'/'))
    strcpy(app_name,(char *)(strrchr(app_name,'/')+1)); // `basename argv[0]`
  fprintf(stderr,"\nUsage: %s [-vcqV] [--verbose] [--check] [--quiet]\n",app_name);            
  fprintf(stderr,"       [--version] package\n");
  fprintf(stderr,"       %s [-vqRfaV] [--verbose] [--quiet] [--recursive]\n",app_name);
  fprintf(stderr,"       [--force] [--absolute] [--version] package file_list\n");
  return 1;
  }; // end usage

int main(int argc, char *argv[]) // main
  {
  int exit=0, options=O_NONE, i, c, args=0;
  char *pname, *list[_POSIX_ARG_MAX];
  struct stat fstats;
  static struct option const long_options[]=
    {
    {"recursive", no_argument, 0, 'R'},
    {"verbose", no_argument, 0, 'v'},
    {"version", no_argument, 0, 'V'},
    {"check", no_argument, 0, 'c'},
    {"quiet", no_argument, 0, 'q'},
    {"force", no_argument, 0, 'f'},
    {"absolute", no_argument, 0, 'a'},
    {0, 0, 0, 0}
    };

  // parse command line options
  while ((c=getopt_long(argc,argv,"RvVcqfa",long_options,(int *)0)) != EOF)
    {
    switch (c)
      {
      case 'R':    // recursive
        options+=O_RECURSIVE;
        break;
      case 'v':   // verbose
        options+=O_VERBOSE;
        break;
      case 'c':   // check only
        options+=O_CHECK_ONLY;
        break;
      case 'q':   // quiet
        options+=O_QUIET;
        break;
      case 'f':   // force
        options+=O_FORCE;
        break;
      case 'a':   // force
        options+=O_ABSOLUTE;
        break;
      case 'V':   // GNU message
        version();
        break;
      default:
        break;
      };
    };

  if (!O_IS_QUIET(options))
    fprintf(stdout,"Fixperms!  v%-27s  Copyright (C) 1993-94  Anthony E Hall\n",VERSION);

  // check for existance of PERMS_DIR directory
  if (stat(PERMS_DIR,&fstats) || !S_ISDIR(fstats.st_mode))
    {
    printf("%s: Directory must exist\n",PERMS_DIR);
    return 1;
    };

  for (i=1; i < argc; i++)   // take out command line options
    {
    if ((argv[i][0] != '-') && (strcmp(argv[i],"-"))) // check for options,
      {                                              // exclude "-" stdin
      list[args]=new(char[MAX_NAME_LEN]);
      strcpy(list[args],argv[i]);
      args += 1;
      };
    };

  switch (args)
    {
    case 0:
      exit=usage(argv[0]);        // no package specified
      break;
    case 1:
      exit=setperms(list[0],options);  // set permissions on package
      break;
    default:
      exit=getperms(args,list,options);
      if (exit == ABNORMAL_EXIT)  // if something fails delete the file
        {
        pname=new(char[MAX_NAME_LEN]);
        sprintf(pname,"%s/%s.%s",PERMS_DIR,list[0],PERMS_SUFFIX);
        remove(pname);
        delete(pname);
        };
      break;
    };
  for (i=0; i < args; i++)
    {
    delete(list[i]);
    };
  return exit;
  }; // end main

// end $Id: fixperms.C,v 1.11 1994/01/29 16:25:25 aehall Exp $
