/*
 * usrmgr - Linux user manager
 * Copyright 1995 by Michael McNeil <kludge@zot.com>
 * Released under the GNU Public License. See COPYING for details.
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/utsname.h>
#include <unistd.h>
#include <pwd.h>

/* X-window stuff */
#include <Xm/BulletinB.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/DialogS.h>
#include <Xm/MessageB.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/Text.h>
#include <Xm/List.h>
#include <Xm/ToggleBG.h>

#include "xuser.xbm"

/* Function defs  <--- start sysmgr.h here */
void swap_mgr( void );
void swap_sys( Widget, XtPointer, XtPointer );
void swap_net( Widget, XtPointer, XtPointer );
void swap_usr( Widget, XtPointer, XtPointer );
void swap_dsk( Widget, XtPointer, XtPointer );
void usrselc_cb( Widget, XtPointer, XtPointer );
void add_user( Widget, XtPointer, XtPointer );
void new_user( Widget, XtPointer, XtPointer );
void rem_user( Widget, XtPointer, XtPointer );
void dis_user( Widget, XtPointer, XtPointer );
void reset_user( Widget, XtPointer, XtPointer );

/* Global Variables and Widgets */
int curr_mgr = 1;
int next_mgr = 0;
/* Global widgets so we can unmanage them from the callbacks */
Widget sysbboard;
Widget netbboard;
Widget usrbboard;
Widget dskbboard;
Widget Ulgname_te;
Widget Ufname_te;
Widget Uhmdir_te;
Widget Ugroup_te;
Widget Uusrid_te;
Widget Ushell_te;
Widget Upasswd_te;
Widget Uscrlist;

/*char mypixmap[] = "xuser.xbm"; */

main( argc, argv )
int argc;
char *argv[];
{

        int i, n, x, y, z;
        char hostbuff[40];
        char domainbuff[40];
        struct utsname uunamebuff;
        struct passwd *pw;
        extern void finish();

        XtAppContext app;
        XmString btn_text;
        Arg args[256];
        Cardinal ac;

	/* things for the image label */
        Widget Xusrmgr_lb;
	Pixel fg, bg;
	unsigned int depth;
	Pixmap pixmap;

        Widget parent;
        Widget toplevel;
        Widget bboard;
        Widget rowcol;

        /* the top push buttons */
        Widget pbExit;

        /* user widgets */
        Widget Urowcol_m;
        Widget Urowcol_1;
        Widget Urowcol_2;
        Widget Urowcol_3;
        Widget Urowcol_4;
        Widget Urowcol_5;
        Widget Urowcol_6;
        Widget Urowcol_7;
        Widget Urowcol_8;

        Widget Ulgname_lb;
        Widget Ufname_lb;
        Widget Uhmdir_lb;
        Widget Ugroup_lb;
        Widget Uusrid_lb;
        Widget Ushell_lb;
        Widget Upasswd_lb;
        Widget pbUnew;
        Widget pbUadd;
        Widget pbUupd;
        Widget pbUdis;
        Widget pbUrem;
        Widget pbUhelp;
        Widget pbUrst;


	/* First of all, make sure we are either root, or super user */
	if(geteuid()!=0)
	{
	printf("xusermgr: You don't have permission to run xusermgr.\n");
	printf("Log in as root or su root to gain super-user priviledges.\n");
	exit(1);
	}

	if(!access("/etc/shadow",R_OK)||!access("/etc/master.passwd",R_OK))
	{
	printf("xusermgr: Sorry, but this version of xusermgr doesn't\n");
	printf("support shadowed passwords.\n");
	exit(1);
	}


        parent = XtVaAppInitialize( &app, "System", NULL, 0,
                &argc, argv, NULL, NULL);

        ac=0;
        XtSetArg( args[ac], XmNx, 150); ac++;
        XtSetArg( args[ac], XmNy, 600); ac++;
        XtSetArg( args[ac], XmNwidth, 500); ac++;
        XtSetArg( args[ac], XmNheight, 320); ac++;
        toplevel = XtCreatePopupShell("User Manager",
                topLevelShellWidgetClass,
                parent, args, ac);

        ac=0;
        XtSetArg( args[ac], XmNresizePolicy, XmRESIZE_GROW ); ac++;
        XtSetArg( args[ac], XmNwidth, 487); ac++;
        XtSetArg( args[ac], XmNheight, 320); ac++;
        XtSetArg( args[ac], XmNshadowType, XmSHADOW_OUT); ac++;
        usrbboard = XmCreateBulletinBoard( toplevel,
                "bboard", args, ac );
        XtManageChild( usrbboard );

        /*  ========= set up the User manager */
        ac=0;
        XtSetArg( args[ac], XmNvisibleItemCount, 17 ); ac++;
        XtSetArg( args[ac], XmNscrollBarDisplayPolicy, XmSTATIC ); ac++;
        XtSetArg( args[ac], XmNy, 10 ); ac++;
        XtSetArg( args[ac], XmNwidth, 100 ); ac++;
        Uscrlist = XmCreateScrolledList( usrbboard, "Users", args, ac );
        XtAddCallback( Uscrlist, XmNdefaultActionCallback, usrselc_cb, NULL );
        XtAddCallback( Uscrlist, XmNbrowseSelectionCallback, usrselc_cb, NULL );
        XtManageChild( Uscrlist );

        setpwent();
        while( pw=getpwent()){
                char *crypt();
                char *result;
                XmString str;

        str = XmStringCreateLocalized( pw->pw_name );

        XmListAddItem( Uscrlist, str, 0 );
                if( pw->pw_passwd[0]==0){
                /* set the red background color here */
                }

                result = crypt(pw->pw_name,pw->pw_passwd);
                if( !strcmp(result, pw->pw_passwd)) {
                        /* set the yellow background color here */
                }
        XmStringFree( str );
        }
        endpwent();

        ac = 0;
        XtSetArg( args[ac], XmNx, 120 ); ac++;
        Urowcol_m = XmCreateRowColumn( usrbboard, "Urowcol_m", args, ac );
        XtManageChild( Urowcol_m );

        Urowcol_1 = XtVaCreateManagedWidget("Urowcol_1",
                xmRowColumnWidgetClass, Urowcol_m,
                XmNorientation, XmHORIZONTAL,
                NULL );
        Urowcol_2 = XtVaCreateManagedWidget("Urowcol_2",
                xmRowColumnWidgetClass, Urowcol_m,
                XmNorientation, XmHORIZONTAL,
                NULL );
        Urowcol_3 = XtVaCreateManagedWidget("Urowcol_3",
                xmRowColumnWidgetClass, Urowcol_m,
                XmNorientation, XmHORIZONTAL,
                NULL );
        Urowcol_4 = XtVaCreateManagedWidget("Urowcol_4",
                xmRowColumnWidgetClass, Urowcol_m,
                XmNorientation, XmHORIZONTAL,
                NULL );
        Urowcol_5 = XtVaCreateManagedWidget("Urowcol_5",
                xmRowColumnWidgetClass, Urowcol_m,
                XmNorientation, XmHORIZONTAL,
                NULL );
        Urowcol_6 = XtVaCreateManagedWidget("Urowcol_6",
                xmRowColumnWidgetClass, Urowcol_m,
                XmNorientation, XmHORIZONTAL,
                NULL );
        Urowcol_7 = XtVaCreateManagedWidget("Urowcol_7",
                xmRowColumnWidgetClass, Urowcol_m,
                XmNorientation, XmHORIZONTAL,
                NULL );

        btn_text = XmStringCreateLocalized("    Login Name");
        Ulgname_lb = XtVaCreateManagedWidget("Ulgname_lb",
                xmLabelWidgetClass, Urowcol_1,
                XmNlabelString, btn_text,
                XmNalignment, XmALIGNMENT_END,
                NULL );
        XtManageChild( Ulgname_lb );
        XmStringFree( btn_text );

        Ulgname_te = XtVaCreateManagedWidget("Ulgname_te",
                xmTextWidgetClass, Urowcol_1,
                XmNalignment, XmALIGNMENT_BEGINNING,
                NULL );

        btn_text = XmStringCreateLocalized("     Full Name");
        Ufname_lb = XtVaCreateManagedWidget("Ufname_lb",
                xmLabelWidgetClass, Urowcol_2,
                XmNlabelString, btn_text,
                XmNalignment, XmALIGNMENT_END,
                NULL );
        XtManageChild( Ufname_lb );
        XmStringFree( btn_text );

        Ufname_te = XtVaCreateManagedWidget("Ufname_te",
                xmTextWidgetClass, Urowcol_2,
                XmNalignment, XmALIGNMENT_BEGINNING,
                NULL );

        btn_text = XmStringCreateLocalized("         Group");
        Ugroup_lb = XtVaCreateManagedWidget("Ugroup_lb",
                xmLabelWidgetClass, Urowcol_3,
                XmNlabelString, btn_text,
                XmNalignment, XmALIGNMENT_END,
                NULL );
        XtManageChild( Ugroup_lb );
        XmStringFree( btn_text );

        Ugroup_te = XtVaCreateManagedWidget("Ugroup_te",
                xmTextWidgetClass, Urowcol_3,
                XmNalignment, XmALIGNMENT_BEGINNING,
                NULL );

        btn_text = XmStringCreateLocalized("       User Id");
        Uusrid_lb = XtVaCreateManagedWidget("Uusrid_lb",
                xmLabelWidgetClass, Urowcol_4,
                XmNlabelString, btn_text,
                XmNalignment, XmALIGNMENT_END,
                NULL );
        XtManageChild( Uusrid_lb );
        XmStringFree( btn_text );

        Uusrid_te = XtVaCreateManagedWidget("Uusrid_te",
                xmTextWidgetClass, Urowcol_4,
                XmNalignment, XmALIGNMENT_BEGINNING,
                NULL );

        btn_text = XmStringCreateLocalized("Home Directory");
        Uhmdir_lb = XtVaCreateManagedWidget("Uhmdir_lb",
                xmLabelWidgetClass, Urowcol_5,
                XmNlabelString, btn_text,
                XmNalignment, XmALIGNMENT_END,
                NULL );
        XtManageChild( Uhmdir_lb );
        XmStringFree( btn_text );

        Uhmdir_te = XtVaCreateManagedWidget("Uhmdir_te",
                xmTextWidgetClass, Urowcol_5,
                XmNalignment, XmALIGNMENT_BEGINNING,
                NULL );

        btn_text = XmStringCreateLocalized("         Shell");
        Ushell_lb = XtVaCreateManagedWidget("Ushell_lb",
                xmLabelWidgetClass, Urowcol_6,
                XmNlabelString, btn_text,
                XmNalignment, XmALIGNMENT_END,
                NULL );
        XtManageChild( Ushell_lb );
        XmStringFree( btn_text );

        Ushell_te = XtVaCreateManagedWidget("Ushell_te",
                xmTextWidgetClass, Urowcol_6,
                XmNalignment, XmALIGNMENT_BEGINNING,
                NULL );

        btn_text = XmStringCreateLocalized("      Password");
        Upasswd_lb = XtVaCreateManagedWidget("Upasswd_lb",
                xmLabelWidgetClass, Urowcol_7,
                XmNlabelString, btn_text,
                XmNalignment, XmALIGNMENT_END,
                NULL );
        XtManageChild( Upasswd_lb );
        XmStringFree( btn_text );

        Upasswd_te = XtVaCreateManagedWidget("Upasswd_te",
                xmTextWidgetClass, Urowcol_7,
                XmNalignment, XmALIGNMENT_BEGINNING,
                NULL );

        /* Push button row coloumn */
        Urowcol_8 = XtVaCreateManagedWidget("Urowcol_8",
                xmRowColumnWidgetClass, usrbboard,
                XmNorientation, XmVERTICAL,
                XmNspacing, 5,
                XmNalignment, XmALIGNMENT_CENTER,
                XmNx, 400,
                XmNy, 105,
                NULL );

        /* pushbuttons for action */
        btn_text = XmStringCreateLocalized("    New");
        ac=0;
        XtSetArg( args[ac], XmNalignment, XmALIGNMENT_CENTER ); ac++;
        XtSetArg( args[ac], XmNlabelString, btn_text ); ac++;
        XtSetArg( args[ac], XmNwidth, 100 ); ac++;
        XtSetArg( args[ac], XmNtraversalOn, False ); ac++;
        XtSetArg( args[ac], XmNheight, 40 ); ac++;
        pbUnew = XmCreatePushButton( Urowcol_8,
                "pbUnew", args, ac);
        XmStringFree( btn_text );
        XtManageChild( pbUnew );
        XtAddCallback( pbUnew, XmNactivateCallback, new_user, NULL );

        btn_text = XmStringCreateLocalized("Add - Update");
        ac=0;
        XtSetArg( args[ac], XmNalignment, XmALIGNMENT_CENTER ); ac++;
        XtSetArg( args[ac], XmNlabelString, btn_text ); ac++;
        XtSetArg( args[ac], XmNwidth, 100 ); ac++;
        XtSetArg( args[ac], XmNtraversalOn, False ); ac++;
        XtSetArg( args[ac], XmNheight, 40 ); ac++;
        pbUadd = XmCreatePushButton( Urowcol_8,
                "pbUadd", args, ac);
        XmStringFree( btn_text );
        XtManageChild( pbUadd );
        XtAddCallback( pbUadd, XmNactivateCallback, add_user, NULL );

        btn_text = XmStringCreateLocalized("  Disable");
        ac=0;
        XtSetArg( args[ac], XmNalignment, XmALIGNMENT_CENTER ); ac++;
        XtSetArg( args[ac], XmNlabelString, btn_text ); ac++;
        XtSetArg( args[ac], XmNtraversalOn, False ); ac++;
        XtSetArg( args[ac], XmNwidth, 100 ); ac++;
        XtSetArg( args[ac], XmNheight, 40 ); ac++;
        pbUdis = XmCreatePushButton( Urowcol_8,
                "pbUdis", args, ac);
        XmStringFree( btn_text );
        XtManageChild( pbUdis );
        XtAddCallback( pbUdis, XmNactivateCallback, dis_user, NULL );

        btn_text = XmStringCreateLocalized("   Remove");
        ac=0;
        XtSetArg( args[ac], XmNalignment, XmALIGNMENT_CENTER ); ac++;
        XtSetArg( args[ac], XmNtraversalOn, False ); ac++;
        XtSetArg( args[ac], XmNlabelString, btn_text ); ac++;
        XtSetArg( args[ac], XmNwidth, 100 ); ac++;
        XtSetArg( args[ac], XmNheight, 40 ); ac++;
        pbUrem = XmCreatePushButton( Urowcol_8,
                "pbUrem", args, ac);
        XmStringFree( btn_text );
        XtManageChild( pbUrem );
        XtAddCallback( pbUrem, XmNactivateCallback, rem_user, NULL );

        btn_text = XmStringCreateLocalized("   Clear");
        ac=0;
        XtSetArg( args[ac], XmNalignment, XmALIGNMENT_CENTER ); ac++;
        XtSetArg( args[ac], XmNlabelString, btn_text ); ac++;
        XtSetArg( args[ac], XmNtraversalOn, False ); ac++;
        XtSetArg( args[ac], XmNwidth, 100 ); ac++;
        XtSetArg( args[ac], XmNheight, 40 ); ac++;
        pbUrst = XmCreatePushButton( Urowcol_8,
                "pbUrem", args, ac);
        XmStringFree( btn_text );
        XtManageChild( pbUrst );
        XtAddCallback( pbUrst, XmNactivateCallback, reset_user, NULL );

/*
        btn_text = XmStringCreateLocalized("    Help");
        ac=0;
        XtSetArg( args[ac], XmNalignment, XmALIGNMENT_CENTER ); ac++;
        XtSetArg( args[ac], XmNlabelString, btn_text ); ac++;
        XtSetArg( args[ac], XmNwidth, 100 ); ac++;
        XtSetArg( args[ac], XmNheight, 40 ); ac++;
        pbUhelp = XmCreatePushButton( Urowcol_8,
                "pbUhelp", args, ac);
        XmStringFree( btn_text );
        XtManageChild( pbUhelp );
        XtAddCallback( pbUhelp, XmNactivateCallback, reset_user, NULL );
*/

        btn_text = XmStringCreateLocalized("    Exit");
        ac=0;
        XtSetArg( args[ac], XmNalignment, XmALIGNMENT_CENTER ); ac++;
        XtSetArg( args[ac], XmNlabelString, btn_text ); ac++;
        XtSetArg( args[ac], XmNwidth, 100 ); ac++;
        XtSetArg( args[ac], XmNtraversalOn, False ); ac++;
        XtSetArg( args[ac], XmNheight, 40 ); ac++;
        pbExit = XmCreatePushButton( Urowcol_8, "pbExit", args, ac);
        XmStringFree( btn_text );
        XtManageChild( pbExit );
        XtAddCallback( pbExit, XmNactivateCallback, finish, NULL );

	XtVaGetValues( usrbboard,
			XmNforeground, &fg,
			XmNbackground, &bg,
			XmNdepth, &depth,
			NULL );

	pixmap = XCreatePixmapFromBitmapData( XtDisplay(usrbboard),
			RootWindowOfScreen(XtScreen(usrbboard)),
			xuser_bits, xuser_width, xuser_height,
			fg, bg, depth );

	if( pixmap == XmUNSPECIFIED_PIXMAP )
		fprintf( stderr, "Couldn't load debug.xbm\n");
	else
	{

        Xusrmgr_lb = XtVaCreateManagedWidget("Xusrmgr_lb",
                xmLabelGadgetClass, usrbboard,
                XmNlabelType, XmPIXMAP,
		XmNlabelPixmap, pixmap,
		XmNx, 390,
		XmNy, 20,
                NULL );

	/* map the bboard */
        XtPopup( XtParent (usrbboard), XtGrabNone );
        XtAppMainLoop( app );
	}   
}   
