/*                              xuser.h

 A C++ header file generated by cpp for xuser.cc

*/

#ifndef _xuser_H_
#define _xuser_H_

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <forms.h>
#include <shadow.h>
#include <pwd.h>
#include <sys/types.h>

#define VERSION "1.00"                  // recompile version.cc
#define YEAR    "1995"

enum USERSTATE_
{
    st_files_ok,    // dont_delete,
    st_make,
    st_delete,
    st_rm_rf,
};

enum USER_FLAGS_                      // shows which int-fields were assigned
{
    u_lstchg    = (1 << 0),           // last password change
    u_uid       = (1 << 1),
    u_gid       = (1 << 2),
    u_min       = (1 << 3),           // days until change allowed.
    u_max       = (1 << 4),           // days before change required
    u_warn      = (1 << 5),           // days warning for expiration
    u_inact     = (1 << 6),           // days before  account  inactive
    u_expire    = (1 << 7),           // date when account expires
    u_flag      = (1 << 8),           // reserved for future use
    u_shadow    = (1 << 9),           // shadow password info available
};

enum DAYTYPE_
{
    d_invalid,
    d_long,
    d_date,                         // since 1970/1/1
};

struct DAY_
{
    long
        value;
    DAYTYPE_
        type;
};

    
struct USER_
{
    char
        *p_name,                        // parsed pw information
        *p_pwd,
        *p_dir,
        *p_shell,
        *c_name,                        // parsed comment information
        *c_office1,
        *c_office2,
        *c_address,
        *s_pwd;                         // parsed shadow information
    long
        sp_lstchg;                      // last password change
    int
        p_uid,
        p_gid,
        sp_min,                         // days until pwchange allowed.
        sp_max,                         // days before change required 
        sp_warn,                        // days warning for expiration 
        sp_inact,                       // days before  account  inactive
        sp_expire,                      // date when account expires 
        sp_flag;                        // reserved for future use
    USERSTATE_
        state;
};

struct APP_DEFAULTS_                    // see the XUser app. defaults file
{
    unsigned
        length,
        fixed,
        change,
        alert,
        entry,
        expiration,
        unlimited;
    char
        *shells,
        *passwd,
        *shadow,
        *backup,
        *group,
        *shell,
        *home,
        *skeleton,
        *groups;
    int
        force_sh,
        options;
};

// directory aux:           auxiliary functions

void        alert(char const *s);               // single string alerting fun()
void        alert(char const *s1,               // double string alerting fun()
                  char const *s2);
void        backup(char const *name);           // make backup 'name-' of 'name'
char const  *commentstr(FL_OBJECT *);           // converted comment
void        defstr(char *&cp, FL_OBJECT *ob);   // def str from object
char        *dir_sep_end(char *);               // 0 if last isn't / 
void        error(char *fmt, ...);              // terminating errorfunction
void        fill_browser(FL_OBJECT *br,         // fill a browser
                int n,                          // with n lines, obtained
                char const *(*linefun)(int));   // from linefun()
void        initialize(int *argc, char **argv); // forms-initializing function
char const  *itoa(int);                         // convert int to char *
char const  *ltodate(long days_since1_1_70);    // convert days -> date
int         name_uid_conflict(char const *name, // 1 if name/uid mismatch
                    int idx);
void        shadowfields();                     // display shadowfields
char const  *strredef(char *&dest,              // redefine by duplicating
                char const *src);
long        unlimited(long arg);                // returns min(arg, unlimited)
FILE        *xfopen(char const *fname,          // file opener
                char const *mode);

// directory callback:      callback functions

void    cb_name(FL_OBJECT *, long arg);         // get the username
void    register_cb(void);                      // register callback functions

// directory errorbrowse:   error browser

void    close_error_browser(FL_OBJECT *,        // close the browser
                long arg);
void    open_error_browser(                     // open the browser
                FL_OBJECT *button, long arg);

// directory forms:         functions creating forms
          
void f_xuser(void);                             // creates mainform
void f_errorbrowser();                          // create errorbrowser
void f_groupbrowser();                          // creates f_browsesgroup
void f_password();                              // creates f_passwd
void f_shellbrowser();                          // creates f_browseshelll
void f_uidbrowser();                            // creates f_browseuid
void f_namebrowser();                           // creates f_browsename
void statebutton(USERSTATE_ state);             // show buttons via up->state

// directory groupbrowse:   group browser

void        close_gp_browser(FL_OBJECT *ob,     // close the groupbrowser
                             long arg);
int         lookup_gid(char const *group);      // lookup gid, given gpname
char const  *lookup_group(int gid);             // lookup gpname, given gid
void        open_gp_browser(                    // open group browser
                FL_OBJECT *group_button,
                long arg);
void        select_group(FL_OBJECT *browser,    // select group by browser
                long arg);

// directory linefun:       linefilling functions for browsers

char const *nameuid(int line);                  // name - uidnr
char const *uidname(int line);                  // uidnr - name

// directory makehome:      making home directory

void    makehome(USER_ *up);                    // make homedir

// directory namebrowse:    name browser

void    close_name_browser(FL_OBJECT *,         // close the name browser
                long arg);
void    open_name_browser(                      // open name browser
                FL_OBJECT *button, long arg);
void    select_name(FL_OBJECT *browser,         // select name by browser
                long arg);

// directory passwd:        functions processing the /etc/password file

void pw_read(void);                             // read the /etc/passwd file
void pw_write(void);                            // write the /etc/passwd file

// directory rmrf:          removing home directory

void    rm_rf();                                // remove dirs in rmlist[]

// directory screen:        functions processing the screen

int   check_screen();                           // screen contents valid ?
void screen_to_memory();                        // save screen to memory

// directory set:           functions setting fields pointed to by un

void    set_gid();                              // set the gid
void    set_shell();                            // set a shell

// directory shadow:        functions processing the /etc/shadow file

void sdw_read(void);                            // read the /etc/shadow file
void sdw_write(void);                           // write the /etc/shadow file

// directory shellbrowse:   shell browser

void        close_shell_browser(FL_OBJECT *ob,  // close the shellbrowser
                             long arg);
int         lookup_shell(char const *sh);       // lookup a standard shell
void        open_shell_browser(                 // open shell browser
                FL_OBJECT *button,
                long arg);
void        select_shell(FL_OBJECT *browser,    // select shell by browser
                long arg);

// directory sort:          sorting user[]

void uid_sort();                                // sort by uid's
void name_sort();                               // sort by names

// directory test:          functions testing the validity of the inputfields

DAY_        test_day(FL_OBJECT *ob);            //  test date-info
char const *test_dir();                         //  0 if invalid, or the homedir
int         test_gid();                         //  -1 if invalid, or groupnr
char const *test_name();                        //  0 if invalid, or the name
char const *test_shell();                       //  0 if invalid, or the shell
int         test_uid();                         //  -2 invalid, -1 none, or
                                                //  the user[] idx
// directory uidbrowse:     uid browser

void    close_uid_browser(FL_OBJECT *,          // close the uid browser
                long arg);
void    open_uid_browser(                       // open uid browser
                FL_OBJECT *button, long arg);
void    select_uid(FL_OBJECT *browser,          // select uid by browser
                long arg);

// directory user:          functions processing the user[] database

USER_   *user_lookup(char const *name);         // lookup username
USER_   *lookup_uid(int id);                    // lookup uid


// Variables:

extern char const
    zerostring[],
    fivestring[],
    sevenstring[],
    xuser[],
    nullstring[],
    r[],
    release[],                              // in version.cc
    w[];

extern FL_FORM
    *f_browsegroup,
    *f_browseerror,
    *f_main,
    *f_browseshell,
    *f_browseuid,
    *f_browsename,
    *f_passwd;

extern USER_
    *up,                                    // points to actual user
    *user;

extern long
    pwchange,
    min,                                    // # of days relative to 
    max,                                    // their base-values
    warn,
    inact,
    expire,
    today;                                  // days since 70/1/1

extern unsigned
    sizeof_res,
    sizeof_cmdopt,
    errors,                                 // counted by the test-button
    hidden_objects,
    nrmlist,                                // size of the removelist
    nusers;

extern FL_OBJECT
    *no_shadow_entry,
    *cancel_passwd,
    *nopasswd,
    *hide_group,
    *copyright,
    *pwd1group,
    *pwd2group,
    *pwdinput1,
    *pwdinput2,
    *button_group,
    *leave_groupbrowser,
    *groupbrowser,
    *leave_shellbrowser,
    *shellbrowser,
    *errorbrowser,
    *leave_errorbrowser,
    *leave_uidbrowser,
    *uidbrowser,
    *namebrowser,
    *name,
    *uid,
    *gid,
    *dir,
    *shell,
    *fullname,
    *office1,
    *office2,
    *address,
    *uid_button,
    *gid_button,
    *shell_button,
    *save_button,
    *cancel_button,
    *accept_button,
    *leave_namebrowser,
    *exit_button,
    *name_button,
    *name_0_button,
    *make_button,
    *files_ok_button,
    *delete_button,
    *rm_rf_button,
    *spwchg,
    *smin,
    *smax,
    *swarn,
    *sinact,
    *sexpire,
    *ssetpw;

extern char
    **rmlist,                               // homedirs to remove by cb_save()
    *pwd;

extern APP_DEFAULTS_
    app_defaults;

extern FL_CMD_OPT
    cmdopt[];

extern FL_resource
    res[];

#endif
