#include "screen.h"

/*
    Situations:
                1. new user: x doesnt point into user[]
                2. existing user: x points into user[], 

    New user:
            state is st_delete or state == st_rm_rf:
                do nothing.

            otherwise:
                1. save the username
                2. expand user[], copy *x (no dup required)
                3  sort
                4. refill uidbrowser
                5. up = lookup(name)

    Existing user:
            state is delete or st_rm_rf
                (for rm_rf: add the homedir to the rmlist)
                1. duplicate up
                2. set button to st_make
                3. remove x from user[]
                4. refill browser

            otherwise:
                do nothing (up already points to correct info in user[]).

*/            
                    
void process(USER_ *x)
{
//    printf("s/pro 1\n");

    if (user <= x && x < user + nusers)          // existing user
    {
        if (x->state == st_delete || x->state == st_rm_rf)
        {
            if (x->state == st_rm_rf)
                addrmlist(x->p_dir);
//    printf("s/pro 2\n");

            up = userdup(x);
            statebutton(access(x->p_dir, F_OK) ? st_make : st_files_ok);
//    printf("s/pro 3\n");

            userdel(x);
//    printf("s/pro 4\n");
        }          
    }
    else if
    (
        x->state != st_delete             // new user, dont' delete
        &&
        x->state != st_rm_rf
    )
    {
        useradd(x);
        uid_sort();
        statebutton(access(up->p_dir, F_OK) ? st_make : st_files_ok);
    }
}
