#include "rm.h"

void rm_rf()
{
    for (int idx = 0; idx < nrmlist; idx++) // walk entries in rmlist[]
    {
        char
            *dest = rmlist[idx],            // first entry to remove
            *home;

        if (home = strrchr(dest, '/'))      // '/' found
            home++;                         // one step beyond
        else                                // no / found: use dest
            home = dest;

        if (!chdir(dest))                   // go to the homedir
        {
// printf("\nnow in %s/\n", dest);

            chdir("..");                    // back to the parent
            rm_dir(home);                   // remove the homedir
        }

        delete dest;                        // free the string
    }
    delete rmlist;                          // free the list

    nrmlist = 0;                            // all empty again
    rmlist = 0;
}

    
