#include "rm.h"

void process(char *pattern)
{
    glob_t
        globvec;

    int
        x;

    if (x = glob(pattern, 0, 0, &globvec))      // glob failed for some reason
    {
//        printf("glob failed with errcode: %d\n", x);
        return;                             // then assume we're done.
    }

//printf("On pattern %s, %d entries\n", pattern, globvec.gl_pathc);

                                            // walk all entries
    for (int index = 0; index < globvec.gl_pathc; index++)
    {
        char
            *entry =  globvec.gl_pathv[index];
        struct stat
            buf;

//printf("    found: %s\n", entry);

        if (stat(entry, &buf))              // no stat info, continue
        {
            delete entry;
            continue;
        }

        if (S_ISDIR(buf.st_mode))           // entry is a directory
            rm_dir(entry);                  // remove it
        else
        {
// printf("\tdeleting %s\n", entry);
            unlink(entry);
        }
        delete entry;
    }

    free(globvec.gl_pathv);
}
